/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.util.Reject;

public final class RealAttributesOnlyRequestControl
implements Control {
    public static final String OID = "2.16.840.1.113730.3.4.17";
    private static final RealAttributesOnlyRequestControl CRITICAL_INSTANCE = new RealAttributesOnlyRequestControl(true);
    private static final RealAttributesOnlyRequestControl NONCRITICAL_INSTANCE = new RealAttributesOnlyRequestControl(false);
    public static final ControlDecoder<RealAttributesOnlyRequestControl> DECODER = new ControlDecoder<RealAttributesOnlyRequestControl>(){

        @Override
        public RealAttributesOnlyRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Reject.ifNull(control);
            if (control instanceof RealAttributesOnlyRequestControl) {
                return (RealAttributesOnlyRequestControl)control;
            }
            if (!control.getOid().equals(RealAttributesOnlyRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_REAL_ATTRS_ONLY_CONTROL_BAD_OID.get(control.getOid(), RealAttributesOnlyRequestControl.OID);
                throw DecodeException.error(message);
            }
            if (control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_REAL_ATTRS_ONLY_INVALID_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            return control.isCritical() ? CRITICAL_INSTANCE : NONCRITICAL_INSTANCE;
        }

        @Override
        public String getOid() {
            return RealAttributesOnlyRequestControl.OID;
        }
    };
    private final boolean isCritical;

    public static RealAttributesOnlyRequestControl newControl(boolean isCritical) {
        return isCritical ? CRITICAL_INSTANCE : NONCRITICAL_INSTANCE;
    }

    private RealAttributesOnlyRequestControl(boolean isCritical) {
        this.isCritical = isCritical;
    }

    @Override
    public String getOid() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        return null;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RealAttributesOnlyRequestControl(oid=");
        builder.append(this.getOid());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(")");
        return builder.toString();
    }
}

