/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import java.util.LinkedHashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.rest2ldap.authz.AuthenticationStrategy;
import org.forgerock.opendj.rest2ldap.authz.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.SecurityContext;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;

final class SimpleBindStrategy
implements AuthenticationStrategy {
    private final ConnectionFactory connectionFactory;
    private final Schema schema;
    private final String bindDnTemplate;

    SimpleBindStrategy(ConnectionFactory connectionFactory, String bindDnTemplate, Schema schema) {
        this.connectionFactory = Reject.checkNotNull(connectionFactory, "connectionFactory cannot be null");
        this.bindDnTemplate = Reject.checkNotNull(bindDnTemplate, "bindDNTemplate cannot be null");
        this.schema = Reject.checkNotNull(schema, "schema cannot be null");
    }

    @Override
    public Promise<SecurityContext, LdapException> authenticate(String username, String password, Context parentContext) {
        AtomicReference<Connection> connectionHolder = new AtomicReference<Connection>();
        return this.connectionFactory.getConnectionAsync().thenAsync(SimpleBindStrategy.doSimpleBind(connectionHolder, parentContext, username, Dn.format(this.bindDnTemplate, this.schema, username), password)).thenFinally(Utils.close(connectionHolder));
    }

    static AsyncFunction<Connection, SecurityContext, LdapException> doSimpleBind(final AtomicReference<Connection> connectionHolder, final Context parentContext, final String username, final Dn bindDN, final String password) {
        return new AsyncFunction<Connection, SecurityContext, LdapException>(){

            @Override
            public Promise<SecurityContext, LdapException> apply(Connection connection) throws LdapException {
                connectionHolder.set(connection);
                return connection.bindAsync(Requests.newSimpleBindRequest(bindDN, password)).then(new Function<BindResult, SecurityContext, LdapException>(){

                    @Override
                    public SecurityContext apply(BindResult result) throws LdapException {
                        LinkedHashMap<String, Object> authzid = new LinkedHashMap<String, Object>(2);
                        authzid.put("dn", bindDN.toString());
                        authzid.put("id", username);
                        return new SecurityContext(parentContext, username, authzid);
                    }
                });
            }
        };
    }
}

