/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.ForbiddenException;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.NotFoundException;
import org.forgerock.json.resource.PermanentException;
import org.forgerock.json.resource.PreconditionFailedException;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.RetryableException;
import org.forgerock.json.resource.Router;
import org.forgerock.json.resource.ServiceUnavailableException;
import org.forgerock.opendj.ldap.AssertionFailureException;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.AuthenticationException;
import org.forgerock.opendj.ldap.AuthorizationException;
import org.forgerock.opendj.ldap.ConnectionException;
import org.forgerock.opendj.ldap.ConstraintViolationException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.EntryNotFoundException;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.MultipleEntriesFoundException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.TimeoutResultException;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.rest2ldap.DescribableRequestHandler;
import org.forgerock.opendj.rest2ldap.JsonConstantPropertyMapper;
import org.forgerock.opendj.rest2ldap.JsonPropertyMapper;
import org.forgerock.opendj.rest2ldap.ObjectPropertyMapper;
import org.forgerock.opendj.rest2ldap.PropertyMapper;
import org.forgerock.opendj.rest2ldap.ReadOnUpdatePolicy;
import org.forgerock.opendj.rest2ldap.ReferencePropertyMapper;
import org.forgerock.opendj.rest2ldap.Resource;
import org.forgerock.opendj.rest2ldap.ResourceTypePropertyMapper;
import org.forgerock.opendj.rest2ldap.Rest2LdapContext;
import org.forgerock.opendj.rest2ldap.SimplePropertyMapper;
import org.forgerock.opendj.rest2ldap.SubResourceCollection;
import org.forgerock.opendj.rest2ldap.SubResourceSingleton;
import org.forgerock.services.context.Context;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;

public final class Rest2Ldap {
    public static final Option<DecodeOptions> DECODE_OPTIONS = Option.withDefault(new DecodeOptions());
    public static final Option<Boolean> USE_MVCC = Option.withDefault(true);
    public static final Option<String> MVCC_ATTRIBUTE = Option.withDefault("etag");
    public static final Option<ReadOnUpdatePolicy> READ_ON_UPDATE_POLICY = Option.withDefault(ReadOnUpdatePolicy.CONTROLS);
    public static final Option<Boolean> USE_PERMISSIVE_MODIFY = Option.withDefault(true);
    public static final Option<Boolean> USE_SUBTREE_DELETE = Option.withDefault(true);
    private final Map<String, Resource> resources = new LinkedHashMap<String, Resource>();
    private final Options options;

    public static Rest2Ldap rest2Ldap(Options options, Collection<Resource> resources) {
        return new Rest2Ldap(options, resources);
    }

    public static Rest2Ldap rest2Ldap(Options options, Resource ... resources) {
        return Rest2Ldap.rest2Ldap(options, Arrays.asList(resources));
    }

    public static Resource resource(String resourceId) {
        return new Resource(resourceId);
    }

    public static SubResourceCollection collectionOf(String resourceId) {
        return new SubResourceCollection(resourceId);
    }

    public static SubResourceSingleton singletonOf(String resourceId) {
        return new SubResourceSingleton(resourceId);
    }

    public static PropertyMapper resourceType() {
        return ResourceTypePropertyMapper.INSTANCE;
    }

    public static PropertyMapper constant(Object value) {
        return new JsonConstantPropertyMapper(value);
    }

    public static ObjectPropertyMapper object() {
        return new ObjectPropertyMapper();
    }

    public static ReferencePropertyMapper reference(AttributeDescription attribute, String baseDnTemplate, AttributeDescription primaryKey, PropertyMapper mapper) {
        return new ReferencePropertyMapper(Schema.getDefaultSchema(), attribute, baseDnTemplate, primaryKey, mapper);
    }

    public static ReferencePropertyMapper reference(String attribute, String baseDnTemplate, String primaryKey, PropertyMapper mapper) {
        return Rest2Ldap.reference(AttributeDescription.valueOf(attribute), baseDnTemplate, AttributeDescription.valueOf(primaryKey), mapper);
    }

    public static SimplePropertyMapper simple(AttributeDescription attribute) {
        return new SimplePropertyMapper(attribute);
    }

    public static SimplePropertyMapper simple(String attribute) {
        return Rest2Ldap.simple(AttributeDescription.valueOf(attribute));
    }

    public static JsonPropertyMapper json(AttributeDescription attribute) {
        return new JsonPropertyMapper(attribute);
    }

    public static JsonPropertyMapper json(String attribute) {
        return Rest2Ldap.json(AttributeDescription.valueOf(attribute));
    }

    public static ResourceException asResourceException(Throwable t) {
        try {
            throw t;
        }
        catch (ResourceException e) {
            return e;
        }
        catch (AssertionFailureException e) {
            return new PreconditionFailedException(e);
        }
        catch (ConstraintViolationException e) {
            ResultCode rc = e.getResult().getResultCode();
            if (rc.equals(ResultCode.ENTRY_ALREADY_EXISTS)) {
                return new PreconditionFailedException(e);
            }
            return new BadRequestException(e);
        }
        catch (AuthenticationException e) {
            return new PermanentException(401, null, e);
        }
        catch (AuthorizationException e) {
            return new ForbiddenException(e);
        }
        catch (ConnectionException e) {
            return new ServiceUnavailableException(e);
        }
        catch (EntryNotFoundException e) {
            return new NotFoundException(e);
        }
        catch (MultipleEntriesFoundException e) {
            return new InternalServerErrorException(e);
        }
        catch (TimeoutResultException e) {
            return new RetryableException(408, null, e);
        }
        catch (LdapException e) {
            ResultCode rc = e.getResult().getResultCode();
            if (rc.equals(ResultCode.ADMIN_LIMIT_EXCEEDED) || rc.equals(ResultCode.SIZE_LIMIT_EXCEEDED)) {
                return new PermanentException(413, null, e);
            }
            return new InternalServerErrorException(e);
        }
        catch (Throwable tmp) {
            return new InternalServerErrorException(t);
        }
    }

    private Rest2Ldap(Options options, Collection<Resource> resources) {
        this.options = options;
        for (Resource resource : resources) {
            this.resources.put(resource.getResourceId(), resource);
        }
        for (Resource resource : resources) {
            resource.build(this);
        }
    }

    public RequestHandler newRequestHandlerFor(String resourceId) {
        Reject.ifTrue(!this.resources.containsKey(resourceId), "unrecognized resource '" + resourceId + "'");
        SubResourceSingleton root = Rest2Ldap.singletonOf(resourceId);
        root.build(this, null);
        return this.rest2LdapContext(root.addRoutes(new Router()));
    }

    private RequestHandler rest2LdapContext(RequestHandler delegate) {
        return new DescribableRequestHandler(delegate){

            @Override
            protected Context wrap(Context context) {
                return new Rest2LdapContext(context, Rest2Ldap.this);
            }
        };
    }

    Options getOptions() {
        return this.options;
    }

    Resource getResource(String resourceId) {
        return this.resources.get(resourceId);
    }
}

