/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.GeneralizedTime;
import org.forgerock.opendj.ldap.schema.AbstractEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class GeneralizedTimeEqualityMatchingRuleImpl
extends AbstractEqualityMatchingRuleImpl {
    GeneralizedTimeEqualityMatchingRuleImpl() {
        super("generalizedTimeMatch");
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        return GeneralizedTimeEqualityMatchingRuleImpl.normalizeAttributeValue(value);
    }

    static ByteString normalizeAttributeValue(ByteSequence value) throws DecodeException {
        try {
            GeneralizedTime time = GeneralizedTime.valueOf(value.toString());
            return GeneralizedTimeEqualityMatchingRuleImpl.createNormalizedAttributeValue(time.getTimeInMillis());
        }
        catch (LocalizedIllegalArgumentException e) {
            throw DecodeException.error(e.getMessageObject());
        }
    }

    static ByteString createNormalizedAttributeValue(long timeInMillis) {
        return ByteString.valueOfLong(timeInMillis - GeneralizedTime.MIN_GENERALIZED_TIME_MS);
    }
}

