/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

final class NullConnectionFactory
implements ConnectionFactory {
    static final NullConnectionFactory INSTANCE = new NullConnectionFactory(NullConnectionFactory.class.getSimpleName(), null);
    private final String name;
    private final LocalizableMessage connectErrorMessage;

    NullConnectionFactory(String name, LocalizableMessage connectErrorMessage) {
        this.name = Reject.checkNotNull(name);
        this.connectErrorMessage = connectErrorMessage;
    }

    @Override
    public Promise<Connection, LdapException> getConnectionAsync() {
        return Promises.newExceptionPromise(this.connectErrorException());
    }

    @Override
    public Connection getConnection() throws LdapException {
        throw this.connectErrorException();
    }

    private LdapException connectErrorException() {
        return LdapException.newLdapException(ResultCode.CLIENT_SIDE_CONNECT_ERROR, this.connectErrorMessage);
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.name;
    }
}

