/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.util.Comparator;
import org.forgerock.opendj.ldap.ByteSequenceReader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;

public interface ByteSequence
extends Comparable<ByteSequence> {
    public static final Comparator<byte[]> BYTE_ARRAY_COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] b1, byte[] b2) {
            return ByteString.compareTo(b1, 0, b1.length, b2, 0, b2.length);
        }
    };
    public static final Comparator<ByteSequence> COMPARATOR = new Comparator<ByteSequence>(){

        @Override
        public int compare(ByteSequence o1, ByteSequence o2) {
            return o1.compareTo(o2);
        }
    };

    public ByteSequenceReader asReader();

    public byte byteAt(int var1);

    public int compareTo(byte[] var1, int var2, int var3);

    @Override
    public int compareTo(ByteSequence var1);

    public byte[] copyTo(byte[] var1);

    public byte[] copyTo(byte[] var1, int var2);

    public ByteStringBuilder copyTo(ByteStringBuilder var1);

    public ByteBuffer copyTo(ByteBuffer var1);

    public boolean copyTo(CharBuffer var1, CharsetDecoder var2);

    public OutputStream copyTo(OutputStream var1) throws IOException;

    public boolean equals(byte[] var1, int var2, int var3);

    public boolean equals(Object var1);

    public int hashCode();

    public boolean isEmpty();

    public int length();

    public ByteSequence subSequence(int var1, int var2);

    public boolean startsWith(ByteSequence var1);

    public String toBase64String();

    public byte[] toByteArray();

    public ByteString toByteString();

    public String toString();
}

