/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.utils;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.forgerock.util.Reject;

public final class DerUtils {
    public static final byte INTEGER_TAG = 2;
    public static final byte SEQUENCE_TAG = 48;

    private DerUtils() {
    }

    public static void readUnsignedInteger(ByteBuffer input, byte[] output, int offset, int length) {
        Reject.ifFalse(input.get() == 2, "Not an integer");
        int len = DerUtils.readLength(input);
        if (len > length && (--len > length || input.get() != 0)) {
            throw new BufferOverflowException();
        }
        input.get(output, offset + (length - len), len);
    }

    public static void writeInteger(ByteBuffer buffer, byte[] data) {
        buffer.put((byte)2);
        int startIndex = data.length - 1;
        for (int index = 0; index < data.length; ++index) {
            if (data[index] == 0) continue;
            startIndex = index;
            break;
        }
        int length = data.length - startIndex;
        DerUtils.writeLength(buffer, length);
        buffer.put(data, startIndex, length);
    }

    public static int readLength(ByteBuffer buffer) {
        byte b = buffer.get();
        if ((b & 0x80) == 0) {
            return b & 0xFF;
        }
        int numBytes = b & 0x7F;
        Reject.ifFalse(numBytes > 0 && numBytes < 4, "Unsupported DER length field");
        int len = 0;
        for (int i = 0; i < numBytes; ++i) {
            len = (len << 8) + (buffer.get() & 0xFF);
        }
        return len;
    }

    public static void writeLength(ByteBuffer output, int length) {
        if ((length & 0x7F) == length) {
            output.put((byte)length);
        } else if ((length & 0xFF) == length) {
            output.put((byte)-127);
            output.put((byte)length);
        } else if ((length & 0xFFFF) == length) {
            output.put((byte)-126);
            output.put((byte)(length >> 8));
            output.put((byte)length);
        } else if ((length & 0xFFFFFF) == length) {
            output.put((byte)-125);
            output.put((byte)(length >> 16));
            output.put((byte)(length >> 8));
            output.put((byte)length);
        } else {
            output.put((byte)-124);
            output.put((byte)(length >> 24));
            output.put((byte)(length >> 16));
            output.put((byte)(length >> 8));
            output.put((byte)length);
        }
    }
}

