/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwk;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.json.JsonException;
import org.forgerock.json.JsonValue;
import org.forgerock.json.jose.exceptions.JweException;
import org.forgerock.json.jose.jwe.JweAlgorithm;
import org.forgerock.json.jose.jwk.EcJWK;
import org.forgerock.json.jose.jwk.KeyOperation;
import org.forgerock.json.jose.jwk.KeyType;
import org.forgerock.json.jose.jwk.KeyUse;
import org.forgerock.json.jose.jwk.OctJWK;
import org.forgerock.json.jose.jwk.RsaJWK;
import org.forgerock.json.jose.jws.JwsAlgorithm;
import org.forgerock.json.jose.jwt.Algorithm;

public abstract class JWK {
    protected static final String JSON_KEY_KTY = "kty";
    protected static final String JSON_KEY_USE = "use";
    protected static final String JSON_KEY_OPERATIONS = "key_ops";
    protected static final String JSON_KEY_ALG = "alg";
    protected static final String JSON_KEY_KID = "kid";
    protected static final String JSON_KEY_X5U = "x5u";
    protected static final String JSON_KEY_X5T = "x5t";
    protected static final String JSON_KEY_X5C = "x5c";
    private final KeyType keyType;
    private final KeyUse use;
    private final Set<KeyOperation> keyOperations;
    private final Algorithm algorithm;
    private final String keyId;
    private final String x509url;
    private final String x509Thumbnail;
    private final List<String> x509Chain;

    @Deprecated
    protected JWK(KeyType keyType, KeyUse use, String algorithm, String keyId) {
        this(keyType, use, algorithm, keyId, null, null, null);
    }

    @Deprecated
    protected JWK(KeyType keyType, KeyUse use, String algorithm, String keyId, String x509url, String x509Thumbnail, List<String> x509Chain) {
        this(keyType, use, null, JWK.getAlgorithm(algorithm), keyId, x509url, x509Thumbnail, x509Chain);
    }

    protected JWK(KeyType keyType, KeyUse use, Set<KeyOperation> keyOperations, Algorithm algorithm, String keyId, String x509url, String x509Thumbnail, List<String> x509Chain) {
        this.keyType = keyType;
        this.keyId = keyId;
        this.use = use;
        this.keyOperations = keyOperations;
        this.algorithm = algorithm;
        this.x509url = x509url;
        this.x509Thumbnail = x509Thumbnail;
        this.x509Chain = x509Chain;
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public KeyUse getUse() {
        return this.use;
    }

    public Set<KeyOperation> getKeyOperations() {
        return this.keyOperations;
    }

    @Deprecated
    public String getAlgorithm() {
        return this.algorithm.getJwaAlgorithmName();
    }

    public Algorithm getJwaAlgorithm() {
        return this.algorithm;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String toJsonString() {
        return this.toJsonValue().toString();
    }

    public JsonValue toJsonValue() {
        JsonValue jsonValue = JsonValue.json(JsonValue.object(JsonValue.field(JSON_KEY_KTY, this.keyType.toString())));
        this.putField(jsonValue, JSON_KEY_KID, this.keyId);
        if (this.use != null) {
            jsonValue.put(JSON_KEY_USE, (Object)this.use.toString());
        }
        if (this.keyOperations != null && !this.keyOperations.isEmpty()) {
            ArrayList<String> keyOperationsNames = new ArrayList<String>();
            for (KeyOperation keyOperation : this.keyOperations) {
                keyOperationsNames.add(keyOperation.getName());
            }
            jsonValue.put(JSON_KEY_OPERATIONS, keyOperationsNames);
        }
        if (this.algorithm != null) {
            this.putField(jsonValue, JSON_KEY_ALG, this.algorithm.getJwaAlgorithmName());
        }
        this.putField(jsonValue, JSON_KEY_X5U, this.x509url);
        this.putField(jsonValue, JSON_KEY_X5T, this.x509Thumbnail);
        if (this.x509Chain != null && !this.x509Chain.isEmpty()) {
            jsonValue.put(JSON_KEY_X5C, this.x509Chain);
        }
        return jsonValue;
    }

    protected void putField(JsonValue jsonValue, String key, Object value) {
        if (value != null) {
            jsonValue.put(key, value);
        }
    }

    public static JWK parse(String json) {
        return JWK.parse(new JsonValue(JWK.toJsonValue(json)));
    }

    public static JWK parse(JsonValue jwk) {
        KeyType keyType = KeyType.getKeyType(jwk.get(JSON_KEY_KTY).asString());
        switch (keyType) {
            case RSA: {
                return RsaJWK.parse(jwk);
            }
            case EC: {
                return EcJWK.parse(jwk);
            }
            case OCT: {
                return OctJWK.parse(jwk);
            }
        }
        throw new JsonException("Failed to parse json invalid kty parameter");
    }

    protected static void loadJWKFromJson(Builder builder, JsonValue json) {
        if (json.get(JSON_KEY_USE).isNotNull()) {
            builder.keyUse(KeyUse.getKeyUse(json.get(JSON_KEY_USE).asString()));
        }
        if (json.get(JSON_KEY_ALG).isNotNull()) {
            builder.algorithm(json.get(JSON_KEY_ALG).asString());
        }
        if (json.get(JSON_KEY_KID).isNotNull()) {
            builder.keyId(json.get(JSON_KEY_KID).asString());
        }
        if (json.get(JSON_KEY_X5U).isNotNull()) {
            builder.x509Url(json.get(JSON_KEY_X5U).asString());
        }
        if (json.get(JSON_KEY_X5T).isNotNull()) {
            builder.x509Thumbnail(json.get(JSON_KEY_X5T).asString());
        }
        if (json.get(JSON_KEY_X5C).isNotNull()) {
            builder.x509Chain(json.get(JSON_KEY_X5C).asList(String.class));
        }
        if (json.get(JSON_KEY_OPERATIONS).isNotNull()) {
            EnumSet<KeyOperation> keyOperations = EnumSet.noneOf(KeyOperation.class);
            for (String operations : json.get(JSON_KEY_OPERATIONS).asList(String.class)) {
                KeyOperation keyOperation = KeyOperation.getKeyOperations(operations);
                if (keyOperation == null) continue;
                keyOperations.add(keyOperation);
            }
            builder.keyOperations(keyOperations);
        }
    }

    public static Algorithm getAlgorithm(String algorithmName) {
        if (algorithmName == null || "none".equals(algorithmName)) {
            return JwsAlgorithm.NONE;
        }
        Enum algorithm = null;
        try {
            algorithm = JweAlgorithm.parseAlgorithm(algorithmName);
        }
        catch (JweException jweException) {
            // empty catch block
        }
        try {
            algorithm = JwsAlgorithm.valueOf(algorithmName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (algorithm != null) {
            return algorithm;
        }
        throw new IllegalArgumentException("algorithm not supported.");
    }

    protected static JsonValue toJsonValue(String json) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return new JsonValue(mapper.readValue(json, Map.class));
        }
        catch (IOException e) {
            throw new JsonException("Failed to parse json", e);
        }
    }

    public String getX509URL() {
        return this.x509url;
    }

    public String getX509Thumbnail() {
        return this.x509Thumbnail;
    }

    public List<String> getX509Chain() {
        return this.x509Chain;
    }

    protected static abstract class Builder<B extends Builder> {
        protected KeyType keyType;
        protected KeyUse use;
        protected Set<KeyOperation> keyOperations;
        protected Algorithm algorithm;
        protected String keyId;
        protected String x509url;
        protected String x509Thumbnail;
        protected List<String> x509Chain;

        protected Builder(KeyType keyType) {
            if (keyType == null) {
                new IllegalArgumentException("keyType is a required field");
            }
            this.keyType = keyType;
        }

        public B keyUse(KeyUse use) {
            this.use = use;
            return (B)this;
        }

        public B keyOperations(Set<KeyOperation> keyOperations) {
            this.keyOperations = keyOperations;
            return (B)this;
        }

        public B algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            return (B)this;
        }

        public B algorithm(String algorithm) {
            this.algorithm = JWK.getAlgorithm(algorithm);
            return (B)this;
        }

        public B keyId(String keyId) {
            this.keyId = keyId;
            return (B)this;
        }

        public B x509Url(String x509url) {
            this.x509url = x509url;
            return (B)this;
        }

        public B x509Thumbnail(String x509Thumbnail) {
            this.x509Thumbnail = x509Thumbnail;
            return (B)this;
        }

        public B x509Chain(List<String> x509Chain) {
            this.x509Chain = x509Chain;
            return (B)this;
        }
    }
}

