/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwe;

import java.security.Key;
import java.util.Arrays;
import org.forgerock.json.jose.jwe.CompressionAlgorithm;
import org.forgerock.json.jose.jwe.CompressionManager;
import org.forgerock.json.jose.jwe.EncryptionManager;
import org.forgerock.json.jose.jwe.JweEncryption;
import org.forgerock.json.jose.jwe.JweHeader;
import org.forgerock.json.jose.jwe.handlers.compression.CompressionHandler;
import org.forgerock.json.jose.jwe.handlers.encryption.EncryptionHandler;
import org.forgerock.json.jose.jwt.Jwt;
import org.forgerock.json.jose.jwt.JwtClaimsSet;
import org.forgerock.json.jose.jwt.JwtHeader;
import org.forgerock.json.jose.jwt.Payload;
import org.forgerock.json.jose.utils.Utils;
import org.forgerock.util.encode.Base64url;

public class EncryptedJwt
implements Jwt,
Payload {
    private final EncryptionManager encryptionManager = new EncryptionManager();
    private final CompressionManager compressionManager = new CompressionManager();
    private final JweHeader header;
    private Payload payload;
    private final Key publicKey;
    private final String encodedHeader;
    private final byte[] encryptedContentEncryptionKey;
    private final byte[] initialisationVector;
    private final byte[] ciphertext;
    private final byte[] authenticationTag;

    public EncryptedJwt(JweHeader header, JwtClaimsSet payload, Key publicKey) {
        this(header, (Payload)payload, publicKey);
    }

    protected EncryptedJwt(EncryptedJwt encryptedJwt) {
        this.header = new JweHeader(encryptedJwt.header.toJsonValue().asMap());
        if (this.payload != null) {
            this.payload = encryptedJwt.payload.copy();
        }
        this.publicKey = encryptedJwt.publicKey;
        this.encodedHeader = encryptedJwt.encodedHeader;
        this.encryptedContentEncryptionKey = Arrays.copyOf(encryptedJwt.encryptedContentEncryptionKey, encryptedJwt.encryptedContentEncryptionKey.length);
        this.initialisationVector = Arrays.copyOf(encryptedJwt.initialisationVector, encryptedJwt.initialisationVector.length);
        this.ciphertext = Arrays.copyOf(encryptedJwt.ciphertext, encryptedJwt.ciphertext.length);
        this.authenticationTag = Arrays.copyOf(encryptedJwt.authenticationTag, encryptedJwt.authenticationTag.length);
    }

    EncryptedJwt(JweHeader header, Payload payload, Key encryptionKey) {
        this.header = header;
        this.payload = payload;
        this.publicKey = encryptionKey;
        this.encodedHeader = null;
        this.encryptedContentEncryptionKey = null;
        this.initialisationVector = null;
        this.ciphertext = null;
        this.authenticationTag = null;
    }

    public EncryptedJwt(JweHeader header, String encodedHeader, byte[] encryptedContentEncryptionKey, byte[] initialisationVector, byte[] ciphertext, byte[] authenticationTag) {
        this.header = header;
        this.encodedHeader = encodedHeader;
        this.encryptedContentEncryptionKey = encryptedContentEncryptionKey;
        this.initialisationVector = initialisationVector;
        this.ciphertext = ciphertext;
        this.authenticationTag = authenticationTag;
        this.publicKey = null;
    }

    @Override
    public JwtHeader getHeader() {
        return this.header;
    }

    @Override
    public JwtClaimsSet getClaimsSet() {
        return (JwtClaimsSet)this.payload;
    }

    Payload getPayload() {
        return this.payload;
    }

    @Override
    public String build() {
        EncryptionHandler encryptionHandler = this.encryptionManager.getEncryptionHandler(this.header);
        Key contentEncryptionKey = encryptionHandler.getContentEncryptionKey();
        if (contentEncryptionKey == null) {
            contentEncryptionKey = this.publicKey;
        }
        byte[] encryptedContentEncryptionKey = encryptionHandler.generateJWEEncryptedKey(this.publicKey, contentEncryptionKey, this.header);
        String encodedEncryptedKey = Base64url.encode(encryptedContentEncryptionKey);
        byte[] initialisationVector = encryptionHandler.generateInitialisationVector();
        String encodedInitialisationVector = Base64url.encode(initialisationVector);
        String jweHeader = this.header.build();
        String encodedJweHeader = Utils.base64urlEncode(jweHeader);
        byte[] plaintext = this.compressPlaintext(this.header.getCompressionAlgorithm(), this.payload.build().getBytes(Utils.CHARSET));
        byte[] additionalAuthenticatedData = encodedJweHeader.getBytes(Utils.CHARSET);
        JweEncryption cipherTextAndAuthTag = encryptionHandler.encryptPlaintext(contentEncryptionKey, initialisationVector, plaintext, additionalAuthenticatedData);
        String encodedCiphertext = Base64url.encode(cipherTextAndAuthTag.getCiphertext());
        String encodedAuthenticationTag = Base64url.encode(cipherTextAndAuthTag.getAuthenticationTag());
        return encodedJweHeader + "." + encodedEncryptedKey + "." + encodedInitialisationVector + "." + encodedCiphertext + "." + encodedAuthenticationTag;
    }

    @Override
    public EncryptedJwt copy() {
        return new EncryptedJwt(this);
    }

    private byte[] compressPlaintext(CompressionAlgorithm compressionAlgorithm, byte[] plaintext) {
        CompressionHandler compressionHandler = this.compressionManager.getCompressionHandler(compressionAlgorithm);
        return compressionHandler.compress(plaintext);
    }

    public void decrypt(Key privateKey) {
        byte[] plaintext = this.decryptRawPayload(privateKey);
        String decryptedPayload = new String(plaintext, Utils.CHARSET);
        this.payload = this.decodePayload(decryptedPayload);
    }

    public byte[] decryptRawPayload(Key privateKey) {
        EncryptionHandler encryptionHandler = this.encryptionManager.getEncryptionHandler(this.header);
        Key contentEncryptionKey = encryptionHandler.decryptContentEncryptionKey(privateKey, this.encryptedContentEncryptionKey, this.header);
        byte[] additionalAuthenticatedData = this.encodedHeader.getBytes(Utils.CHARSET);
        byte[] plaintext = encryptionHandler.decryptCiphertext(contentEncryptionKey, this.initialisationVector, this.ciphertext, this.authenticationTag, additionalAuthenticatedData);
        return this.decompressPlaintext(this.header.getCompressionAlgorithm(), plaintext);
    }

    private byte[] decompressPlaintext(CompressionAlgorithm compressionAlgorithm, byte[] plaintext) {
        CompressionHandler compressionHandler = this.compressionManager.getCompressionHandler(compressionAlgorithm);
        return compressionHandler.decompress(plaintext);
    }

    Payload decodePayload(String decryptedPayload) {
        return new JwtClaimsSet(Utils.parseJson(decryptedPayload));
    }
}

