/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.builders;

import java.net.URL;
import java.util.List;
import org.forgerock.json.jose.builders.JwtBuilder;
import org.forgerock.json.jose.builders.JwtHeaderBuilder;
import org.forgerock.json.jose.jwe.CompressionAlgorithm;
import org.forgerock.json.jose.jwk.JWK;

public abstract class JwtSecureHeaderBuilder<T extends JwtBuilder, B extends JwtSecureHeaderBuilder<T, B>>
extends JwtHeaderBuilder<T, B> {
    public JwtSecureHeaderBuilder(T jwtBuilder) {
        super(jwtBuilder);
    }

    public B jku(URL jku) {
        this.header("jku", jku);
        return (B)this;
    }

    public B jwk(JWK jwk) {
        this.header("jwk", jwk);
        return (B)this;
    }

    public B x5u(URL x5u) {
        this.header("x5u", x5u);
        return (B)this;
    }

    public B x5t(String x5t) {
        this.header("x5t", x5t);
        return (B)this;
    }

    public B x5c(List<String> x5c) {
        this.header("x5c", x5c);
        return (B)this;
    }

    public B kid(String kid) {
        this.header("kid", kid);
        return (B)this;
    }

    public B cty(String cty) {
        this.header("cty", cty);
        return (B)this;
    }

    public B crit(List<String> crit) {
        this.header("crit", crit);
        return (B)this;
    }

    public B zip(CompressionAlgorithm zip) {
        this.header("zip", zip.toString());
        return (B)this;
    }
}

