/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.forgerock.http.io.BranchingInputStream;
import org.forgerock.http.io.Buffer;
import org.forgerock.http.io.IO;
import org.forgerock.util.Factory;

final class BranchingStreamWrapper
extends BranchingInputStream {
    private Trunk trunk;
    private int position;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BranchingStreamWrapper(InputStream in, Factory<Buffer> bufferFactory) {
        super(in instanceof BranchingStreamWrapper ? (BranchingInputStream)in : null);
        if (in instanceof BranchingStreamWrapper) {
            BranchingStreamWrapper bsw = (BranchingStreamWrapper)in;
            this.trunk = bsw.trunk;
            this.position = bsw.position;
        } else {
            this.trunk = new Trunk(in, bufferFactory);
        }
        Trunk trunk = this.trunk;
        synchronized (trunk) {
            this.trunk.branches.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BranchingStreamWrapper(BranchingStreamWrapper bsw) {
        super(bsw.parent());
        this.trunk = bsw.trunk;
        this.position = bsw.position;
        Trunk trunk = this.trunk;
        synchronized (trunk) {
            this.trunk.branches.add(this);
        }
    }

    @Override
    public BranchingStreamWrapper branch() throws IOException {
        this.notClosed();
        return new BranchingStreamWrapper(this, null);
    }

    @Override
    public BranchingStreamWrapper copy() throws IOException {
        this.notClosed();
        return new BranchingStreamWrapper(this);
    }

    boolean isClosed() {
        return this.trunk == null;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        return this.read(b, 0, 1) > 0 ? b[0] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        this.notClosed();
        Trunk trunk = this.trunk;
        synchronized (trunk) {
            int q;
            int n = this.readBuffer(b, off, len);
            if (n == 0) {
                n = this.trunk.in.read(b, off, len);
                if (n >= 0) {
                    this.writeBuffer(b, off, n);
                }
            } else if (n < len && (q = this.trunk.in.read(b, off + n, len - n)) >= 0) {
                this.writeBuffer(b, off + n, q);
                n += q;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            return 0L;
        }
        this.notClosed();
        Trunk trunk = this.trunk;
        synchronized (trunk) {
            if (this.trunk.buffer == null && this.trunk.branches.size() == 1) {
                return this.trunk.in.skip(n);
            }
        }
        return IO.stream(this, IO.nullOutputStream(), (int)Math.min(Integer.MAX_VALUE, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        this.notClosed();
        Trunk trunk = this.trunk;
        synchronized (trunk) {
            int length;
            if (this.trunk.buffer != null && this.position < (length = this.trunk.buffer.length())) {
                return length - this.position;
            }
            return this.trunk.in.available();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.trunk != null) {
            Trunk trunk = this.trunk;
            synchronized (trunk) {
                try {
                    this.closeBranches();
                    this.trunk.branches.remove(this);
                    this.reviewBuffer();
                    if (this.trunk.branches.size() == 0) {
                        this.trunk.in.close();
                    }
                }
                finally {
                    this.trunk = null;
                }
            }
        }
    }

    private void closeBranches() throws IOException {
        ArrayList branches = new ArrayList(this.trunk.branches);
        for (BranchingStreamWrapper branch : branches) {
            if (branch.parent() != this) continue;
            branch.close();
        }
    }

    private void reviewBuffer() throws IOException {
        if (this.trunk.buffer == null) {
            return;
        }
        int length = this.trunk.buffer.length();
        for (BranchingStreamWrapper branch : this.trunk.branches) {
            if (branch.position >= length) continue;
            return;
        }
        this.trunk.buffer.close();
        this.trunk.buffer = null;
    }

    private void notClosed() throws IOException {
        if (this.trunk == null) {
            throw new IOException("stream is closed");
        }
    }

    private int readBuffer(byte[] b, int off, int len) throws IOException {
        int n = 0;
        if (this.trunk.buffer != null && this.trunk.buffer.length() > this.position) {
            n = this.trunk.buffer.read(this.position, b, off, len);
        }
        this.position += n;
        this.reviewBuffer();
        return n;
    }

    private void writeBuffer(byte[] b, int off, int len) throws IOException {
        if (this.trunk.buffer == null && this.trunk.branches.size() > 1) {
            this.trunk.buffer = (Buffer)this.trunk.bufferFactory.newInstance();
            for (BranchingStreamWrapper branch : this.trunk.branches) {
                branch.position = 0;
            }
        }
        if (this.trunk.buffer != null) {
            this.trunk.buffer.append(b, off, len);
            this.position += len;
        }
    }

    private final class Trunk {
        private final List<BranchingStreamWrapper> branches = new ArrayList<BranchingStreamWrapper>();
        private final InputStream in;
        private final Factory<Buffer> bufferFactory;
        private Buffer buffer;

        private Trunk(InputStream in, Factory<Buffer> factory) {
            this.in = in;
            this.bufferFactory = factory;
        }
    }
}

