/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.http.header;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.forgerock.http.protocol.Message;
import org.forgerock.http.util.CaseInsensitiveMap;
import org.forgerock.util.Utils;

public final class HeaderUtil {
    private static final String HTTP_DATE_RFC_1123_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final String LEGACY_RFC_850_DATE_FORMAT = "E, dd-MMM-yy HH:mm:ss zzz";
    private static final String LEGACY_ANSI_C_DATE_FORMAT = "EEE MMM d HH:mm:ss yyyy";
    private static final Pattern UNQUOTE_PATTERN = Pattern.compile("(\\\\)(\\\\|[\"])");

    private HeaderUtil() {
    }

    public static List<String> split(String value, char separator) {
        if (separator == '\"' || separator == '\\') {
            throw new IllegalArgumentException("invalid separator: " + separator);
        }
        ArrayList<String> values = new ArrayList<String>();
        if (value != null) {
            int cp;
            int length = value.length();
            StringBuilder sb = new StringBuilder();
            boolean escaped = false;
            boolean quoted = false;
            for (int n = 0; n < length; n += Character.charCount(cp)) {
                cp = value.codePointAt(n);
                if (escaped) {
                    sb.appendCodePoint(cp);
                    escaped = false;
                    continue;
                }
                if (cp == 92) {
                    sb.appendCodePoint(cp);
                    if (!quoted) continue;
                    escaped = true;
                    continue;
                }
                if (cp == 34) {
                    sb.appendCodePoint(cp);
                    quoted = !quoted;
                    continue;
                }
                if (cp == separator && !quoted) {
                    String s = sb.toString().trim();
                    if (s.length() > 0) {
                        values.add(s);
                    }
                    sb.setLength(0);
                    continue;
                }
                sb.appendCodePoint(cp);
            }
            String s = sb.toString().trim();
            if (s.length() > 0) {
                values.add(s);
            }
        }
        return values;
    }

    public static String join(Collection<String> values, char separator) {
        if (separator == '\"' || separator == '\\') {
            throw new IllegalArgumentException("invalid separator: " + separator);
        }
        StringBuilder sb = new StringBuilder();
        if (values != null) {
            for (String s : values) {
                if (s == null) continue;
                if (sb.length() > 0) {
                    sb.append(separator).append(' ');
                }
                sb.append(s);
            }
        }
        return sb.length() > 0 ? sb.toString() : null;
    }

    public static Parameter parseParameter(String value) {
        int cp;
        boolean wasQuoted = false;
        String headerName = null;
        String headerValue = null;
        boolean inValue = false;
        boolean quoted = false;
        boolean escaped = false;
        int length = value.length();
        StringBuilder sb = new StringBuilder();
        for (int n = 0; n < length; n += Character.charCount(cp)) {
            cp = value.codePointAt(n);
            if (escaped) {
                sb.appendCodePoint(cp);
                escaped = false;
                continue;
            }
            if (cp == 92) {
                if (quoted) {
                    escaped = true;
                    continue;
                }
                sb.appendCodePoint(cp);
                continue;
            }
            if (cp == 34) {
                wasQuoted = true;
                quoted = !quoted;
                continue;
            }
            if (!quoted && !inValue && cp == 61) {
                headerName = sb.toString().trim();
                sb.setLength(0);
                inValue = true;
                continue;
            }
            if (!quoted && Character.isWhitespace(cp)) continue;
            sb.appendCodePoint(cp);
        }
        if (!inValue) {
            headerName = sb.toString().trim();
        } else {
            headerValue = sb.toString();
        }
        return new Parameter(headerName, headerValue, wasQuoted);
    }

    public static Map<String, String> parseParameters(Collection<String> values) {
        CaseInsensitiveMap<String> map = new CaseInsensitiveMap<String>(new HashMap());
        if (values != null) {
            for (String value : values) {
                Parameter param = HeaderUtil.parseParameter(value);
                if (!param.hasName() || map.containsKey(param.getName())) continue;
                map.put(param.getName(), param.getValue());
            }
        }
        return map;
    }

    public static String quote(String value) {
        int cp;
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder("\"");
        int length = value.length();
        for (int n = 0; n < length; n += Character.charCount(cp)) {
            cp = value.codePointAt(n);
            if (cp == 92 || cp == 34) {
                sb.append('\\');
            }
            sb.appendCodePoint(cp);
        }
        sb.append('\"');
        return sb.toString();
    }

    public static String unquote(String value) {
        if (value == null) {
            return null;
        }
        int n = value.length();
        if (n < 2 || value.charAt(0) != '\"' || value.charAt(n - 1) != '\"') {
            throw new IllegalArgumentException("value is not quoted");
        }
        return UNQUOTE_PATTERN.matcher(value.substring(1, n - 1)).replaceAll("$2");
    }

    public static List<String> parseMultiValuedHeader(Message message, String name) {
        List<String> values = message != null && message.getHeaders().containsKey(name) ? message.getHeaders().get(name).getValues() : null;
        return HeaderUtil.parseMultiValuedHeader(HeaderUtil.join(values, ','));
    }

    public static List<String> parseMultiValuedHeader(String header) {
        return HeaderUtil.split(header, ',');
    }

    public static String parseSingleValuedHeader(Message message, String name) {
        if (message == null || !message.getHeaders().containsKey(name)) {
            return null;
        }
        Iterator<String> iterator = message.getHeaders().get(name).getValues().iterator();
        String header = iterator.hasNext() ? iterator.next() : null;
        return header != null ? header : null;
    }

    public static String formatDate(Date date) {
        return HeaderUtil.getDateFormatter(HTTP_DATE_RFC_1123_DATE_FORMAT).format(date);
    }

    public static Date parseDate(String s) {
        if (s == null) {
            return null;
        }
        Date date = HeaderUtil.parseDate(s, HTTP_DATE_RFC_1123_DATE_FORMAT);
        if (date != null) {
            return date;
        }
        date = HeaderUtil.parseDate(s, LEGACY_RFC_850_DATE_FORMAT);
        if (date != null) {
            return date;
        }
        return HeaderUtil.parseDate(s, LEGACY_ANSI_C_DATE_FORMAT);
    }

    private static Date parseDate(String s, String format) {
        try {
            return HeaderUtil.getDateFormatter(format).parse(s);
        }
        catch (ParseException eee) {
            return null;
        }
    }

    private static SimpleDateFormat getDateFormatter(String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format, Locale.ROOT);
        formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formatter;
    }

    public static final class Parameter {
        private final String name;
        private final String value;
        private final boolean wasQuoted;

        Parameter(String name, String value, boolean wasQuoted) {
            this.name = name;
            this.value = value;
            this.wasQuoted = wasQuoted;
        }

        public String getName() {
            return this.name;
        }

        public boolean hasName() {
            return !Utils.isNullOrEmpty(this.name);
        }

        public String getValue() {
            return this.value;
        }

        public boolean wasQuoted() {
            return this.wasQuoted;
        }
    }
}

