/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.api.markup;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.forgerock.api.enums.CountPolicy;
import org.forgerock.api.enums.CreateMode;
import org.forgerock.api.enums.PagingMode;
import org.forgerock.api.enums.PatchOperation;
import org.forgerock.api.enums.Stability;
import org.forgerock.api.markup.ApiDocGeneratorException;
import org.forgerock.api.markup.asciidoc.AsciiDoc;
import org.forgerock.api.markup.asciidoc.AsciiDocTable;
import org.forgerock.api.markup.asciidoc.AsciiDocTableColumnStyles;
import org.forgerock.api.models.Action;
import org.forgerock.api.models.ApiDescription;
import org.forgerock.api.models.ApiError;
import org.forgerock.api.models.Create;
import org.forgerock.api.models.Items;
import org.forgerock.api.models.Operation;
import org.forgerock.api.models.Parameter;
import org.forgerock.api.models.Patch;
import org.forgerock.api.models.Paths;
import org.forgerock.api.models.Query;
import org.forgerock.api.models.Resource;
import org.forgerock.api.models.Schema;
import org.forgerock.api.models.Services;
import org.forgerock.api.models.SubResources;
import org.forgerock.api.models.VersionedPath;
import org.forgerock.api.util.PathUtil;
import org.forgerock.api.util.ReferenceResolver;
import org.forgerock.api.util.ValidationUtil;
import org.forgerock.http.routing.Version;
import org.forgerock.http.util.Json;
import org.forgerock.util.Reject;
import org.forgerock.util.i18n.LocalizableString;
import org.forgerock.util.i18n.PreferredLocales;

public final class ApiDocGenerator {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL).setSerializationInclusion(JsonInclude.Include.NON_EMPTY).enable(SerializationFeature.INDENT_OUTPUT).registerModules(new Json.LocalizableStringModule(), new Json.JsonValueModule());
    private static final PreferredLocales PREFERRED_LOCALES = new PreferredLocales();
    private static final Pattern SERVICE_NAME_PATTERN = Pattern.compile("^([^:]+)[:](\\d(?:\\.\\d)?)$");
    private static final String ADOC_EXTENSION = ".adoc";
    private final boolean inMemoryMode;
    private final Path outputDirPath;
    private final Path inputDirPath;
    private final Map<String, Map<Version, String>> pathTree = new HashMap<String, Map<Version, String>>();
    private final Map<String, String> adocMap = new HashMap<String, String>();
    private final Set<Resource> referencedServices = new HashSet<Resource>();
    private final ApiDescription apiDescription;
    private final ReferenceResolver referenceResolver;

    private ApiDocGenerator(ApiDescription apiDescription, Path inputDirPath, Path outputDirPath, ApiDescription ... externalApiDescriptions) {
        this.apiDescription = Reject.checkNotNull(apiDescription, "apiDescription required");
        this.inputDirPath = inputDirPath;
        this.outputDirPath = outputDirPath;
        boolean bl = this.inMemoryMode = outputDirPath == null;
        if (outputDirPath != null && outputDirPath.equals(inputDirPath)) {
            throw new ApiDocGeneratorException("inputDirPath and outputDirPath can not be equal");
        }
        this.referenceResolver = new ReferenceResolver(apiDescription);
        this.referenceResolver.registerAll(externalApiDescriptions);
    }

    public static void execute(String title, ApiDescription apiDescription, Path inputDirPath, Path outputDirPath, ApiDescription ... externalApiDescriptions) {
        ApiDocGenerator thisInstance = new ApiDocGenerator(apiDescription, inputDirPath, outputDirPath, externalApiDescriptions);
        thisInstance.doExecute(title);
    }

    public static String execute(String title, ApiDescription apiDescription, Path inputDirPath, ApiDescription ... externalApiDescriptions) {
        ApiDocGenerator thisInstance = new ApiDocGenerator(apiDescription, inputDirPath, null, externalApiDescriptions);
        String rootFilename = thisInstance.doExecute(title);
        return thisInstance.toString(rootFilename);
    }

    private String doExecute(String title) {
        String namespace = this.apiDescription.getId();
        try {
            String pathsFilename = this.outputPaths(namespace);
            return this.outputRoot(Reject.checkNotNull(title, "title is required"), pathsFilename, namespace);
        }
        catch (IOException e) {
            throw new ApiDocGeneratorException("Unable to output doc file", e);
        }
    }

    private String outputRoot(String title, String pathsFilename, String parentNamespace) throws IOException {
        String namespace = AsciiDoc.normalizeName(parentNamespace, "index");
        AsciiDoc pathsDoc = AsciiDoc.asciiDoc().documentTitle(title).rawParagraph(AsciiDoc.asciiDoc().rawText("*API ID:* ").mono(this.apiDescription.getId()).toString()).rawParagraph(AsciiDoc.asciiDoc().rawText("*API Version:* ").mono(this.apiDescription.getVersion()).toString()).rawLine(":toc: left").rawLine(":toclevels: 5").newline();
        String description = this.toTranslatedString(this.apiDescription.getDescription());
        String descriptionFilename = this.outputDescriptionBlock(description, namespace);
        pathsDoc.include(descriptionFilename);
        if (pathsFilename != null) {
            pathsDoc.include(pathsFilename);
        }
        String filename = namespace + ADOC_EXTENSION;
        if (this.inMemoryMode) {
            this.adocMap.put(filename, pathsDoc.toString());
        } else {
            pathsDoc.toFile(this.outputDirPath, filename);
        }
        return filename;
    }

    private String outputDescriptionBlock(String defaultDescription, String parentNamespace) throws IOException {
        String namespace = AsciiDoc.normalizeName(parentNamespace, "description");
        String filename = namespace + ADOC_EXTENSION;
        if (!this.copyReplacementFile(filename)) {
            AsciiDoc blockDoc = AsciiDoc.asciiDoc();
            if (!ValidationUtil.isEmpty(defaultDescription)) {
                blockDoc.rawParagraph(defaultDescription);
            }
            if (this.inMemoryMode) {
                this.adocMap.put(filename, blockDoc.toString());
            } else {
                blockDoc.toFile(this.outputDirPath, filename);
            }
        }
        return filename;
    }

    private String outputPaths(String parentNamespace) throws IOException {
        String allPathsDocNamespace = AsciiDoc.normalizeName(parentNamespace, "paths");
        AsciiDoc allPathsDoc = AsciiDoc.asciiDoc().sectionTitle1("Paths");
        Paths paths = this.apiDescription.getPaths();
        ArrayList<String> pathNames = new ArrayList<String>(paths.getNames());
        Collections.sort(pathNames);
        for (String string : pathNames) {
            String pathDocNamespace = AsciiDoc.normalizeName(allPathsDocNamespace, string);
            VersionedPath versionedPath = paths.get(string);
            ArrayList<Version> versions = new ArrayList<Version>(versionedPath.getVersions());
            Collections.sort(versions);
            for (Version version : versions) {
                String versionDocNamespace;
                if (VersionedPath.UNVERSIONED.equals(version)) {
                    versionDocNamespace = pathDocNamespace;
                } else {
                    String versionName = version.toString();
                    versionDocNamespace = AsciiDoc.normalizeName(pathDocNamespace, versionName);
                }
                Resource resource = versionedPath.get(version);
                if (resource.getReference() != null) {
                    resource = this.referenceResolver.getService(resource.getReference());
                    this.referencedServices.add(resource);
                }
                String resourceFilename = this.outputResource(string, version, resource, Collections.emptyList(), versionDocNamespace);
                this.addPathResource(string, version, resourceFilename);
            }
        }
        this.outputUndefinedServices(allPathsDocNamespace);
        ArrayList<String> pathKeys = new ArrayList<String>(this.pathTree.keySet());
        Collections.sort(pathKeys);
        for (String pathKey : pathKeys) {
            allPathsDoc.sectionTitle2(AsciiDoc.asciiDoc().mono(pathKey).toString());
            Map<Version, String> versionMap = this.pathTree.get(pathKey);
            for (Map.Entry<Version, String> entry : versionMap.entrySet()) {
                if (!VersionedPath.UNVERSIONED.equals(entry.getKey())) {
                    allPathsDoc.sectionTitle3(AsciiDoc.asciiDoc().mono(entry.getKey().toString()).toString());
                }
                allPathsDoc.include(entry.getValue());
            }
        }
        String string = allPathsDocNamespace + ADOC_EXTENSION;
        if (this.inMemoryMode) {
            this.adocMap.put(string, allPathsDoc.toString());
        } else {
            allPathsDoc.toFile(this.outputDirPath, string);
        }
        return string;
    }

    private void outputUndefinedServices(String parentNamespace) throws IOException {
        Services services = this.apiDescription.getServices();
        if (services != null && !services.getNames().isEmpty()) {
            for (String name : this.apiDescription.getServices().getNames()) {
                String versionDocNamespace;
                Version serviceVersion;
                String serviceName;
                Resource resource = this.apiDescription.getServices().get(name);
                if (this.referencedServices.contains(resource)) continue;
                Matcher m = SERVICE_NAME_PATTERN.matcher(name);
                if (m.matches()) {
                    serviceName = m.group(1);
                    serviceVersion = Version.version(m.group(2));
                } else {
                    serviceName = name;
                    serviceVersion = VersionedPath.UNVERSIONED;
                }
                String pathDocNamespace = AsciiDoc.normalizeName(parentNamespace, "<undefined>");
                if (VersionedPath.UNVERSIONED.equals(serviceVersion)) {
                    versionDocNamespace = pathDocNamespace;
                } else {
                    String versionName = serviceVersion.toString();
                    versionDocNamespace = AsciiDoc.normalizeName(pathDocNamespace, versionName);
                }
                String pathName = "<undefined>/" + serviceName;
                String resourceFilename = this.outputResource(pathName, serviceVersion, resource, Collections.emptyList(), versionDocNamespace);
                this.addPathResource(pathName, serviceVersion, resourceFilename);
            }
        }
    }

    private String outputResource(String pathName, Version version, Resource resource, List<Parameter> parameters, String parentNamespace) throws IOException {
        boolean unversioned = VersionedPath.UNVERSIONED.equals(version);
        int sectionLevel = unversioned ? 3 : 4;
        String namespace = AsciiDoc.normalizeName(parentNamespace, "resource");
        AsciiDoc resourceDoc = AsciiDoc.asciiDoc();
        String descriptionFilename = this.outputDescriptionBlock(this.toTranslatedString(resource.getDescription()), namespace);
        resourceDoc.include(descriptionFilename);
        this.outputOperation(CrestMethod.CREATE, resource, sectionLevel, parameters, namespace, resourceDoc);
        this.outputOperation(CrestMethod.READ, resource, sectionLevel, parameters, namespace, resourceDoc);
        this.outputOperation(CrestMethod.UPDATE, resource, sectionLevel, parameters, namespace, resourceDoc);
        this.outputOperation(CrestMethod.DELETE, resource, sectionLevel, parameters, namespace, resourceDoc);
        this.outputOperation(CrestMethod.PATCH, resource, sectionLevel, parameters, namespace, resourceDoc);
        this.outputActionOperations(resource, sectionLevel, parameters, namespace, resourceDoc);
        this.outputQueryOperations(resource, sectionLevel, parameters, namespace, resourceDoc);
        this.outputItems(version, resource, parameters, pathName, parentNamespace);
        this.outputSubResources(version, resource.getSubresources(), parameters, pathName, parentNamespace);
        String resourceFilename = namespace + ADOC_EXTENSION;
        if (this.inMemoryMode) {
            this.adocMap.put(resourceFilename, resourceDoc.toString());
        } else {
            resourceDoc.toFile(this.outputDirPath, resourceFilename);
        }
        return resourceFilename;
    }

    private void outputItems(Version version, Resource resource, List<Parameter> parameters, String parentPathName, String parentNamespace) throws IOException {
        Items items = resource.getItems();
        if (items != null) {
            Parameter pathParameter = items.getPathParameter();
            String itemsPathName = parentPathName + "/{" + pathParameter.getName() + "}";
            String itemsPathDocNamespace = AsciiDoc.normalizeName(parentNamespace, itemsPathName);
            Resource itemsResource = items.asResource(resource.isMvccSupported(), resource.getResourceSchema(), resource.getTitle(), resource.getDescription());
            List<Parameter> itemsParameters = PathUtil.mergeParameters(PathUtil.mergeParameters(new ArrayList<Parameter>(parameters), resource.getParameters()), pathParameter);
            this.outputSubResources(version, items.getSubresources(), itemsParameters, itemsPathName, itemsPathDocNamespace);
            String resourceFilename = this.outputResource(parentPathName, version, itemsResource, itemsParameters, itemsPathDocNamespace);
            this.addPathResource(itemsPathName, version, resourceFilename);
        }
    }

    private void outputSubResources(Version version, SubResources subResources, List<Parameter> parameters, String parentPathName, String parentNamespace) throws IOException {
        if (subResources != null) {
            ArrayList<String> subPathNames = new ArrayList<String>(subResources.getNames());
            Collections.sort(subPathNames);
            for (String name : subPathNames) {
                String subPathName = PathUtil.buildPath(parentPathName, name);
                List<Parameter> subresourcesParameters = Collections.unmodifiableList(PathUtil.mergeParameters(new ArrayList<Parameter>(parameters), PathUtil.buildPathParameters(subPathName)));
                String subPathDocNamespace = AsciiDoc.normalizeName(parentNamespace, subPathName);
                Resource subResource = subResources.get(name);
                if (subResource.getReference() != null) {
                    subResource = this.referenceResolver.getService(subResource.getReference());
                    this.referencedServices.add(subResource);
                }
                String resourceFilename = this.outputResource(subPathName, version, subResource, subresourcesParameters, subPathDocNamespace);
                this.addPathResource(subPathName, version, resourceFilename);
            }
        }
    }

    private void outputOperation(CrestMethod crestMethod, Resource resource, int sectionLevel, List<Parameter> parameters, String parentNamespace, AsciiDoc parentDoc) throws IOException {
        Operation operation;
        boolean responseOnly;
        String displayName;
        switch (crestMethod) {
            case CREATE: {
                displayName = "Create";
                responseOnly = false;
                operation = resource.getCreate();
                break;
            }
            case READ: {
                displayName = "Read";
                responseOnly = true;
                operation = resource.getRead();
                break;
            }
            case UPDATE: {
                displayName = "Update";
                responseOnly = false;
                operation = resource.getUpdate();
                break;
            }
            case DELETE: {
                displayName = "Delete";
                responseOnly = true;
                operation = resource.getDelete();
                break;
            }
            case PATCH: {
                displayName = "Patch";
                responseOnly = true;
                operation = resource.getPatch();
                break;
            }
            default: {
                throw new ApiDocGeneratorException("Unsupported CREST method: " + (Object)((Object)crestMethod));
            }
        }
        if (operation != null) {
            String namespace = AsciiDoc.normalizeName(parentNamespace, displayName);
            AsciiDoc operationDoc = AsciiDoc.asciiDoc().sectionTitle(displayName, sectionLevel);
            String description = this.toTranslatedString(operation.getDescription());
            String descriptionFilename = this.outputDescriptionBlock(description, namespace);
            operationDoc.include(descriptionFilename);
            ArrayList<String> headers = new ArrayList<String>();
            ArrayList<Integer> columnWidths = new ArrayList<Integer>();
            AsciiDocTable table = operationDoc.tableStart();
            ApiDocGenerator.outputStability(operation.getStability(), table, headers, columnWidths);
            ApiDocGenerator.outputMvccSupport(resource.isMvccSupported(), table, headers, columnWidths);
            if (crestMethod == CrestMethod.CREATE) {
                Create create = resource.getCreate();
                ApiDocGenerator.outputCreateMode(create.getMode(), table, headers, columnWidths);
                ApiDocGenerator.outputSingletonStatus(create.isSingleton(), table, headers, columnWidths);
            } else if (crestMethod == CrestMethod.PATCH) {
                Patch patch = resource.getPatch();
                ApiDocGenerator.outputSupportedPatchOperations(patch.getOperations(), table, headers, columnWidths);
            }
            table.headers(headers).columnWidths(columnWidths).tableEnd();
            this.outputParameters(operation.getParameters(), parameters, namespace, operationDoc);
            this.outputResourceEntity(resource, responseOnly, operationDoc);
            this.outputErrors(operation.getApiErrors(), operationDoc);
            parentDoc.horizontalRule();
            if (this.inMemoryMode) {
                parentDoc.rawText(operationDoc.toString());
            } else {
                String filename = namespace + ADOC_EXTENSION;
                operationDoc.toFile(this.outputDirPath, filename);
                parentDoc.include(filename);
            }
        }
    }

    private void outputActionOperations(Resource resource, int sectionLevel, List<Parameter> parameters, String parentNamespace, AsciiDoc parentDoc) throws IOException {
        if (!ValidationUtil.isEmpty(resource.getActions())) {
            String namespace = AsciiDoc.normalizeName(parentNamespace, "action");
            AsciiDoc operationDoc = AsciiDoc.asciiDoc();
            for (Action action : resource.getActions()) {
                String filename = this.outputActionOperation(resource, action, sectionLevel, parameters, namespace);
                operationDoc.include(filename);
            }
            if (this.inMemoryMode) {
                parentDoc.rawText(operationDoc.toString());
            } else {
                String filename = namespace + ADOC_EXTENSION;
                operationDoc.toFile(this.outputDirPath, filename);
                parentDoc.include(filename);
            }
        }
    }

    private String outputActionOperation(Resource resource, Action action, int sectionLevel, List<Parameter> parameters, String parentNamespace) throws IOException {
        AsciiDoc blockDoc;
        Schema schema;
        String namespace = AsciiDoc.normalizeName(parentNamespace, action.getName());
        AsciiDoc operationDoc = AsciiDoc.asciiDoc().horizontalRule().sectionTitle(AsciiDoc.asciiDoc().rawText("Action: ").mono(action.getName()).toString(), sectionLevel);
        String description = this.toTranslatedString(action.getDescription());
        String descriptionFilename = this.outputDescriptionBlock(description, namespace);
        operationDoc.include(descriptionFilename);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<Integer> columnWidths = new ArrayList<Integer>();
        AsciiDocTable table = operationDoc.tableStart();
        ApiDocGenerator.outputStability(action.getStability(), table, headers, columnWidths);
        ApiDocGenerator.outputMvccSupport(resource.isMvccSupported(), table, headers, columnWidths);
        table.headers(headers).columnWidths(columnWidths).tableEnd();
        this.outputParameters(action.getParameters(), parameters, namespace, operationDoc);
        if (action.getRequest() != null) {
            schema = action.getRequest().getReference() == null ? action.getRequest() : this.referenceResolver.getDefinition(action.getRequest().getReference());
            blockDoc = AsciiDoc.asciiDoc().blockTitle("Request Entity").rawParagraph("This operation takes a request resource that conforms to the following schema:").listingBlock(OBJECT_MAPPER.writeValueAsString(schema.getSchema().getObject()), "json");
            operationDoc.rawText(blockDoc.toString());
        }
        if (action.getResponse() != null) {
            schema = action.getResponse().getReference() == null ? action.getResponse() : this.referenceResolver.getDefinition(action.getResponse().getReference());
            blockDoc = AsciiDoc.asciiDoc().blockTitle("Response Entity").rawParagraph("This operation returns a response resource that conforms to the following schema:").listingBlock(OBJECT_MAPPER.writeValueAsString(schema.getSchema().getObject()), "json");
            operationDoc.rawText(blockDoc.toString());
        }
        this.outputErrors(action.getApiErrors(), operationDoc);
        String filename = namespace + ADOC_EXTENSION;
        if (this.inMemoryMode) {
            this.adocMap.put(filename, operationDoc.toString());
        } else {
            operationDoc.toFile(this.outputDirPath, filename);
        }
        return filename;
    }

    private void outputQueryOperations(Resource resource, int sectionLevel, List<Parameter> parameters, String parentNamespace, AsciiDoc parentDoc) throws IOException {
        if (!ValidationUtil.isEmpty(resource.getQueries())) {
            String namespace = AsciiDoc.normalizeName(parentNamespace, "query");
            AsciiDoc operationDoc = AsciiDoc.asciiDoc();
            for (Query query : resource.getQueries()) {
                String filename = this.outputQueryOperation(resource, query, sectionLevel, parameters, namespace);
                operationDoc.include(filename);
            }
            String filename = namespace + ADOC_EXTENSION;
            if (this.inMemoryMode) {
                this.adocMap.put(filename, operationDoc.toString());
            } else {
                operationDoc.toFile(this.outputDirPath, filename);
            }
            parentDoc.include(filename);
        }
    }

    private String outputQueryOperation(Resource resource, Query query, int sectionLevel, List<Parameter> parameters, String parentNamespace) throws IOException {
        AsciiDoc blockDoc;
        String namespace;
        AsciiDoc operationDoc = AsciiDoc.asciiDoc().horizontalRule();
        switch (query.getType()) {
            case ID: {
                namespace = AsciiDoc.normalizeName(parentNamespace, "id", query.getQueryId());
                operationDoc.sectionTitle(AsciiDoc.asciiDoc().rawText("Query by ID: ").mono(query.getQueryId()).toString(), sectionLevel);
                break;
            }
            case FILTER: {
                namespace = AsciiDoc.normalizeName(parentNamespace, "filter");
                operationDoc.sectionTitle("Query by Filter", sectionLevel);
                break;
            }
            case EXPRESSION: {
                namespace = AsciiDoc.normalizeName(parentNamespace, "expression");
                operationDoc.sectionTitle("Query by Expression", sectionLevel);
                break;
            }
            default: {
                throw new ApiDocGeneratorException("Unsupported QueryType: " + (Object)((Object)query.getType()));
            }
        }
        String descriptionFilename = this.outputDescriptionBlock(this.toTranslatedString(query.getDescription()), namespace);
        operationDoc.include(descriptionFilename);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<Integer> columnWidths = new ArrayList<Integer>();
        AsciiDocTable table = operationDoc.tableStart();
        ApiDocGenerator.outputStability(query.getStability(), table, headers, columnWidths);
        ApiDocGenerator.outputMvccSupport(resource.isMvccSupported(), table, headers, columnWidths);
        if (!ValidationUtil.isEmpty(query.getQueryableFields())) {
            headers.add(AsciiDoc.asciiDoc().link("query-queryable-fields", "Queryable Fields").toString());
            columnWidths.add(2);
            blockDoc = AsciiDoc.asciiDoc();
            for (String string : query.getQueryableFields()) {
                blockDoc.unorderedList1(AsciiDoc.asciiDoc().mono(string).toString());
            }
            table.columnCell(blockDoc.toString(), AsciiDocTableColumnStyles.ASCII_DOC_CELL);
        }
        if (!ValidationUtil.isEmpty((Object[])query.getPagingModes())) {
            headers.add(AsciiDoc.asciiDoc().link("query-paging-modes", "Paging Modes").toString());
            columnWidths.add(2);
            blockDoc = AsciiDoc.asciiDoc();
            for (PagingMode pagingMode : query.getPagingModes()) {
                blockDoc.unorderedList1(AsciiDoc.asciiDoc().mono(pagingMode.toString()).toString());
            }
            table.columnCell(blockDoc.toString(), AsciiDocTableColumnStyles.ASCII_DOC_CELL);
        }
        if (!ValidationUtil.isEmpty((Object[])query.getCountPolicies())) {
            headers.add(AsciiDoc.asciiDoc().link("query-page-count-policies", "Page Count Policies").toString());
            columnWidths.add(2);
            blockDoc = AsciiDoc.asciiDoc();
            for (CountPolicy countPolicy : query.getCountPolicies()) {
                blockDoc.unorderedList1(AsciiDoc.asciiDoc().mono(countPolicy.toString()).toString());
            }
            table.columnCell(blockDoc.toString(), AsciiDocTableColumnStyles.ASCII_DOC_CELL);
        }
        if (!ValidationUtil.isEmpty(query.getSupportedSortKeys())) {
            headers.add(AsciiDoc.asciiDoc().link("query-sort-keys", "Supported Sort Keys").toString());
            columnWidths.add(2);
            blockDoc = AsciiDoc.asciiDoc();
            for (String string : query.getSupportedSortKeys()) {
                blockDoc.unorderedList1(AsciiDoc.asciiDoc().mono(string).toString());
            }
            table.columnCell(blockDoc.toString(), AsciiDocTableColumnStyles.ASCII_DOC_CELL);
        }
        table.headers(headers).columnWidths(columnWidths).tableEnd();
        this.outputParameters(query.getParameters(), parameters, namespace, operationDoc);
        this.outputResourceEntity(resource, true, operationDoc);
        this.outputErrors(query.getApiErrors(), operationDoc);
        String filename = namespace + ADOC_EXTENSION;
        if (this.inMemoryMode) {
            this.adocMap.put(filename, operationDoc.toString());
        } else {
            operationDoc.toFile(this.outputDirPath, filename);
        }
        return filename;
    }

    private static void outputStability(Stability stability, AsciiDocTable table, List<String> headers, List<Integer> columnWidths) {
        if (stability == null) {
            stability = Stability.STABLE;
        }
        headers.add(AsciiDoc.asciiDoc().link("interface-stability-definitions", "Stability").toString());
        columnWidths.add(1);
        table.columnCell(stability.name());
    }

    private static void outputMvccSupport(boolean mvccSupported, AsciiDocTable table, List<String> headers, List<Integer> columnWidths) {
        headers.add(AsciiDoc.asciiDoc().link("MVCC", "MVCC").toString());
        columnWidths.add(1);
        table.columnCell(mvccSupported ? "&#10003;" : "&#8416;");
    }

    private void outputResourceEntity(Resource resource, boolean responseOnly, AsciiDoc doc) throws IOException {
        if (resource.getResourceSchema() != null) {
            Schema schema = resource.getResourceSchema().getReference() == null ? resource.getResourceSchema() : this.referenceResolver.getDefinition(resource.getResourceSchema().getReference());
            AsciiDoc blockDoc = AsciiDoc.asciiDoc().blockTitle("Resource Entity");
            if (responseOnly) {
                blockDoc.rawParagraph("This operation returns a response resource that conforms to the following schema:");
            } else {
                blockDoc.rawParagraph("This operation takes a request body and returns a response resource that conforms to the following schema:");
            }
            blockDoc.listingBlock(OBJECT_MAPPER.writeValueAsString(schema.getSchema().getObject()), "json");
            doc.rawText(blockDoc.toString());
        }
    }

    private static void outputSingletonStatus(boolean isSingleton, AsciiDocTable table, List<String> headers, List<Integer> columnWidths) {
        headers.add(AsciiDoc.asciiDoc().link("create-singleton", "Singleton").toString());
        columnWidths.add(1);
        table.columnCell(isSingleton ? "&#10003;" : "&#8416;");
    }

    private void outputParameters(Parameter[] operationParameters, List<Parameter> inheritedParameters, String parentNamespace, AsciiDoc doc) throws IOException {
        List<Parameter> parameters = PathUtil.mergeParameters(new ArrayList<Parameter>(inheritedParameters), operationParameters);
        if (parameters.isEmpty()) {
            return;
        }
        String parametersNamespace = AsciiDoc.normalizeName(parentNamespace, "parameters");
        AsciiDocTable table = doc.tableStart().title("Parameters").headers("Name", "Type", "Description", "Required", "In", "Values").columnWidths(2, 1, 4, 1, 1, 2);
        for (Parameter parameter : parameters) {
            String enumValuesContent = null;
            if (!ValidationUtil.isEmpty(parameter.getEnumValues()) || !ValidationUtil.isEmpty(parameter.getDefaultValue())) {
                AsciiDoc enumValuesDoc = AsciiDoc.asciiDoc();
                if (!ValidationUtil.isEmpty(parameter.getDefaultValue())) {
                    enumValuesDoc.italic("Default:").rawText(" ").mono(parameter.getDefaultValue()).newline();
                }
                if (!ValidationUtil.isEmpty(parameter.getEnumValues())) {
                    String[] enumValues = parameter.getEnumValues();
                    String[] enumTitles = parameter.getEnumTitles();
                    for (int i = 0; i < enumValues.length; ++i) {
                        AsciiDoc enumDoc = AsciiDoc.asciiDoc().mono(enumValues[i]);
                        if (enumTitles != null) {
                            enumDoc.rawText(": " + enumTitles[i]);
                        }
                        enumValuesDoc.unorderedList1(enumDoc.toString());
                    }
                }
                enumValuesContent = enumValuesDoc.toString();
            }
            String namespace = AsciiDoc.normalizeName(parametersNamespace, parameter.getName());
            String description = this.toTranslatedString(parameter.getDescription());
            String descriptionFilename = this.outputDescriptionBlock(description, namespace);
            table.columnCell(parameter.getName(), AsciiDocTableColumnStyles.MONO_CELL).columnCell(parameter.getType(), AsciiDocTableColumnStyles.MONO_CELL).columnCell(AsciiDoc.asciiDoc().include(descriptionFilename).toString(), AsciiDocTableColumnStyles.ASCII_DOC_CELL).columnCell(ValidationUtil.nullToFalse(parameter.isRequired()) ? "&#10003;" : null).columnCell(parameter.getSource().name(), AsciiDocTableColumnStyles.MONO_CELL).columnCell(enumValuesContent, AsciiDocTableColumnStyles.ASCII_DOC_CELL).rowEnd();
        }
        table.tableEnd();
    }

    private String toTranslatedString(LocalizableString localizableString) {
        return localizableString == null ? null : localizableString.toTranslatedString(PREFERRED_LOCALES);
    }

    private static void outputCreateMode(CreateMode createMode, AsciiDocTable table, List<String> headers, List<Integer> columnWidths) {
        headers.add("Resource ID");
        columnWidths.add(2);
        AsciiDoc doc = AsciiDoc.asciiDoc();
        switch (createMode) {
            case ID_FROM_CLIENT: {
                doc.rawText("Assigned by client");
                break;
            }
            case ID_FROM_SERVER: {
                doc.rawText("Assigned by server (do not supply)");
                break;
            }
            default: {
                throw new ApiDocGeneratorException("Unsupported CreateMode: " + (Object)((Object)createMode));
            }
        }
        table.columnCell(doc.toString());
    }

    private static void outputSupportedPatchOperations(PatchOperation[] patchOperations, AsciiDocTable table, List<String> headers, List<Integer> columnWidths) {
        headers.add(AsciiDoc.asciiDoc().link("patch-operations", "Patch Operations").toString());
        columnWidths.add(2);
        AsciiDoc blockDoc = AsciiDoc.asciiDoc();
        for (PatchOperation patchOperation : patchOperations) {
            blockDoc.unorderedList1(patchOperation.name());
        }
        table.columnCell(blockDoc.toString(), AsciiDocTableColumnStyles.ASCII_DOC_CELL);
    }

    private void outputErrors(ApiError[] apiErrors, AsciiDoc doc) throws IOException {
        if (!ValidationUtil.isEmpty(apiErrors)) {
            doc.blockTitle("Errors");
            AsciiDocTable table = doc.tableStart().headers("Code", "Description").columnWidths(1, 10);
            ArrayList<ApiError> resolvedErrors = new ArrayList<ApiError>(apiErrors.length);
            for (ApiError error : apiErrors) {
                if (error.getReference() != null) {
                    ApiError resolved = this.referenceResolver.getError(error.getReference());
                    if (resolved == null || resolved.getReference() != null) continue;
                    resolvedErrors.add(resolved);
                    continue;
                }
                resolvedErrors.add(error);
            }
            resolvedErrors.sort(ApiError.ERROR_COMPARATOR);
            for (ApiError error : resolvedErrors) {
                table.columnCell(String.valueOf(error.getCode()), AsciiDocTableColumnStyles.MONO_CELL);
                if (error.getSchema() == null) {
                    table.columnCell(this.toTranslatedString(error.getDescription()));
                } else {
                    Schema schema = error.getSchema().getReference() == null ? error.getSchema() : this.referenceResolver.getDefinition(error.getSchema().getReference());
                    AsciiDoc blockDoc = AsciiDoc.asciiDoc().rawParagraph(this.toTranslatedString(error.getDescription())).rawParagraph("This error may contain an underlying `cause` that conforms to the following schema:").listingBlock(OBJECT_MAPPER.writeValueAsString(schema.getSchema().getObject()), "json");
                    table.columnCell(blockDoc.toString(), AsciiDocTableColumnStyles.ASCII_DOC_CELL);
                }
                table.rowEnd();
            }
            table.tableEnd();
        }
    }

    private boolean copyReplacementFile(String filename) throws IOException {
        if (this.inputDirPath != null) {
            Path inputFilePath = this.inputDirPath.resolve(filename);
            Path outputFilePath = this.outputDirPath.resolve(filename);
            if (Files.exists(inputFilePath, new LinkOption[0])) {
                Files.copy(inputFilePath, outputFilePath, StandardCopyOption.REPLACE_EXISTING);
                return true;
            }
        }
        return false;
    }

    private void addPathResource(String pathName, Version version, String resourceFilename) {
        Map<Version, String> versionTree;
        if (!this.pathTree.containsKey(pathName)) {
            this.pathTree.put(pathName, new LinkedHashMap());
        }
        if (!(versionTree = this.pathTree.get(pathName)).containsKey(version)) {
            versionTree.put(version, resourceFilename);
        }
    }

    private String toString(String rootFilename) {
        if (!this.inMemoryMode) {
            throw new ApiDocGeneratorException("Expected inMemoryMode");
        }
        String s = this.adocMap.get(Reject.checkNotNull(rootFilename));
        Matcher m = AsciiDoc.INCLUDE_PATTERN.matcher(s);
        while (m.find()) {
            String content = this.adocMap.get(m.group(1));
            s = m.replaceFirst(ValidationUtil.isEmpty(content) ? "" : Matcher.quoteReplacement(content));
            m.reset(s);
        }
        return s;
    }

    static enum CrestMethod {
        CREATE,
        READ,
        UPDATE,
        DELETE,
        PATCH,
        ACTION,
        QUERY;

    }
}

