/*
 * Decompiled with CFR 0.152.
 */
package com.inwebo.repackaged.org.glassfish.jersey.model.internal;

import com.inwebo.repackaged.javax.annotation.PreDestroy;
import com.inwebo.repackaged.javax.inject.Inject;
import com.inwebo.repackaged.javax.inject.Singleton;
import com.inwebo.repackaged.org.glassfish.hk2.api.ServiceLocator;
import java.util.HashSet;
import java.util.Set;

@Singleton
public class ManagedObjectsFinalizer {
    @Inject
    private ServiceLocator serviceLocator;
    private final Set<Object> managedObjects = new HashSet<Object>();

    public void registerForPreDestroyCall(Object object) {
        this.managedObjects.add(object);
    }

    @PreDestroy
    public void preDestroy() {
        try {
            for (Object o : this.managedObjects) {
                this.serviceLocator.preDestroy(o);
            }
        }
        finally {
            this.managedObjects.clear();
        }
    }
}

