/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.grizzly;

import com.forgerock.opendj.util.ReferenceCountedObject;
import io.reactivex.Flowable;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.forgerock.opendj.grizzly.GrizzlyLdapConnectionFactory;
import org.forgerock.opendj.grizzly.GrizzlyLdapListener;
import org.forgerock.opendj.ldap.LdapClientContext;
import org.forgerock.opendj.ldap.LdapListener;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.Response;
import org.forgerock.opendj.ldap.spi.LdapConnectionFactoryImpl;
import org.forgerock.opendj.ldap.spi.LdapListenerImpl;
import org.forgerock.opendj.ldap.spi.TransportProvider;
import org.forgerock.util.Options;
import org.glassfish.grizzly.memory.PooledMemoryManager;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;

public final class GrizzlyTransportProvider
implements TransportProvider {
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;

    @Override
    public LdapConnectionFactoryImpl getLdapConnectionFactory(String host, int port, Options options) {
        return new GrizzlyLdapConnectionFactory(host, port, options);
    }

    @Override
    public LdapListenerImpl getLdapListener(Set<InetSocketAddress> addresses, Function<LdapClientContext, BiFunction<Integer, Request, Flowable<Response>>> factory, final Options options) throws IOException {
        return new GrizzlyLdapListener(addresses, factory, options, new ReferenceCountedObject<TCPNIOTransport>(){

            @Override
            protected TCPNIOTransport newInstance() {
                try {
                    return GrizzlyTransportProvider.newTransportFromOptions(options);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void destroyInstance(TCPNIOTransport transport) {
                try {
                    transport.shutdownNow();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    private static TCPNIOTransport newTransportFromOptions(Options options) throws IOException {
        final int bufferSize = options.get(LdapListener.BUFFER_SIZE);
        TCPNIOTransport transport = ((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)((TCPNIOTransportBuilder)TCPNIOTransportBuilder.newInstance().setIOStrategy(SameThreadIOStrategy.getInstance())).setSelectorRunnersCount(options.get(LdapListener.SELECTOR_THREAD_COUNT))).setSelectorThreadPoolConfig(ThreadPoolConfig.defaultConfig().setCorePoolSize(options.get(LdapListener.SELECTOR_THREAD_COUNT)).setMaxPoolSize(options.get(LdapListener.SELECTOR_THREAD_COUNT)).setPoolName(options.get(LdapListener.SELECTOR_THREAD_NAME)))).setLinger((Integer)options.get(LdapListener.SO_LINGER_IN_SECONDS)).setWriteTimeout(options.get(LdapListener.WRITE_TIMEOUT_MS), TimeUnit.MILLISECONDS)).setReuseAddress((Boolean)options.get(LdapListener.SO_REUSE_ADDRESS))).setKeepAlive((Boolean)options.get(LdapListener.SO_KEEPALIVE)).setTcpNoDelay((Boolean)options.get(LdapListener.TCP_NO_DELAY)).setServerConnectionBackLog(options.get(LdapListener.CONNECT_MAX_BACKLOG)).setWriteBufferSize(bufferSize)).setReadBufferSize(bufferSize)).setMemoryManager(new PooledMemoryManager(bufferSize, 2, 2, options.get(LdapListener.SELECTOR_THREAD_COUNT) * 2, GrizzlyTransportProvider.toHeapPercent(0x4000000L), 1.0f, true){

            @Override
            public boolean willAllocateDirect(int size) {
                return size == bufferSize;
            }
        })).build();
        transport.start();
        transport.configureBlocking(options.get(LdapListener.BLOCKING_WRITE));
        return transport;
    }

    private static float toHeapPercent(long size) {
        if (Runtime.getRuntime().maxMemory() < 0x40000000L) {
            return 0.01f;
        }
        return (float)size / (float)Runtime.getRuntime().maxMemory();
    }

    @Override
    public String getName() {
        return "Grizzly";
    }
}

