/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.forgerock.util.Reject;

public final class LoggingCategoryNames {
    private static final Map<String, String> RESOURCE_NAMES = new HashMap<String, String>();
    private static final NavigableMap<String, String> SOURCE_CLASSES = new TreeMap<String, String>();
    private static final String DEFAULT_CATEGORY = "NONE";

    public static String getCategoryName(String className) {
        return LoggingCategoryNames.getCategoryName(className, null);
    }

    public static String getCategoryName(String className, String fallbackCategory) {
        if (className == null) {
            return fallbackCategory == null ? DEFAULT_CATEGORY : fallbackCategory;
        }
        String category = RESOURCE_NAMES.get(className);
        if (category == null) {
            Map.Entry<String, String> entry = SOURCE_CLASSES.floorEntry(className);
            if (entry != null && className.startsWith(entry.getKey())) {
                return entry.getValue();
            }
            return className;
        }
        return category;
    }

    public static void addResourceCategory(String resourcePackage, String category) {
        LoggingCategoryNames.createMapping(RESOURCE_NAMES, resourcePackage, category);
    }

    public static void addSourceCategory(String packageOrClassName, String category) {
        LoggingCategoryNames.createMapping(SOURCE_CLASSES, packageOrClassName, category);
    }

    private static void createMapping(Map<String, String> map, String name, String category) {
        map.put(Reject.checkNotNull(name), Reject.checkNotNull(category));
    }

    private LoggingCategoryNames() {
    }

    static {
        LoggingCategoryNames.addResourceCategory("com.forgerock.opendj.ldap", "SDK");
        LoggingCategoryNames.addSourceCategory("org.forgerock.opendj.ldap", "SDK");
        LoggingCategoryNames.addSourceCategory("org.forgerock.opendj.io", "PROTOCOL");
        LoggingCategoryNames.addSourceCategory("org.forgerock.opendj.grizzly", "PROTOCOL");
        LoggingCategoryNames.addSourceCategory("org.forgerock.opendj.ldap.schema", "SCHEMA");
        LoggingCategoryNames.addResourceCategory("org.forgerock.audit", "AUDIT");
    }
}

