/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.cli;

import com.forgerock.opendj.cli.ArgumentConstants;
import com.forgerock.opendj.cli.BooleanArgument;
import com.forgerock.opendj.cli.CliMessages;
import com.forgerock.opendj.cli.FileBasedArgument;
import com.forgerock.opendj.cli.IntegerArgument;
import com.forgerock.opendj.cli.MultiChoiceArgument;
import com.forgerock.opendj.cli.StringArgument;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.SearchScope;

public final class CommonArguments {
    private CommonArguments() {
    }

    public static BooleanArgument showUsageArgument() {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("help").shortIdentifier(Character.valueOf('H'))).description(CliMessages.INFO_DESCRIPTION_SHOWUSAGE.get())).buildArgument();
    }

    public static BooleanArgument verboseArgument() {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("verbose").shortIdentifier(ArgumentConstants.OPTION_SHORT_VERBOSE)).description(CliMessages.INFO_DESCRIPTION_VERBOSE.get())).buildArgument();
    }

    public static IntegerArgument portArgument(int defaultPort, LocalizableMessage description) {
        return ((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder("port").shortIdentifier(Character.valueOf('p'))).description(description != null ? description : CliMessages.INFO_DESCRIPTION_ADMIN_PORT.get())).range(1, 65535).defaultValue(defaultPort)).valuePlaceholder(CliMessages.INFO_PORT_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument propertiesFileArgument() {
        return ((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("propertiesFilePath").description(CliMessages.INFO_DESCRIPTION_PROP_FILE_PATH.get())).valuePlaceholder(CliMessages.INFO_PROP_FILE_PATH_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument proxyAuthIdArgument() {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("proxyAs").shortIdentifier(Character.valueOf('Y'))).description(CliMessages.INFO_DESCRIPTION_PROXYAUTHZID.get())).valuePlaceholder(CliMessages.INFO_PROXYAUTHID_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument noPropertiesFileArgument() {
        return ((BooleanArgument.Builder)BooleanArgument.builder("noPropertiesFile").description(CliMessages.INFO_DESCRIPTION_NO_PROP_FILE.get())).buildArgument();
    }

    public static BooleanArgument continueOnErrorArgument() {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("continueOnError").shortIdentifier(Character.valueOf('c'))).description(CliMessages.INFO_DESCRIPTION_CONTINUE_ON_ERROR.get())).buildArgument();
    }

    public static StringArgument controlArgument() {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("control").shortIdentifier(ArgumentConstants.OPTION_SHORT_CONTROL)).description(CliMessages.INFO_DESCRIPTION_CONTROLS.get())).docDescriptionSupplement(CliMessages.SUPPLEMENT_DESCRIPTION_CONTROLS.get())).multiValued()).valuePlaceholder(CliMessages.INFO_LDAP_CONTROL_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument quietArgument() {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("quiet").shortIdentifier(ArgumentConstants.OPTION_SHORT_QUIET)).description(CliMessages.INFO_DESCRIPTION_QUIET.get())).buildArgument();
    }

    public static BooleanArgument noOpArgument() {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("dry-run").shortIdentifier(Character.valueOf('n'))).description(CliMessages.INFO_DESCRIPTION_NOOP.get())).buildArgument();
    }

    public static BooleanArgument noPromptArgument() {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("no-prompt").shortIdentifier(ArgumentConstants.OPTION_SHORT_NO_PROMPT)).description(CliMessages.INFO_DESCRIPTION_NO_PROMPT.get())).buildArgument();
    }

    public static BooleanArgument acceptLicenseArgument() {
        return ((BooleanArgument.Builder)BooleanArgument.builder("acceptLicense").description(CliMessages.INFO_OPTION_ACCEPT_LICENSE.get())).buildArgument();
    }

    public static BooleanArgument trustAllArgument() {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("trustAll").shortIdentifier(Character.valueOf('X'))).description(CliMessages.INFO_DESCRIPTION_TRUSTALL.get())).buildArgument();
    }

    public static StringArgument trustStorePathArgument() {
        return CommonArguments.trustStorePathArgument(null);
    }

    public static StringArgument trustStorePathArgument(String defaultValue) {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("trustStorePath").shortIdentifier(Character.valueOf('P'))).description(CliMessages.INFO_DESCRIPTION_TRUSTSTOREPATH.get())).defaultValue(defaultValue)).valuePlaceholder(CliMessages.INFO_TRUSTSTOREPATH_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument trustStorePasswordArgument(LocalizableMessage description) {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("trustStorePassword").shortIdentifier(Character.valueOf('T'))).description(description)).valuePlaceholder(CliMessages.INFO_TRUSTSTORE_PWD_PLACEHOLDER.get())).buildArgument();
    }

    public static FileBasedArgument trustStorePasswordFileArgument() {
        return ((FileBasedArgument.Builder)((FileBasedArgument.Builder)((FileBasedArgument.Builder)FileBasedArgument.builder("trustStorePasswordFile").shortIdentifier(Character.valueOf('U'))).description(CliMessages.INFO_DESCRIPTION_TRUSTSTOREPASSWORD_FILE.get())).valuePlaceholder(CliMessages.INFO_TRUSTSTORE_PWD_FILE_PLACEHOLDER.get())).buildArgument();
    }

    public static IntegerArgument connectTimeOutArgument() {
        return ((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder("connectTimeout").description(CliMessages.INFO_DESCRIPTION_CONNECTION_TIMEOUT.get())).lowerBound(0).defaultValue(30000)).valuePlaceholder(CliMessages.INFO_TIMEOUT_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument cliArgument() {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("cli").shortIdentifier(Character.valueOf('i'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_CLI.get())).buildArgument();
    }

    public static StringArgument.Builder configFileArgumentBuilder() {
        return (StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("configFile").shortIdentifier(Character.valueOf('f'))).description(CliMessages.INFO_DESCRIPTION_CONFIG_FILE.get())).hidden()).required()).valuePlaceholder(CliMessages.INFO_CONFIGFILE_PLACEHOLDER.get());
    }

    public static StringArgument configFileArgument() {
        return CommonArguments.configFileArgumentBuilder().buildArgument();
    }

    public static StringArgument bindDnArgument(String defaultBindDn) {
        return CommonArguments.bindDnArgument(defaultBindDn, CliMessages.INFO_DESCRIPTION_BINDDN.get());
    }

    public static StringArgument bindDnArgument(String defaultBindDN, LocalizableMessage description) {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("bindDn").shortIdentifier(Character.valueOf('D'))).description(description)).defaultValue(defaultBindDN)).valuePlaceholder(CliMessages.INFO_BINDDN_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument bindPasswordArgument() {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("bindPassword").shortIdentifier(Character.valueOf('w'))).description(CliMessages.INFO_DESCRIPTION_BINDPASSWORD.get())).valuePlaceholder(CliMessages.INFO_BINDPWD_PLACEHOLDER.get())).buildArgument();
    }

    public static FileBasedArgument bindPasswordFileArgument() {
        return ((FileBasedArgument.Builder)((FileBasedArgument.Builder)((FileBasedArgument.Builder)FileBasedArgument.builder("bindPasswordFile").shortIdentifier(Character.valueOf('j'))).description(CliMessages.INFO_DESCRIPTION_BINDPASSWORDFILE.get())).valuePlaceholder(CliMessages.INFO_BINDPWD_FILE_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument remoteArgument() {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("remote").shortIdentifier(Character.valueOf('r'))).description(CliMessages.INFO_DESCRIPTION_REMOTE.get())).buildArgument();
    }

    public static BooleanArgument reportAuthzIdArgument() {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("reportAuthzId").shortIdentifier(Character.valueOf('E'))).description(CliMessages.INFO_DESCRIPTION_REPORT_AUTHZID.get())).buildArgument();
    }

    public static BooleanArgument restartArgument() {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("restart").shortIdentifier(Character.valueOf('R'))).description(CliMessages.INFO_DESCRIPTION_RESTART.get())).buildArgument();
    }

    public static StringArgument saslArgument() {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("saslOption").shortIdentifier(Character.valueOf('o'))).description(CliMessages.INFO_LDAP_CONN_DESCRIPTION_SASLOPTIONS.get())).multiValued()).valuePlaceholder(CliMessages.INFO_SASL_OPTION_PLACEHOLDER.get())).buildArgument();
    }

    public static MultiChoiceArgument<SearchScope> searchScopeArgument() {
        return ((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)((MultiChoiceArgument.Builder)MultiChoiceArgument.builder("searchScope").shortIdentifier(Character.valueOf('s'))).description(CliMessages.INFO_SEARCH_DESCRIPTION_SEARCH_SCOPE.get())).allowedValues(SearchScope.values()).defaultValue(SearchScope.WHOLE_SUBTREE)).valuePlaceholder(CliMessages.INFO_SEARCH_SCOPE_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument scriptFriendlyArgument() {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("script-friendly").shortIdentifier(ArgumentConstants.OPTION_SHORT_SCRIPT_FRIENDLY)).description(CliMessages.INFO_DESCRIPTION_SCRIPT_FRIENDLY.get())).buildArgument();
    }

    public static BooleanArgument scriptFriendlySdkArgument() {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("scriptFriendly").shortIdentifier(Character.valueOf('S'))).description(CliMessages.INFO_DESCRIPTION_SCRIPT_FRIENDLY.get())).buildArgument();
    }

    public static BooleanArgument advancedModeArgument() {
        return ((BooleanArgument.Builder)BooleanArgument.builder("advanced").description(CliMessages.INFO_DESCRIPTION_ADVANCED.get())).buildArgument();
    }

    public static BooleanArgument startTlsArgument() {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("useStartTls").shortIdentifier(Character.valueOf('q'))).description(CliMessages.INFO_DESCRIPTION_START_TLS.get())).buildArgument();
    }

    public static BooleanArgument displayEquivalentCommandArgument() {
        return ((BooleanArgument.Builder)BooleanArgument.builder("displayCommand").description(CliMessages.INFO_DESCRIPTION_DISPLAY_EQUIVALENT.get())).buildArgument();
    }

    public static StringArgument equivalentCommandFileArgument(LocalizableMessage description) {
        return ((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("commandFilePath").description(description)).valuePlaceholder(CliMessages.INFO_PATH_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument hostNameArgument(String defaultHostName) {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("hostname").shortIdentifier(Character.valueOf('h'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_HOST_NAME.get())).defaultValue(defaultHostName)).valuePlaceholder(CliMessages.INFO_HOST_PLACEHOLDER.get())).buildArgument();
    }

    public static BooleanArgument useSslArgument() {
        return ((BooleanArgument.Builder)((BooleanArgument.Builder)BooleanArgument.builder("useSsl").shortIdentifier(Character.valueOf('Z'))).description(CliMessages.INFO_DESCRIPTION_USE_SSL.get())).buildArgument();
    }

    public static StringArgument keyStorePasswordArgument() {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("keyStorePassword").shortIdentifier(Character.valueOf('W'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_KEYSTOREPASSWORD.get())).valuePlaceholder(CliMessages.INFO_KEYSTORE_PWD_PLACEHOLDER.get())).buildArgument();
    }

    public static FileBasedArgument keyStorePasswordFileArgument() {
        return ((FileBasedArgument.Builder)((FileBasedArgument.Builder)((FileBasedArgument.Builder)FileBasedArgument.builder("keyStorePasswordFile").shortIdentifier(Character.valueOf('u'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_KEYSTOREPASSWORD_FILE.get())).valuePlaceholder(CliMessages.INFO_KEYSTORE_PWD_FILE_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument keyStorePathArgument() {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("keyStorePath").shortIdentifier(Character.valueOf('K'))).description(CliMessages.INFO_DESCRIPTION_KEYSTOREPATH.get())).valuePlaceholder(CliMessages.INFO_KEYSTOREPATH_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument certNickNameArgument() {
        return ((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("certNickname").shortIdentifier(Character.valueOf('N'))).description(CliMessages.INFO_ARGUMENT_DESCRIPTION_CERT_NICKNAME.get())).multiValued()).valuePlaceholder(CliMessages.INFO_NICKNAME_PLACEHOLDER.get())).buildArgument();
    }

    public static StringArgument adminUid(LocalizableMessage description) {
        return CommonArguments.adminUidArgument(false, description);
    }

    public static StringArgument adminUidHiddenArgument(LocalizableMessage description) {
        return CommonArguments.adminUidArgument(true, description);
    }

    private static StringArgument adminUidArgument(boolean hidden, LocalizableMessage description) {
        StringArgument.Builder builder = (StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)((StringArgument.Builder)StringArgument.builder("adminUid").shortIdentifier(Character.valueOf('I'))).description(description)).defaultValue("admin")).valuePlaceholder(CliMessages.INFO_ADMINUID_PLACEHOLDER.get());
        if (hidden) {
            builder.hidden();
        }
        return builder.buildArgument();
    }

    public static IntegerArgument wrapColumnArgument() {
        return ((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)((IntegerArgument.Builder)IntegerArgument.builder("wrapColumn").shortIdentifier(Character.valueOf('t'))).lowerBound(0).defaultValue(0)).description(CliMessages.INFO_DESCRIPTION_WRAP_COLUMN.get())).valuePlaceholder(CliMessages.INFO_WRAP_COLUMN_PLACEHOLDER.get())).buildArgument();
    }
}

