<#--
 # The contents of this file are subject to the terms of the Common Development and
 # Distribution License (the License). You may not use this file except in compliance with the
 # License.
 #
 # You can obtain a copy of the License at legal/CDDLv1.0.txt. See the License for the
 # specific language governing permission and limitations under the License.
 #
 # When distributing Covered Software, include this CDDL Header Notice in each file and include
 # the License file at legal/CDDLv1.0.txt. If applicable, add the following below the CDDL
 # Header, with the fields enclosed by brackets [] replaced by your own identifying
 # information: "Portions Copyright [year] [name of copyright owner]".
 #
 # Copyright 2017 ForgeRock AS.
 #-->
<!DOCTYPE html>
<html>
  <head>
    <meta charset="UTF-8">
    <meta name="date" content="${now?datetime}">
    <link rel="stylesheet" href="style.css">
    <title>Duration Syntax</title>
  </head>

  <body>
    <h2 class="title">Duration Syntax</h2>

    <p>
    Durations are specified with positive integers and unit specifiers.
    Unit specifiers include the following:
    </p>

    <ul>
    <li><code>ms</code>: milliseconds</li>
    <li><code>s</code>: seconds</li>
    <li><code>m</code>: minutes</li>
    <li><code>h</code>: hours</li>
    <li><code>d</code>: days</li>
    <li><code>w</code>: weeks</li>
    </ul>

    <p>
    An duration of 1 week is specified as <code>1w</code>.
    A duration of 1 week, 1 day, 1 hour, 1 minute, and 1 second
    is specified as <code>1w1d1h1m1s</code>.
    </p>

    <p>
    Not all properties taking a duration allow all unit specifiers.
    For example, milliseconds are not allowed
    if durations smaller than one second are not permitted.
    </p>

    <p>
    Some properties limit minimum or maximum durations.
    </p>

    <p>
    An unlimited duration is specified using
    <code>unlimited</code> (recommended for readability) or <code>-1</code>.
    </p>
  </body>
</html>
