/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util;

import org.forgerock.util.Utils;

public final class Reject {
    public static <T> T checkNotNull(T object) {
        return Reject.checkNotNull(object, null);
    }

    public static <T> T checkNotNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(message);
        }
        return object;
    }

    public static String checkNotBlank(String str) {
        return Reject.checkNotBlank(str, null);
    }

    public static String checkNotBlank(String str, String message) {
        Reject.checkNotNull(str, message);
        Reject.ifTrue(Utils.isBlank(str), message);
        return str;
    }

    public static void ifBlank(String str) {
        Reject.checkNotBlank(str, null);
    }

    public static void ifBlank(String str, String message) {
        Reject.checkNotBlank(str, message);
    }

    public static void ifFalse(boolean condition) {
        Reject.ifFalse(condition, "Expected condition was true, found false");
    }

    public static void ifFalse(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void ifNull(Object object) {
        Reject.ifNull(object, null);
    }

    @SafeVarargs
    public static <T> void ifNull(T ... objects) {
        for (T o : objects) {
            if (o != null) continue;
            throw new NullPointerException();
        }
    }

    public static void ifNull(Object object, String message) {
        Reject.checkNotNull(object, message);
    }

    public static void ifTrue(boolean condition) {
        Reject.ifTrue(condition, "Expected condition was false, found true");
    }

    public static void ifTrue(boolean condition, String message) {
        if (condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void rejectStateIfTrue(boolean condition, String message) {
        if (condition) {
            throw new IllegalStateException(message);
        }
    }

    private Reject() {
    }
}

