/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.security;

import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import org.forgerock.util.Reject;

public final class KeyManagers {
    private static final String KEY_STORE_PROVIDER = "javax.net.ssl.keyStoreProvider";
    private static final String KEY_STORE_TYPE = "javax.net.ssl.keyStoreType";
    private static final String KEY_STORE_FILE = "javax.net.ssl.keyStore";
    private static final String KEY_STORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    private static volatile X509KeyManager jvmKeyManager;

    public static X509KeyManager useKeyStoreFile(String file) throws GeneralSecurityException, IOException {
        return KeyManagers.useKeyStoreFile(file, null, null);
    }

    public static X509KeyManager useKeyStoreFile(String file, char[] password, String format) throws GeneralSecurityException, IOException {
        return KeyManagers.useKeyStoreFile(file, password, format, null);
    }

    public static X509KeyManager useKeyStoreFile(String keyStoreFile, char[] password, String format, String provider) throws GeneralSecurityException, IOException {
        Reject.ifNull(keyStoreFile);
        String keyStoreFormat = format != null ? format : KeyStore.getDefaultType();
        KeyStore keyStore = provider != null ? KeyStore.getInstance(keyStoreFormat, provider) : KeyStore.getInstance(keyStoreFormat);
        try (FileInputStream fis = new FileInputStream(keyStoreFile);){
            keyStore.load(fis, password);
        }
        return KeyManagers.getX509KeyManager(keyStore, password);
    }

    public static X509KeyManager usePkcs11Token(char[] password) throws GeneralSecurityException, IOException {
        KeyStore keyStore = KeyStore.getInstance("PKCS11");
        keyStore.load(null, password);
        return KeyManagers.getX509KeyManager(keyStore, password);
    }

    private static X509KeyManager getX509KeyManager(KeyStore keyStore, char[] password) throws GeneralSecurityException {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        kmf.init(keyStore, password);
        for (KeyManager km : kmf.getKeyManagers()) {
            if (!(km instanceof X509KeyManager)) continue;
            return (X509KeyManager)km;
        }
        throw new NoSuchAlgorithmException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static X509KeyManager useJvmDefaultKeyStore() throws GeneralSecurityException, IOException {
        String keyStoreFile;
        if (jvmKeyManager != null || (keyStoreFile = System.getProperty(KEY_STORE_FILE)) == null) return jvmKeyManager;
        Class<KeyManagers> clazz = KeyManagers.class;
        synchronized (KeyManagers.class) {
            if (jvmKeyManager != null) return jvmKeyManager;
            String keyStoreProvider = System.getProperty(KEY_STORE_PROVIDER);
            String keyStoreType = System.getProperty(KEY_STORE_TYPE, KeyStore.getDefaultType());
            String keyStorePassword = System.getProperty(KEY_STORE_PASSWORD);
            jvmKeyManager = KeyManagers.useKeyStoreFile(keyStoreFile, keyStorePassword != null ? keyStorePassword.toCharArray() : null, keyStoreType, keyStoreProvider);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return jvmKeyManager;
        }
    }

    public static X509KeyManager useSingleCertificate(String alias, X509KeyManager keyManager) {
        Reject.ifNull(alias, keyManager);
        return new SelectCertificate(keyManager, alias);
    }

    private KeyManagers() {
    }

    private static final class SelectCertificate
    extends X509ExtendedKeyManager {
        private final String alias;
        private final X509KeyManager keyManager;

        private SelectCertificate(X509KeyManager keyManager, String alias) {
            this.keyManager = keyManager;
            this.alias = alias;
        }

        @Override
        public String chooseClientAlias(String[] keyType, Principal[] issuers, Socket socket) {
            for (String type : keyType) {
                String[] clientAliases = this.keyManager.getClientAliases(type, issuers);
                if (clientAliases == null) continue;
                for (String clientAlias : clientAliases) {
                    if (!clientAlias.equals(this.alias)) continue;
                    return this.alias;
                }
            }
            return null;
        }

        @Override
        public String chooseEngineClientAlias(String[] keyType, Principal[] issuers, SSLEngine engine) {
            for (String type : keyType) {
                String[] clientAliases = this.keyManager.getClientAliases(type, issuers);
                if (clientAliases == null) continue;
                for (String clientAlias : clientAliases) {
                    if (!clientAlias.equals(this.alias)) continue;
                    return this.alias;
                }
            }
            return null;
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            String[] serverAliases = this.keyManager.getServerAliases(keyType, issuers);
            if (serverAliases != null) {
                for (String serverAlias : serverAliases) {
                    if (!serverAlias.equalsIgnoreCase(this.alias)) continue;
                    return serverAlias;
                }
            }
            return null;
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            String[] serverAliases = this.keyManager.getServerAliases(keyType, issuers);
            if (serverAliases != null) {
                for (String serverAlias : serverAliases) {
                    if (!serverAlias.equals(this.alias)) continue;
                    return this.alias;
                }
            }
            return null;
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.keyManager.getCertificateChain(alias);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getClientAliases(keyType, issuers);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.keyManager.getPrivateKey(alias);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getServerAliases(keyType, issuers);
        }
    }
}

