/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import java.util.concurrent.atomic.AtomicReference;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.messages.SearchResultEntry;
import org.forgerock.opendj.rest2ldap.authz.AuthenticationStrategy;
import org.forgerock.opendj.rest2ldap.authz.SimpleBindStrategy;
import org.forgerock.opendj.rest2ldap.authz.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.services.context.SecurityContext;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Reject;
import org.forgerock.util.promise.Promise;

final class SearchThenBindStrategy
implements AuthenticationStrategy {
    private final ConnectionFactory searchConnectionFactory;
    private final ConnectionFactory bindConnectionFactory;
    private final Dn baseDn;
    private final SearchScope searchScope;
    private final String filterTemplate;

    SearchThenBindStrategy(ConnectionFactory searchConnectionFactory, ConnectionFactory bindConnectionFactory, Dn baseDn, SearchScope searchScope, String filterTemplate) {
        this.searchConnectionFactory = Reject.checkNotNull(searchConnectionFactory, "searchConnectionFactory cannot be null");
        this.bindConnectionFactory = Reject.checkNotNull(bindConnectionFactory, "bindConnectionFactory cannot be null");
        this.baseDn = Reject.checkNotNull(baseDn, "baseDN cannot be null");
        this.searchScope = Reject.checkNotNull(searchScope, "searchScope cannot be null");
        this.filterTemplate = Reject.checkNotNull(filterTemplate, "filterTemplate cannot be null");
    }

    @Override
    public Promise<SecurityContext, LdapException> authenticate(final String username, final String password, final Context parentContext) {
        final AtomicReference searchConnectionHolder = new AtomicReference();
        return this.searchConnectionFactory.getConnectionAsync().thenAsync(new AsyncFunction<Connection, SearchResultEntry, LdapException>(){

            @Override
            public Promise<SearchResultEntry, LdapException> apply(Connection connection) throws LdapException {
                searchConnectionHolder.set(connection);
                return connection.searchSingleEntryAsync(Requests.newSearchRequest(SearchThenBindStrategy.this.baseDn, SearchThenBindStrategy.this.searchScope, Filter.format(SearchThenBindStrategy.this.filterTemplate, username), "1.1"));
            }
        }).thenFinally(Utils.close(searchConnectionHolder)).thenAsync(new AsyncFunction<SearchResultEntry, SecurityContext, LdapException>(){

            @Override
            public Promise<SecurityContext, LdapException> apply(SearchResultEntry searchResult) throws LdapException {
                AtomicReference<Connection> bindConnectionHolder = new AtomicReference<Connection>();
                return SearchThenBindStrategy.this.bindConnectionFactory.getConnectionAsync().thenAsync(SimpleBindStrategy.doSimpleBind(bindConnectionHolder, parentContext, username, searchResult.getName(), password)).thenFinally(Utils.close(bindConnectionHolder));
            }
        });
    }
}

