/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap.authz;

import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.rest2ldap.authz.AuthenticationStrategy;
import org.forgerock.opendj.rest2ldap.authz.SaslPlainStrategy;
import org.forgerock.opendj.rest2ldap.authz.SearchThenBindStrategy;
import org.forgerock.opendj.rest2ldap.authz.SimpleBindStrategy;

public final class AuthenticationStrategies {
    private AuthenticationStrategies() {
    }

    public static AuthenticationStrategy newSimpleBindStrategy(ConnectionFactory connectionFactory, String bindDNTemplate, Schema schema) {
        return new SimpleBindStrategy(connectionFactory, bindDNTemplate, schema);
    }

    public static AuthenticationStrategy newSearchThenBindStrategy(ConnectionFactory searchConnectionFactory, ConnectionFactory bindConnectionFactory, Dn baseDN, SearchScope searchScope, String filterTemplate) {
        return new SearchThenBindStrategy(searchConnectionFactory, bindConnectionFactory, baseDN, searchScope, filterTemplate);
    }

    public static AuthenticationStrategy newSaslPlainStrategy(ConnectionFactory connectionFactory, Schema schema, String authcIdTemplate) {
        return new SaslPlainStrategy(connectionFactory, schema, authcIdTemplate);
    }
}

