/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import org.forgerock.api.models.ApiDescription;
import org.forgerock.http.ApiProducer;
import org.forgerock.http.routing.RoutingMode;
import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.RouteMatchers;
import org.forgerock.json.resource.Router;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.Rdn;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.messages.SearchResultEntry;
import org.forgerock.opendj.rest2ldap.AbstractRequestHandler;
import org.forgerock.opendj.rest2ldap.AuthenticatedConnectionContext;
import org.forgerock.opendj.rest2ldap.NamingStrategy;
import org.forgerock.opendj.rest2ldap.Resource;
import org.forgerock.opendj.rest2ldap.Rest2Ldap;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.RoutingContext;
import org.forgerock.opendj.rest2ldap.SubResource;
import org.forgerock.opendj.rest2ldap.SubResourceImpl;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.util.AsyncFunction;
import org.forgerock.util.Function;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public final class SubResourceCollection
extends SubResource {
    private final Attribute glueObjectClasses = new LinkedAttribute("objectClass");
    private NamingStrategy namingStrategy;

    SubResourceCollection(String resourceId) {
        super(resourceId);
        this.useClientDnNaming("uid");
    }

    public SubResourceCollection useClientDnNaming(String dnAttribute) {
        this.namingStrategy = new DnNamingStrategy(dnAttribute);
        return this;
    }

    public SubResourceCollection useClientNaming(String dnAttribute, String idAttribute) {
        this.namingStrategy = new AttributeNamingStrategy(dnAttribute, idAttribute, false);
        return this;
    }

    public SubResourceCollection useServerEntryUuidNaming(String dnAttribute) {
        return this.useServerNaming(dnAttribute, "entryUUID");
    }

    public SubResourceCollection useServerNaming(String dnAttribute, String idAttribute) {
        this.namingStrategy = new AttributeNamingStrategy(dnAttribute, idAttribute, true);
        return this;
    }

    public SubResourceCollection urlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
        return this;
    }

    public SubResourceCollection dnTemplate(String dnTemplate) {
        this.dnTemplateString = dnTemplate;
        return this;
    }

    public SubResourceCollection glueObjectClass(String objectClass) {
        this.glueObjectClasses.add(new Object[]{objectClass});
        return this;
    }

    public SubResourceCollection glueObjectClasses(String ... objectClasses) {
        this.glueObjectClasses.add(objectClasses);
        return this;
    }

    public SubResourceCollection isReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
        return this;
    }

    @Override
    Router addRoutes(Router router) {
        router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.EQUALS, this.urlTemplate), this.readOnly(new CollectionHandler()));
        router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.EQUALS, this.urlTemplate + "/{id}"), this.readOnly(new InstanceHandler()));
        router.addRoute(RouteMatchers.requestUriMatcher(RoutingMode.STARTS_WITH, this.urlTemplate + "/{id}"), this.readOnly(new SubResource.SubResourceHandler()));
        return router;
    }

    @Override
    Promise<RoutingContext, ResourceException> route(final Context context) {
        Connection conn = context.asContext(AuthenticatedConnectionContext.class).getConnection();
        SearchRequest searchRequest = this.namingStrategy.createSearchRequest(this.dnFrom(context), this.idFrom(context));
        if (searchRequest.getScope().equals(SearchScope.BASE_OBJECT) && !this.resource.hasSubTypesWithSubResources()) {
            return Promises.newResultPromise(RoutingContext.newRoutingContext(context, searchRequest.getName(), this.resource));
        }
        searchRequest.addAttribute("objectClass");
        return conn.searchSingleEntryAsync(searchRequest).thenAsync(new AsyncFunction<SearchResultEntry, RoutingContext, ResourceException>(){

            @Override
            public Promise<RoutingContext, ResourceException> apply(SearchResultEntry entry) throws ResourceException {
                Resource subType = SubResourceCollection.this.resource.resolveSubTypeFromObjectClasses(entry);
                return Promises.newResultPromise(RoutingContext.newRoutingContext(context, entry.getName(), subType));
            }
        }, new AsyncFunction<LdapException, RoutingContext, ResourceException>(){

            @Override
            public Promise<RoutingContext, ResourceException> apply(LdapException e) throws ResourceException {
                return Rest2Ldap.asResourceException(e).asPromise();
            }
        });
    }

    private SubResourceImpl collection(Context context) {
        return new SubResourceImpl(this.rest2Ldap, this.dnFrom(context), this.dnTemplateString.isEmpty() ? null : this.glueObjectClasses, this.namingStrategy, this.resource);
    }

    private String idFrom(Context context) {
        return context.asContext(UriRouterContext.class).getUriTemplateVariables().get("id");
    }

    private final class InstanceHandler
    extends AbstractRequestHandler {
        private InstanceHandler() {
        }

        @Override
        public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
            return SubResourceCollection.this.collection(context).action(context, SubResourceCollection.this.idFrom(context), request);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handleCreate(Context context, final CreateRequest request) {
            return SubResourceCollection.this.route(context).thenAsync(new AsyncFunction<RoutingContext, ResourceResponse, ResourceException>(){

                @Override
                public Promise<ResourceResponse, ResourceException> apply(RoutingContext context) {
                    return SubResourceCollection.this.subResourceRouterFrom(context).handleCreate(context, request);
                }
            }).thenCatch(this.convert404To400());
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handleDelete(Context context, DeleteRequest request) {
            return SubResourceCollection.this.collection(context).delete(context, SubResourceCollection.this.idFrom(context), request);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handlePatch(Context context, PatchRequest request) {
            return SubResourceCollection.this.collection(context).patch(context, SubResourceCollection.this.idFrom(context), request);
        }

        @Override
        public Promise<QueryResponse, ResourceException> handleQuery(Context context, final QueryRequest request, final QueryResourceHandler handler) {
            return SubResourceCollection.this.route(context).thenAsync(new AsyncFunction<RoutingContext, QueryResponse, ResourceException>(){

                @Override
                public Promise<QueryResponse, ResourceException> apply(RoutingContext context) {
                    return SubResourceCollection.this.subResourceRouterFrom(context).handleQuery(context, request, handler);
                }
            }).thenCatch(this.convert404To400());
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handleRead(Context context, ReadRequest request) {
            return SubResourceCollection.this.collection(context).read(context, SubResourceCollection.this.idFrom(context), request);
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handleUpdate(Context context, UpdateRequest request) {
            return SubResourceCollection.this.collection(context).update(context, SubResourceCollection.this.idFrom(context), request);
        }

        private <T> Function<ResourceException, T, ResourceException> convert404To400() {
            return SubResource.convert404To400(Rest2ldapMessages.ERR_UNSUPPORTED_REQUEST_AGAINST_INSTANCE.get());
        }

        @Override
        public ApiDescription api(ApiProducer<ApiDescription> producer) {
            return null;
        }
    }

    private final class CollectionHandler
    extends AbstractRequestHandler {
        private CollectionHandler() {
        }

        @Override
        public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
            return new NotSupportedException(Rest2ldapMessages.ERR_COLLECTION_ACTIONS_NOT_SUPPORTED.get().toString()).asPromise();
        }

        @Override
        public Promise<ResourceResponse, ResourceException> handleCreate(Context context, CreateRequest request) {
            return SubResourceCollection.this.collection(context).create(context, request);
        }

        @Override
        public Promise<QueryResponse, ResourceException> handleQuery(Context context, QueryRequest request, QueryResourceHandler handler) {
            return SubResourceCollection.this.collection(context).query(context, request, handler);
        }

        @Override
        protected <V> Promise<V, ResourceException> handleRequest(Context context, Request request) {
            return new BadRequestException(Rest2ldapMessages.ERR_UNSUPPORTED_REQUEST_AGAINST_COLLECTION.get().toString()).asPromise();
        }

        @Override
        public ApiDescription api(ApiProducer<ApiDescription> producer) {
            return SubResourceCollection.this.resource.collectionApi(SubResourceCollection.this.isReadOnly);
        }
    }

    private static final class DnNamingStrategy
    implements NamingStrategy {
        private final AttributeDescription attribute;

        private DnNamingStrategy(String attribute) {
            this.attribute = AttributeDescription.valueOf(attribute);
        }

        @Override
        public SearchRequest createSearchRequest(Dn baseDn, String resourceId) {
            return Requests.newSearchRequest(baseDn.child(this.rdn(resourceId)), SearchScope.BASE_OBJECT, Filter.objectClassPresent(), new String[0]);
        }

        @Override
        public String getResourceIdLdapAttribute() {
            return this.attribute.toString();
        }

        @Override
        public String decodeResourceId(Entry entry) {
            return entry.parseAttribute(this.attribute).asString();
        }

        @Override
        public void encodeResourceId(Dn baseDn, String resourceId, Entry entry) throws ResourceException {
            if (resourceId != null) {
                entry.setName(baseDn.child(this.rdn(resourceId)));
                entry.addAttribute(new LinkedAttribute(this.attribute, (Object)ByteString.valueOfUtf8(resourceId)));
            } else if (entry.getAttribute(this.attribute) != null) {
                entry.setName(baseDn.child(this.rdn(entry.parseAttribute(this.attribute).asString())));
            } else {
                throw Utils.newBadRequestException(Rest2ldapMessages.ERR_CLIENT_PROVIDED_RESOURCE_ID_MISSING.get());
            }
        }

        private Rdn rdn(String resourceId) {
            return new Rdn(this.attribute.getAttributeType(), (Object)resourceId);
        }
    }

    private static final class AttributeNamingStrategy
    implements NamingStrategy {
        private final AttributeDescription dnAttribute;
        private final AttributeDescription idAttribute;
        private final boolean isServerProvided;

        private AttributeNamingStrategy(String dnAttribute, String idAttribute, boolean isServerProvided) {
            this.dnAttribute = AttributeDescription.valueOf(dnAttribute);
            this.idAttribute = AttributeDescription.valueOf(idAttribute);
            if (this.dnAttribute.equals(this.idAttribute)) {
                throw new LocalizedIllegalArgumentException(Rest2ldapMessages.ERR_CONFIG_NAMING_STRATEGY_DN_AND_ID_NOT_DIFFERENT.get());
            }
            this.isServerProvided = isServerProvided;
        }

        @Override
        public SearchRequest createSearchRequest(Dn baseDn, String resourceId) {
            return Requests.newSearchRequest(baseDn, SearchScope.SINGLE_LEVEL, Filter.equality(this.idAttribute.toString(), resourceId), new String[0]);
        }

        @Override
        public String getResourceIdLdapAttribute() {
            return this.idAttribute.toString();
        }

        @Override
        public String decodeResourceId(Entry entry) {
            return entry.parseAttribute(this.idAttribute).asString();
        }

        @Override
        public void encodeResourceId(Dn baseDn, String resourceId, Entry entry) throws ResourceException {
            if (this.isServerProvided) {
                if (resourceId != null) {
                    throw Utils.newBadRequestException(Rest2ldapMessages.ERR_SERVER_PROVIDED_RESOURCE_ID_UNEXPECTED.get());
                }
            } else {
                entry.addAttribute(new LinkedAttribute(this.idAttribute, (Object)ByteString.valueOfUtf8(resourceId)));
            }
            String rdnValue = entry.parseAttribute(this.dnAttribute).asString();
            Rdn rdn = new Rdn(this.dnAttribute.getAttributeType(), (Object)rdnValue);
            entry.setName(baseDn.child(rdn));
        }
    }
}

