/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.rest2ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.CoreSchema;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.rest2ldap.AbstractLdapPropertyMapper;
import org.forgerock.opendj.rest2ldap.FilterType;
import org.forgerock.opendj.rest2ldap.Resource;
import org.forgerock.opendj.rest2ldap.Rest2Ldap;
import org.forgerock.opendj.rest2ldap.Rest2ldapMessages;
import org.forgerock.opendj.rest2ldap.Utils;
import org.forgerock.services.context.Context;
import org.forgerock.util.Function;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public final class SimplePropertyMapper
extends AbstractLdapPropertyMapper<SimplePropertyMapper> {
    private Function<ByteString, ?, ? extends Exception> decoder;
    private Function<Object, ByteString, ? extends Exception> encoder;
    private JsonValue jsonSchema;

    SimplePropertyMapper(AttributeDescription ldapAttributeName) {
        super(ldapAttributeName);
    }

    public SimplePropertyMapper decoder(Function<ByteString, ?, ? extends Exception> f) {
        this.decoder = f;
        return this;
    }

    public SimplePropertyMapper defaultJsonValue(Object defaultValue) {
        this.defaultJsonValues = defaultValue != null ? Collections.singletonList(defaultValue) : Collections.emptyList();
        return this;
    }

    public SimplePropertyMapper defaultJsonValues(Collection<?> defaultValues) {
        this.defaultJsonValues = defaultValues != null ? new ArrayList(defaultValues) : Collections.emptyList();
        return this;
    }

    public SimplePropertyMapper encoder(Function<Object, ByteString, ? extends Exception> f) {
        this.encoder = f;
        return this;
    }

    public SimplePropertyMapper isBinary(boolean isBinary) {
        if (isBinary) {
            this.decoder = Utils.byteStringToBase64();
            this.encoder = Utils.base64ToByteString();
        } else {
            this.decoder = null;
            this.encoder = null;
        }
        return this;
    }

    public SimplePropertyMapper jsonSchema(JsonValue jsonSchema) {
        this.jsonSchema = jsonSchema;
        return this;
    }

    public String toString() {
        return "simple(" + this.ldapAttributeName + ")";
    }

    @Override
    Promise<Filter, ResourceException> getLdapFilter(Context context, Resource resource, JsonPointer path, JsonPointer subPath, FilterType type, String operator, Object valueAssertion) {
        if (subPath.isEmpty()) {
            try {
                ByteString va = valueAssertion != null ? this.encoder().apply(valueAssertion) : null;
                return Promises.newResultPromise(Utils.toFilter(type, this.ldapAttributeName.toString(), va));
            }
            catch (Exception e) {
                return Utils.newBadRequestException(Rest2ldapMessages.ERR_ILLEGAL_FILTER_ASSERTION_VALUE.get(String.valueOf(valueAssertion), path), e).asPromise();
            }
        }
        return Promises.newResultPromise(Filter.alwaysFalse());
    }

    @Override
    Promise<Attribute, ResourceException> getNewLdapAttributes(Context context, Resource resource, JsonPointer path, List<Object> newValues) {
        try {
            return Promises.newResultPromise(Utils.jsonToAttribute(newValues, this.ldapAttributeName, this.encoder()));
        }
        catch (Exception ex) {
            return Utils.newBadRequestException(Rest2ldapMessages.ERR_ENCODING_VALUES_FOR_FIELD.get(path, ex.getMessage())).asPromise();
        }
    }

    @Override
    SimplePropertyMapper getThis() {
        return this;
    }

    @Override
    Promise<JsonValue, ResourceException> read(Context context, Resource resource, JsonPointer path, Entry e) {
        try {
            Set<?> s = e.parseAttribute(this.ldapAttributeName).asSetOf(this.decoder(), this.defaultJsonValues);
            switch (s.size()) {
                case 0: {
                    return Promises.newResultPromise(null);
                }
                case 1: {
                    if (!this.attributeIsSingleValued()) break;
                    return Promises.newResultPromise(new JsonValue(s.iterator().next()));
                }
            }
            return Promises.newResultPromise(new JsonValue(new ArrayList(s)));
        }
        catch (Exception ex) {
            return Rest2Ldap.asResourceException(ex).asPromise();
        }
    }

    private Function<ByteString, ?, ? extends Exception> decoder() {
        return this.decoder == null ? Utils.byteStringToJson(this.ldapAttributeName) : this.decoder;
    }

    private Function<Object, ByteString, ? extends Exception> encoder() {
        return this.encoder == null ? Utils.jsonToByteString(this.ldapAttributeName) : this.encoder;
    }

    @Override
    JsonValue toJsonSchema() {
        return this.jsonSchema != null ? this.jsonSchema : this.toJsonSchema0();
    }

    private JsonValue toJsonSchema0() {
        AttributeType attrType = this.ldapAttributeName.getAttributeType();
        JsonValue jsonSchema = this.isMultiValued() ? JsonValue.json(JsonValue.object(JsonValue.field("type", "array"), JsonValue.field("uniqueItems", true), JsonValue.field("items", this.itemsSchema(attrType).getObject()))) : this.itemsSchema(attrType);
        String description = attrType.getDescription();
        if (description != null && !"".equals(description)) {
            jsonSchema.put("title", (Object)description);
        }
        this.putWritabilityProperties(jsonSchema);
        return jsonSchema;
    }

    private JsonValue itemsSchema(AttributeType attrType) {
        JsonValue itemsSchema = JsonValue.json(JsonValue.object(new Map.Entry[0]));
        SimplePropertyMapper.putTypeAndFormat(itemsSchema, attrType);
        return itemsSchema;
    }

    public static void putTypeAndFormat(JsonValue jsonSchema, AttributeType attrType) {
        if (attrType.isPlaceHolder()) {
            jsonSchema.put("type", (Object)"string");
            return;
        }
        Syntax syntax = attrType.getSyntax();
        if (attrType.hasName("userPassword")) {
            jsonSchema.put("type", (Object)"string");
            jsonSchema.put("format", (Object)"password");
        } else if (attrType.hasName("mail")) {
            jsonSchema.put("type", (Object)"string");
            jsonSchema.put("format", (Object)"email");
        } else if (syntax.equals(CoreSchema.getBooleanSyntax())) {
            jsonSchema.put("type", (Object)"boolean");
        } else if (syntax.equals(CoreSchema.getNumericStringSyntax())) {
            jsonSchema.put("type", (Object)"string");
        } else if (syntax.equals(CoreSchema.getIntegerSyntax())) {
            jsonSchema.put("type", (Object)"integer");
        } else if (syntax.equals(CoreSchema.getGeneralizedTimeSyntax())) {
            jsonSchema.put("type", (Object)"string");
            jsonSchema.put("format", (Object)"date-time");
        } else if (!syntax.isHumanReadable()) {
            jsonSchema.put("type", (Object)"string");
            jsonSchema.put("format", (Object)"byte");
        } else {
            jsonSchema.put("type", (Object)"string");
        }
    }
}

