/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Matcher;
import org.forgerock.opendj.ldap.schema.AttributeType;

abstract class AbstractLdifStream {
    final Set<AttributeDescription> excludeAttributes = new HashSet<AttributeDescription>();
    final Set<Dn> excludeBranches = new HashSet<Dn>();
    final List<Matcher> excludeFilters = new LinkedList<Matcher>();
    boolean excludeOperationalAttributes;
    boolean excludeUserAttributes;
    final Set<AttributeDescription> includeAttributes = new HashSet<AttributeDescription>();
    final Set<Dn> includeBranches = new HashSet<Dn>();
    final List<Matcher> includeFilters = new LinkedList<Matcher>();

    AbstractLdifStream() {
    }

    final boolean isAttributeExcluded(AttributeDescription attributeDescription) {
        if (!this.excludeAttributes.isEmpty() && this.excludeAttributes.contains(attributeDescription)) {
            return true;
        }
        if (!this.includeAttributes.isEmpty()) {
            return !this.includeAttributes.contains(attributeDescription);
        }
        AttributeType type = attributeDescription.getAttributeType();
        return this.excludeOperationalAttributes && type.isOperational() || this.excludeUserAttributes && !type.isOperational();
    }

    final boolean isBranchExcluded(Dn dn) {
        if (!this.excludeBranches.isEmpty()) {
            for (Dn excludeBranch : this.excludeBranches) {
                if (!excludeBranch.isSuperiorOrEqualTo(dn)) continue;
                return true;
            }
        }
        if (!this.includeBranches.isEmpty()) {
            for (Dn includeBranch : this.includeBranches) {
                if (!includeBranch.isSuperiorOrEqualTo(dn)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    final boolean isEntryExcluded(Entry entry) {
        if (!this.excludeFilters.isEmpty()) {
            for (Matcher excludeFilter : this.excludeFilters) {
                if (!excludeFilter.matches(entry).toBoolean()) continue;
                return true;
            }
        }
        if (!this.includeFilters.isEmpty()) {
            for (Matcher includeFilter : this.includeFilters) {
                if (!includeFilter.matches(entry).toBoolean()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

