/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.Syntax;

final class GenerateCoreSchema {
    private static final Set<String> ABBREVIATIONS = new HashSet<String>(Arrays.asList("SASL", "LDAP", "DN", "DIT", "RDN", "JPEG", "OID", "UUID", "IA5", "UID", "UTC", "X500", "X121", "C", "CN", "O", "OU", "L", "DC", "ISDN", "SN", "ST"));

    public static void main(String[] args) {
        String description;
        GenerateCoreSchema.testSplitNameIntoWords();
        Schema schema = Schema.getCoreSchema();
        TreeMap<String, Syntax> syntaxes = new TreeMap<String, Syntax>();
        for (Syntax syntax : schema.getSyntaxes()) {
            if (GenerateCoreSchema.isOpenDSOID(syntax.getOid())) continue;
            String name = syntax.getDescription().replaceAll(" Syntax$", "");
            String fieldName = name.replace(" ", "_").replaceAll("[.-]", "").toUpperCase(Locale.ENGLISH).concat("_SYNTAX");
            syntaxes.put(fieldName, syntax);
        }
        TreeMap<String, MatchingRule> matchingRules = new TreeMap<String, MatchingRule>();
        for (MatchingRule matchingRule : schema.getMatchingRules()) {
            if (GenerateCoreSchema.isOpenDSOID(matchingRule.getOid()) || GenerateCoreSchema.isCollationMatchingRule(matchingRule.getOid())) continue;
            String name = matchingRule.getNameOrOid().replaceAll("Match$", "");
            String fieldName = GenerateCoreSchema.splitNameIntoWords(name).concat("_MATCHING_RULE");
            matchingRules.put(fieldName, matchingRule);
        }
        TreeMap<String, AttributeType> attributeTypes = new TreeMap<String, AttributeType>();
        for (AttributeType attributeType : schema.getAttributeTypes()) {
            if (GenerateCoreSchema.isOpenDSOID(attributeType.getOid())) continue;
            String name = attributeType.getNameOrOid();
            String fieldName = GenerateCoreSchema.splitNameIntoWords(name).concat("_ATTRIBUTE_TYPE");
            attributeTypes.put(fieldName, attributeType);
        }
        TreeMap<String, ObjectClass> objectClasses = new TreeMap<String, ObjectClass>();
        for (ObjectClass objectClass : schema.getObjectClasses()) {
            if (GenerateCoreSchema.isOpenDSOID(objectClass.getOid())) continue;
            String name = objectClass.getNameOrOid();
            String fieldName = GenerateCoreSchema.splitNameIntoWords(name.replace("-", "")).concat("_OBJECT_CLASS");
            objectClasses.put(fieldName, objectClass);
        }
        PrintStream out = System.out;
        out.println("/*");
        out.println(" * The contents of this file are subject to the terms of the Common Development and");
        out.println(" * Distribution License (the License). You may not use this file except in compliance with the");
        out.println(" * License.");
        out.println(" *");
        out.println(" * You can obtain a copy of the License at legal/CDDLv1.0.txt. See the License for the");
        out.println(" * specific language governing permission and limitations under the License.");
        out.println(" *");
        out.println(" * When distributing Covered Software, include this CDDL Header Notice in each file and include");
        out.println(" * the License file at legal/CDDLv1.0.txt. If applicable, add the following below the CDDL");
        out.println(" * Header, with the fields enclosed by brackets [] replaced by your own identifying");
        out.println(" * information: \"Portions Copyright [year] [name of copyright owner]\".");
        out.println(" *");
        out.println(" * Copyright 2009 Sun Microsystems, Inc.");
        out.println(" * Portions copyright 2014-" + Calendar.getInstance().get(1) + " ForgeRock AS.");
        out.println(" */");
        out.println("package org.forgerock.opendj.ldap.schema;");
        out.println();
        out.println();
        out.println("// DON'T EDIT THIS FILE!");
        out.println("// It is automatically generated using GenerateCoreSchema class.");
        out.println();
        out.println("/**");
        out.println(" * The OpenDJ SDK core schema contains standard LDAP RFC schema elements. These include:");
        out.println(" * <ul>");
        out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc4512\">RFC 4512 -");
        out.println(" * Lightweight Directory Access Protocol (LDAP): Directory Information");
        out.println(" * Models </a>");
        out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc4517\">RFC 4517 -");
        out.println(" * Lightweight Directory Access Protocol (LDAP): Syntaxes and Matching");
        out.println(" * Rules </a>");
        out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc4519\">RFC 4519 -");
        out.println(" * Lightweight Directory Access Protocol (LDAP): Schema for User");
        out.println(" * Applications </a>");
        out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc4530\">RFC 4530 -");
        out.println(" * Lightweight Directory Access Protocol (LDAP): entryUUID Operational");
        out.println(" * Attribute </a>");
        out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc3045\">RFC 3045 - Storing");
        out.println(" * Vendor Information in the LDAP Root DSE </a>");
        out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc3112\">RFC 3112 - LDAP");
        out.println(" * Authentication Password Schema </a>");
        out.println(" * </ul>");
        out.println(" * <p>");
        out.println(" * The core schema is non-strict: attempts to retrieve");
        out.println(" * non-existent Attribute Types will return a temporary");
        out.println(" * Attribute Type having the Octet String syntax.");
        out.println(" */");
        out.println("public final class CoreSchema {");
        out.println("    // Core Syntaxes");
        for (Map.Entry syntax : syntaxes.entrySet()) {
            out.println("    private static final Syntax " + (String)syntax.getKey() + " =");
            out.println("        CoreSchemaImpl.getInstance().getSyntax(\"" + ((Syntax)syntax.getValue()).getOid() + "\");");
        }
        out.println();
        out.println("    // Core Matching Rules");
        for (Map.Entry matchingRule : matchingRules.entrySet()) {
            out.println("    private static final MatchingRule " + (String)matchingRule.getKey() + " =");
            out.println("        CoreSchemaImpl.getInstance().getMatchingRule(\"" + ((MatchingRule)matchingRule.getValue()).getOid() + "\");");
        }
        out.println();
        out.println("    // Core Attribute Types");
        for (Map.Entry attributeType : attributeTypes.entrySet()) {
            out.println("    private static final AttributeType " + (String)attributeType.getKey() + " =");
            out.println("        CoreSchemaImpl.getInstance().getAttributeType(\"" + ((AttributeType)attributeType.getValue()).getOid() + "\");");
        }
        out.println();
        out.println("    // Core Object Classes");
        for (Map.Entry objectClass : objectClasses.entrySet()) {
            out.println("    private static final ObjectClass " + (String)objectClass.getKey() + " =");
            out.println("        CoreSchemaImpl.getInstance().getObjectClass(\"" + ((ObjectClass)objectClass.getValue()).getOid() + "\");");
        }
        out.println();
        out.println("    // Prevent instantiation");
        out.println("    private CoreSchema() {");
        out.println("      // Nothing to do.");
        out.println("    }");
        out.println();
        out.println("    /**");
        out.println("     * Returns a reference to the singleton core schema.");
        out.println("     *");
        out.println("     * @return The core schema.");
        out.println("     */");
        out.println("    public static Schema getInstance() {");
        out.println("        return CoreSchemaImpl.getInstance();");
        out.println("    }");
        for (Map.Entry syntax : syntaxes.entrySet()) {
            out.println();
            description = GenerateCoreSchema.toCodeJavaDoc(((Syntax)syntax.getValue()).getDescription().replaceAll(" Syntax$", "") + " Syntax");
            out.println("    /**");
            out.println("     * Returns a reference to the " + description);
            out.println("     * which has the OID " + GenerateCoreSchema.toCodeJavaDoc(((Syntax)syntax.getValue()).getOid()) + ".");
            out.println("     *");
            out.println("     * @return A reference to the " + description + ".");
            out.println("     */");
            out.println("    public static Syntax get" + GenerateCoreSchema.toJavaName((String)syntax.getKey()) + "() {");
            out.println("        return " + (String)syntax.getKey() + ";");
            out.println("    }");
        }
        for (Map.Entry matchingRule : matchingRules.entrySet()) {
            out.println();
            description = GenerateCoreSchema.toCodeJavaDoc(((MatchingRule)matchingRule.getValue()).getNameOrOid());
            out.println("    /**");
            out.println("     * Returns a reference to the " + description + " Matching Rule");
            out.println("     * which has the OID " + GenerateCoreSchema.toCodeJavaDoc(((MatchingRule)matchingRule.getValue()).getOid()) + ".");
            out.println("     *");
            out.println("     * @return A reference to the " + description + " Matching Rule.");
            out.println("     */");
            out.println("    public static MatchingRule get" + GenerateCoreSchema.toJavaName((String)matchingRule.getKey()) + "() {");
            out.println("        return " + (String)matchingRule.getKey() + ";");
            out.println("    }");
        }
        for (Map.Entry attributeType : attributeTypes.entrySet()) {
            out.println();
            description = GenerateCoreSchema.toCodeJavaDoc(((AttributeType)attributeType.getValue()).getNameOrOid());
            out.println("    /**");
            out.println("     * Returns a reference to the " + description + " Attribute Type");
            out.println("     * which has the OID " + GenerateCoreSchema.toCodeJavaDoc(((AttributeType)attributeType.getValue()).getOid()) + ".");
            out.println("     *");
            out.println("     * @return A reference to the " + description + " Attribute Type.");
            out.println("     */");
            out.println("    public static AttributeType get" + GenerateCoreSchema.toJavaName((String)attributeType.getKey()) + "() {");
            out.println("        return " + (String)attributeType.getKey() + ";");
            out.println("    }");
        }
        for (Map.Entry objectClass : objectClasses.entrySet()) {
            out.println();
            description = GenerateCoreSchema.toCodeJavaDoc(((ObjectClass)objectClass.getValue()).getNameOrOid());
            out.println("    /**");
            out.println("     * Returns a reference to the " + description + " Object Class");
            out.println("     * which has the OID " + GenerateCoreSchema.toCodeJavaDoc(((ObjectClass)objectClass.getValue()).getOid()) + ".");
            out.println("     *");
            out.println("     * @return A reference to the " + description + " Object Class.");
            out.println("     */");
            out.println("    public static ObjectClass get" + GenerateCoreSchema.toJavaName((String)objectClass.getKey()) + "() {");
            out.println("        return " + (String)objectClass.getKey() + ";");
            out.println("    }");
        }
        out.println("}");
    }

    private static boolean isOpenDSOID(String oid) {
        return oid.startsWith("1.3.6.1.4.1.26027.1.");
    }

    private static boolean isCollationMatchingRule(String oid) {
        return oid.startsWith("1.3.6.1.4.1.42.2.27.9.4.");
    }

    private static String splitNameIntoWords(String name) {
        String splitName = name.replaceAll("([A-Z][a-z])", "_$1");
        splitName = splitName.replaceAll("([a-z])([A-Z])", "$1_$2");
        splitName = splitName.replaceAll("[-.]", "");
        return splitName.toUpperCase(Locale.ENGLISH);
    }

    private static void testSplitNameIntoWords() {
        String[][] values;
        for (String[] test : values = new String[][]{{"oneTwoThree", "ONE_TWO_THREE"}, {"oneTWOThree", "ONE_TWO_THREE"}, {"oneX500Three", "ONE_X500_THREE"}, {"oneTwoX500", "ONE_TWO_X500"}, {"oneTwoX500", "ONE_TWO_X500"}, {"x500TwoThree", "X500_TWO_THREE"}}) {
            String expected;
            String actual = GenerateCoreSchema.splitNameIntoWords(test[0]);
            if (actual.equals(expected = test[1])) continue;
            System.out.println("Test Split Failure: " + test[0] + " -> " + actual + " != " + expected);
        }
    }

    private static String toCodeJavaDoc(String text) {
        return String.format("{@code %s}", text);
    }

    private static String toJavaName(String splitName) {
        StringBuilder builder = new StringBuilder();
        for (String word : splitName.split("_")) {
            if (ABBREVIATIONS.contains(word)) {
                builder.append(word);
                continue;
            }
            builder.append(word.charAt(0));
            if (word.length() <= 1) continue;
            builder.append(word.substring(1).toLowerCase(Locale.ENGLISH));
        }
        return builder.toString();
    }

    private GenerateCoreSchema() {
    }
}

