/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.schema.AbstractEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class DistinguishedNameEqualityMatchingRuleImpl
extends AbstractEqualityMatchingRuleImpl {
    DistinguishedNameEqualityMatchingRuleImpl() {
        super("distinguishedNameMatch");
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        try {
            Dn dn = Dn.valueOf(value.toString(), schema.asNonStrictSchema());
            return dn.toNormalizedByteString();
        }
        catch (LocalizedIllegalArgumentException e) {
            throw DecodeException.error(e.getMessageObject());
        }
    }

    @Override
    public String keyToHumanReadableString(ByteSequence key) {
        return key.toByteString().toAsciiString();
    }
}

