/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class CoreSchemaSupportedLocales {
    private static final Map<String, String> JVM_SUPPORTED_LOCALE_NAMES_TO_OIDS;

    public static Map<String, String> getJvmSupportedLocaleNamesToOids() {
        return JVM_SUPPORTED_LOCALE_NAMES_TO_OIDS;
    }

    private CoreSchemaSupportedLocales() {
    }

    static {
        HashMap<String, String> localeNamesToOids = new HashMap<String, String>();
        localeNamesToOids.put("af", "1.3.6.1.4.1.42.2.27.9.4.1.1");
        localeNamesToOids.put("am", "1.3.6.1.4.1.42.2.27.9.4.2.1");
        localeNamesToOids.put("ar", "1.3.6.1.4.1.42.2.27.9.4.3.1");
        localeNamesToOids.put("ar-AE", "1.3.6.1.4.1.42.2.27.9.4.4.1");
        localeNamesToOids.put("ar-BH", "1.3.6.1.4.1.42.2.27.9.4.5.1");
        localeNamesToOids.put("ar-DZ", "1.3.6.1.4.1.42.2.27.9.4.6.1");
        localeNamesToOids.put("ar-EG", "1.3.6.1.4.1.42.2.27.9.4.7.1");
        localeNamesToOids.put("ar-IN", "1.3.6.1.4.1.42.2.27.9.4.8.1");
        localeNamesToOids.put("ar-IQ", "1.3.6.1.4.1.42.2.27.9.4.9.1");
        localeNamesToOids.put("ar-JO", "1.3.6.1.4.1.42.2.27.9.4.10.1");
        localeNamesToOids.put("ar-KW", "1.3.6.1.4.1.42.2.27.9.4.11.1");
        localeNamesToOids.put("ar-LB", "1.3.6.1.4.1.42.2.27.9.4.12.1");
        localeNamesToOids.put("ar-LY", "1.3.6.1.4.1.42.2.27.9.4.13.1");
        localeNamesToOids.put("ar-MA", "1.3.6.1.4.1.42.2.27.9.4.14.1");
        localeNamesToOids.put("ar-OM", "1.3.6.1.4.1.42.2.27.9.4.15.1");
        localeNamesToOids.put("ar-QA", "1.3.6.1.4.1.42.2.27.9.4.16.1");
        localeNamesToOids.put("ar-SA", "1.3.6.1.4.1.42.2.27.9.4.17.1");
        localeNamesToOids.put("ar-SD", "1.3.6.1.4.1.42.2.27.9.4.18.1");
        localeNamesToOids.put("ar-SY", "1.3.6.1.4.1.42.2.27.9.4.19.1");
        localeNamesToOids.put("ar-TN", "1.3.6.1.4.1.42.2.27.9.4.20.1");
        localeNamesToOids.put("ar-YE", "1.3.6.1.4.1.42.2.27.9.4.21.1");
        localeNamesToOids.put("be", "1.3.6.1.4.1.42.2.27.9.4.22.1");
        localeNamesToOids.put("bg", "1.3.6.1.4.1.42.2.27.9.4.23.1");
        localeNamesToOids.put("bn", "1.3.6.1.4.1.42.2.27.9.4.24.1");
        localeNamesToOids.put("ca", "1.3.6.1.4.1.42.2.27.9.4.25.1");
        localeNamesToOids.put("cs", "1.3.6.1.4.1.42.2.27.9.4.26.1");
        localeNamesToOids.put("da", "1.3.6.1.4.1.42.2.27.9.4.27.1");
        localeNamesToOids.put("de", "1.3.6.1.4.1.42.2.27.9.4.28.1");
        localeNamesToOids.put("de-DE", "1.3.6.1.4.1.42.2.27.9.4.28.1");
        localeNamesToOids.put("de-AT", "1.3.6.1.4.1.42.2.27.9.4.29.1");
        localeNamesToOids.put("de-BE", "1.3.6.1.4.1.42.2.27.9.4.30.1");
        localeNamesToOids.put("de-CH", "1.3.6.1.4.1.42.2.27.9.4.31.1");
        localeNamesToOids.put("de-LU", "1.3.6.1.4.1.42.2.27.9.4.32.1");
        localeNamesToOids.put("el", "1.3.6.1.4.1.42.2.27.9.4.33.1");
        localeNamesToOids.put("en", "1.3.6.1.4.1.42.2.27.9.4.34.1");
        localeNamesToOids.put("en-US", "1.3.6.1.4.1.42.2.27.9.4.34.1");
        localeNamesToOids.put("en-AU", "1.3.6.1.4.1.42.2.27.9.4.35.1");
        localeNamesToOids.put("en-CA", "1.3.6.1.4.1.42.2.27.9.4.36.1");
        localeNamesToOids.put("en-GB", "1.3.6.1.4.1.42.2.27.9.4.37.1");
        localeNamesToOids.put("en-HK", "1.3.6.1.4.1.42.2.27.9.4.38.1");
        localeNamesToOids.put("en-IE", "1.3.6.1.4.1.42.2.27.9.4.39.1");
        localeNamesToOids.put("en-IN", "1.3.6.1.4.1.42.2.27.9.4.40.1");
        localeNamesToOids.put("en-MT", "1.3.6.1.4.1.42.2.27.9.4.41.1");
        localeNamesToOids.put("en-NZ", "1.3.6.1.4.1.42.2.27.9.4.42.1");
        localeNamesToOids.put("en-PH", "1.3.6.1.4.1.42.2.27.9.4.43.1");
        localeNamesToOids.put("en-SG", "1.3.6.1.4.1.42.2.27.9.4.44.1");
        localeNamesToOids.put("en-VI", "1.3.6.1.4.1.42.2.27.9.4.45.1");
        localeNamesToOids.put("en-ZA", "1.3.6.1.4.1.42.2.27.9.4.46.1");
        localeNamesToOids.put("en-ZW", "1.3.6.1.4.1.42.2.27.9.4.47.1");
        localeNamesToOids.put("eo", "1.3.6.1.4.1.42.2.27.9.4.48.1");
        localeNamesToOids.put("es", "1.3.6.1.4.1.42.2.27.9.4.49.1");
        localeNamesToOids.put("es-ES", "1.3.6.1.4.1.42.2.27.9.4.49.1");
        localeNamesToOids.put("es-AR", "1.3.6.1.4.1.42.2.27.9.4.50.1");
        localeNamesToOids.put("es-BO", "1.3.6.1.4.1.42.2.27.9.4.51.1");
        localeNamesToOids.put("es-CL", "1.3.6.1.4.1.42.2.27.9.4.52.1");
        localeNamesToOids.put("es-CO", "1.3.6.1.4.1.42.2.27.9.4.53.1");
        localeNamesToOids.put("es-CR", "1.3.6.1.4.1.42.2.27.9.4.54.1");
        localeNamesToOids.put("es-DO", "1.3.6.1.4.1.42.2.27.9.4.55.1");
        localeNamesToOids.put("es-EC", "1.3.6.1.4.1.42.2.27.9.4.56.1");
        localeNamesToOids.put("es-GT", "1.3.6.1.4.1.42.2.27.9.4.57.1");
        localeNamesToOids.put("es-HN", "1.3.6.1.4.1.42.2.27.9.4.58.1");
        localeNamesToOids.put("es-MX", "1.3.6.1.4.1.42.2.27.9.4.59.1");
        localeNamesToOids.put("es-NI", "1.3.6.1.4.1.42.2.27.9.4.60.1");
        localeNamesToOids.put("es-PA", "1.3.6.1.4.1.42.2.27.9.4.61.1");
        localeNamesToOids.put("es-PE", "1.3.6.1.4.1.42.2.27.9.4.62.1");
        localeNamesToOids.put("es-PR", "1.3.6.1.4.1.42.2.27.9.4.63.1");
        localeNamesToOids.put("es-PY", "1.3.6.1.4.1.42.2.27.9.4.64.1");
        localeNamesToOids.put("es-SV", "1.3.6.1.4.1.42.2.27.9.4.65.1");
        localeNamesToOids.put("es-US", "1.3.6.1.4.1.42.2.27.9.4.66.1");
        localeNamesToOids.put("es-UY", "1.3.6.1.4.1.42.2.27.9.4.67.1");
        localeNamesToOids.put("es-VE", "1.3.6.1.4.1.42.2.27.9.4.68.1");
        localeNamesToOids.put("et", "1.3.6.1.4.1.42.2.27.9.4.69.1");
        localeNamesToOids.put("eu", "1.3.6.1.4.1.42.2.27.9.4.70.1");
        localeNamesToOids.put("fa", "1.3.6.1.4.1.42.2.27.9.4.71.1");
        localeNamesToOids.put("fa-IN", "1.3.6.1.4.1.42.2.27.9.4.72.1");
        localeNamesToOids.put("fa-IR", "1.3.6.1.4.1.42.2.27.9.4.73.1");
        localeNamesToOids.put("fi", "1.3.6.1.4.1.42.2.27.9.4.74.1");
        localeNamesToOids.put("fo", "1.3.6.1.4.1.42.2.27.9.4.75.1");
        localeNamesToOids.put("fr", "1.3.6.1.4.1.42.2.27.9.4.76.1");
        localeNamesToOids.put("fr-FR", "1.3.6.1.4.1.42.2.27.9.4.76.1");
        localeNamesToOids.put("fr-BE", "1.3.6.1.4.1.42.2.27.9.4.77.1");
        localeNamesToOids.put("fr-CA", "1.3.6.1.4.1.42.2.27.9.4.78.1");
        localeNamesToOids.put("fr-CH", "1.3.6.1.4.1.42.2.27.9.4.79.1");
        localeNamesToOids.put("fr-LU", "1.3.6.1.4.1.42.2.27.9.4.80.1");
        localeNamesToOids.put("ga", "1.3.6.1.4.1.42.2.27.9.4.81.1");
        localeNamesToOids.put("gl", "1.3.6.1.4.1.42.2.27.9.4.82.1");
        localeNamesToOids.put("gu", "1.3.6.1.4.1.42.2.27.9.4.83.1");
        localeNamesToOids.put("gv", "1.3.6.1.4.1.42.2.27.9.4.84.1");
        localeNamesToOids.put("he", "1.3.6.1.4.1.42.2.27.9.4.85.1");
        localeNamesToOids.put("hi", "1.3.6.1.4.1.42.2.27.9.4.86.1");
        localeNamesToOids.put("hr", "1.3.6.1.4.1.42.2.27.9.4.87.1");
        localeNamesToOids.put("hu", "1.3.6.1.4.1.42.2.27.9.4.88.1");
        localeNamesToOids.put("hy", "1.3.6.1.4.1.42.2.27.9.4.89.1");
        localeNamesToOids.put("id", "1.3.6.1.4.1.42.2.27.9.4.90.1");
        localeNamesToOids.put("is", "1.3.6.1.4.1.42.2.27.9.4.91.1");
        localeNamesToOids.put("it", "1.3.6.1.4.1.42.2.27.9.4.92.1");
        localeNamesToOids.put("it-CH", "1.3.6.1.4.1.42.2.27.9.4.93.1");
        localeNamesToOids.put("ja", "1.3.6.1.4.1.42.2.27.9.4.94.1");
        localeNamesToOids.put("kl", "1.3.6.1.4.1.42.2.27.9.4.95.1");
        localeNamesToOids.put("kn", "1.3.6.1.4.1.42.2.27.9.4.96.1");
        localeNamesToOids.put("ko", "1.3.6.1.4.1.42.2.27.9.4.97.1");
        localeNamesToOids.put("kok", "1.3.6.1.4.1.42.2.27.9.4.98.1");
        localeNamesToOids.put("kw", "1.3.6.1.4.1.42.2.27.9.4.99.1");
        localeNamesToOids.put("lt", "1.3.6.1.4.1.42.2.27.9.4.100.1");
        localeNamesToOids.put("lv", "1.3.6.1.4.1.42.2.27.9.4.101.1");
        localeNamesToOids.put("mk", "1.3.6.1.4.1.42.2.27.9.4.102.1");
        localeNamesToOids.put("mr", "1.3.6.1.4.1.42.2.27.9.4.103.1");
        localeNamesToOids.put("mt", "1.3.6.1.4.1.42.2.27.9.4.104.1");
        localeNamesToOids.put("nl", "1.3.6.1.4.1.42.2.27.9.4.105.1");
        localeNamesToOids.put("nl-NL", "1.3.6.1.4.1.42.2.27.9.4.105.1");
        localeNamesToOids.put("nl-BE", "1.3.6.1.4.1.42.2.27.9.4.106.1");
        localeNamesToOids.put("no", "1.3.6.1.4.1.42.2.27.9.4.107.1");
        localeNamesToOids.put("no-NO", "1.3.6.1.4.1.42.2.27.9.4.107.1");
        localeNamesToOids.put("no-NO-NY", "1.3.6.1.4.1.42.2.27.9.4.108.1");
        localeNamesToOids.put("nn", "1.3.6.1.4.1.42.2.27.9.4.109.1");
        localeNamesToOids.put("nb", "1.3.6.1.4.1.42.2.27.9.4.110.1");
        localeNamesToOids.put("no-NO-B", "1.3.6.1.4.1.42.2.27.9.4.110.1");
        localeNamesToOids.put("om", "1.3.6.1.4.1.42.2.27.9.4.111.1");
        localeNamesToOids.put("om-ET", "1.3.6.1.4.1.42.2.27.9.4.112.1");
        localeNamesToOids.put("om-KE", "1.3.6.1.4.1.42.2.27.9.4.113.1");
        localeNamesToOids.put("pl", "1.3.6.1.4.1.42.2.27.9.4.114.1");
        localeNamesToOids.put("pt", "1.3.6.1.4.1.42.2.27.9.4.115.1");
        localeNamesToOids.put("pt-PT", "1.3.6.1.4.1.42.2.27.9.4.115.1");
        localeNamesToOids.put("pt-BR", "1.3.6.1.4.1.42.2.27.9.4.116.1");
        localeNamesToOids.put("ro", "1.3.6.1.4.1.42.2.27.9.4.117.1");
        localeNamesToOids.put("ru", "1.3.6.1.4.1.42.2.27.9.4.118.1");
        localeNamesToOids.put("ru-RU", "1.3.6.1.4.1.42.2.27.9.4.118.1");
        localeNamesToOids.put("ru-UA", "1.3.6.1.4.1.42.2.27.9.4.119.1");
        localeNamesToOids.put("sh", "1.3.6.1.4.1.42.2.27.9.4.120.1");
        localeNamesToOids.put("sk", "1.3.6.1.4.1.42.2.27.9.4.121.1");
        localeNamesToOids.put("sl", "1.3.6.1.4.1.42.2.27.9.4.122.1");
        localeNamesToOids.put("so", "1.3.6.1.4.1.42.2.27.9.4.123.1");
        localeNamesToOids.put("so-SO", "1.3.6.1.4.1.42.2.27.9.4.123.1");
        localeNamesToOids.put("so-DJ", "1.3.6.1.4.1.42.2.27.9.4.124.1");
        localeNamesToOids.put("so-ET", "1.3.6.1.4.1.42.2.27.9.4.125.1");
        localeNamesToOids.put("so-KE", "1.3.6.1.4.1.42.2.27.9.4.126.1");
        localeNamesToOids.put("sq", "1.3.6.1.4.1.42.2.27.9.4.127.1");
        localeNamesToOids.put("sr", "1.3.6.1.4.1.42.2.27.9.4.128.1");
        localeNamesToOids.put("sv", "1.3.6.1.4.1.42.2.27.9.4.129.1");
        localeNamesToOids.put("sv-SE", "1.3.6.1.4.1.42.2.27.9.4.129.1");
        localeNamesToOids.put("sv-FI", "1.3.6.1.4.1.42.2.27.9.4.130.1");
        localeNamesToOids.put("sw", "1.3.6.1.4.1.42.2.27.9.4.131.1");
        localeNamesToOids.put("sw-KE", "1.3.6.1.4.1.42.2.27.9.4.132.1");
        localeNamesToOids.put("sw-TZ", "1.3.6.1.4.1.42.2.27.9.4.133.1");
        localeNamesToOids.put("ta", "1 3  1.3.6.1.4.1.42.2.27.9.4.134.1");
        localeNamesToOids.put("te", "1.3.6.1.4.1.42.2.27.9.4.135.1");
        localeNamesToOids.put("th", "1.3.6.1.4.1.42.2.27.9.4.136.1");
        localeNamesToOids.put("ti", "1.3.6.1.4.1.42.2.27.9.4.137.1");
        localeNamesToOids.put("ti-ER", "1.3.6.1.4.1.42.2.27.9.4.138.1");
        localeNamesToOids.put("ti-ET", "1.3.6.1.4.1.42.2.27.9.4.139.1");
        localeNamesToOids.put("tr", "1.3.6.1.4.1.42.2.27.9.4.140.1");
        localeNamesToOids.put("uk", "1.3.6.1.4.1.42.2.27.9.4.141.1");
        localeNamesToOids.put("vi", "1.3.6.1.4.1.42.2.27.9.4.142.1");
        localeNamesToOids.put("zh", "1.3.6.1.4.1.42.2.27.9.4.143.1");
        localeNamesToOids.put("zh-CN", "1.3.6.1.4.1.42.2.27.9.4.144.1");
        localeNamesToOids.put("zh-HK", "1.3.6.1.4.1.42.2.27.9.4.145.1");
        localeNamesToOids.put("zh-MO", "1.3.6.1.4.1.42.2.27.9.4.146.1");
        localeNamesToOids.put("zh-SG", "1.3.6.1.4.1.42.2.27.9.4.147.1");
        localeNamesToOids.put("zh-TW", "1.3.6.1.4.1.42.2.27.9.4.148.1");
        HashMap<String, String> jvmSupportedLocaleNamesToOids = new HashMap<String, String>();
        for (Map.Entry entry : localeNamesToOids.entrySet()) {
            String localeName = (String)entry.getKey();
            String oid = (String)entry.getValue();
            String oldLocaleName = new Locale(localeName).toString();
            int idx = oldLocaleName.indexOf(45);
            if (idx == -1) {
                jvmSupportedLocaleNamesToOids.put(oldLocaleName, oid);
                continue;
            }
            if (oldLocaleName.equalsIgnoreCase(localeName)) {
                jvmSupportedLocaleNamesToOids.put(localeName, oid);
                continue;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(oldLocaleName, 0, idx + 1).append(oldLocaleName.substring(idx + 1, oldLocaleName.length()).toUpperCase(Locale.ENGLISH));
            jvmSupportedLocaleNamesToOids.put(sb.toString(), oid);
        }
        JVM_SUPPORTED_LOCALE_NAMES_TO_OIDS = Collections.unmodifiableMap(jvmSupportedLocaleNamesToOids);
    }
}

