/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractEqualityMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class BitStringEqualityMatchingRuleImpl
extends AbstractEqualityMatchingRuleImpl {
    BitStringEqualityMatchingRuleImpl() {
        super("bitStringMatch");
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        String valueString = value.toString().toUpperCase();
        int length = valueString.length();
        if (length < 3) {
            throw DecodeException.error(CoreMessages.WARN_ATTR_SYNTAX_BIT_STRING_TOO_SHORT.get(value));
        }
        if (valueString.charAt(0) != '\'' || valueString.charAt(length - 1) != 'B' || valueString.charAt(length - 2) != '\'') {
            throw DecodeException.error(CoreMessages.WARN_ATTR_SYNTAX_BIT_STRING_NOT_QUOTED.get(value));
        }
        block3: for (int i = 1; i < length - 2; ++i) {
            switch (valueString.charAt(i)) {
                case '0': 
                case '1': {
                    continue block3;
                }
                default: {
                    throw DecodeException.error(CoreMessages.WARN_ATTR_SYNTAX_BIT_STRING_INVALID_BIT.get(value, Character.valueOf(valueString.charAt(i))));
                }
            }
        }
        return ByteString.valueOfUtf8(valueString);
    }
}

