/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.messages.AbstractResultImpl;
import org.forgerock.opendj.ldap.messages.BindResult;

final class BindResultImpl
extends AbstractResultImpl<BindResult>
implements BindResult {
    private ByteString credentials;

    BindResultImpl(BindResult bindResult) {
        super(bindResult);
        this.credentials = bindResult.getServerSaslCredentials();
    }

    BindResultImpl(ResultCode resultCode) {
        super(resultCode);
    }

    @Override
    public ByteString getServerSaslCredentials() {
        return this.credentials;
    }

    @Override
    public boolean isSaslBindInProgress() {
        ResultCode code = this.getResultCode();
        return code.equals(ResultCode.SASL_BIND_IN_PROGRESS);
    }

    @Override
    public BindResult setServerSaslCredentials(ByteString credentials) {
        this.credentials = credentials;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BindResult(resultCode=");
        builder.append(this.getResultCode());
        builder.append(", matchedDn=");
        builder.append(this.getMatchedDn());
        builder.append(", diagnosticMessage=");
        builder.append(this.getDiagnosticMessage());
        builder.append(", referrals=");
        builder.append(this.getReferralUris());
        builder.append(", serverSaslCredentials=");
        builder.append(this.getServerSaslCredentials() == null ? ByteString.empty() : "******");
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    @Override
    BindResult getThis() {
        return this;
    }
}

