/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.messages;

import java.util.LinkedList;
import java.util.List;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.messages.AbstractProtocolOpImpl;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.util.Reject;

abstract class AbstractResultImpl<S extends Result>
extends AbstractProtocolOpImpl<S>
implements Result {
    private Throwable cause;
    private String diagnosticMessage = "";
    private String matchedDn = "";
    private final List<String> referralUris = new LinkedList<String>();
    private ResultCode resultCode;

    AbstractResultImpl(Result result) {
        super(result);
        this.cause = result.getCause();
        this.diagnosticMessage = result.getDiagnosticMessage();
        this.matchedDn = result.getMatchedDn();
        this.referralUris.addAll(result.getReferralUris());
        this.resultCode = result.getResultCode();
    }

    AbstractResultImpl(ResultCode resultCode) {
        this.resultCode = resultCode;
    }

    public final S addReferralUri(String uri) {
        Reject.ifNull(uri);
        this.referralUris.add(uri);
        return (S)((Result)this.getThis());
    }

    @Override
    public final Throwable getCause() {
        return this.cause;
    }

    @Override
    public final String getDiagnosticMessage() {
        return this.diagnosticMessage;
    }

    @Override
    public final String getMatchedDn() {
        return this.matchedDn;
    }

    @Override
    public final List<String> getReferralUris() {
        return this.referralUris;
    }

    @Override
    public final ResultCode getResultCode() {
        return this.resultCode;
    }

    @Override
    public final boolean isReferral() {
        ResultCode code = this.getResultCode();
        return code.equals(ResultCode.REFERRAL);
    }

    @Override
    public final boolean isSuccess() {
        ResultCode code = this.getResultCode();
        return !code.isExceptional();
    }

    public final S setCause(Throwable cause) {
        this.cause = cause;
        return (S)((Result)this.getThis());
    }

    public final S setDiagnosticMessage(CharSequence message) {
        this.diagnosticMessage = message != null ? message.toString() : "";
        return (S)((Result)this.getThis());
    }

    public final S setMatchedDn(String dn) {
        this.matchedDn = dn != null ? dn : "";
        return (S)((Result)this.getThis());
    }

    public final S setResultCode(ResultCode resultCode) {
        Reject.ifNull(resultCode);
        this.resultCode = resultCode;
        return (S)((Result)this.getThis());
    }
}

