/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.controls.AccountUsabilityRequestControl;
import com.forgerock.opendj.ldap.controls.RealAttributesOnlyRequestControl;
import com.forgerock.opendj.ldap.controls.TransactionIdControl;
import com.forgerock.opendj.ldap.controls.VirtualAttributesOnlyRequestControl;
import java.util.Map;
import java.util.TreeMap;
import org.forgerock.opendj.ldap.controls.AssertionRequestControl;
import org.forgerock.opendj.ldap.controls.AuthorizationIdentityRequestControl;
import org.forgerock.opendj.ldap.controls.GetEffectiveRightsRequestControl;
import org.forgerock.opendj.ldap.controls.ManageDsaItRequestControl;
import org.forgerock.opendj.ldap.controls.MatchedValuesRequestControl;
import org.forgerock.opendj.ldap.controls.PasswordPolicyRequestControl;
import org.forgerock.opendj.ldap.controls.PermissiveModifyRequestControl;
import org.forgerock.opendj.ldap.controls.PersistentSearchRequestControl;
import org.forgerock.opendj.ldap.controls.PostReadRequestControl;
import org.forgerock.opendj.ldap.controls.PreReadRequestControl;
import org.forgerock.opendj.ldap.controls.ProxiedAuthV1RequestControl;
import org.forgerock.opendj.ldap.controls.ProxiedAuthV2RequestControl;
import org.forgerock.opendj.ldap.controls.ServerSideSortRequestControl;
import org.forgerock.opendj.ldap.controls.SimplePagedResultsControl;
import org.forgerock.opendj.ldap.controls.SubentriesRequestControl;
import org.forgerock.opendj.ldap.controls.SubtreeDeleteRequestControl;
import org.forgerock.opendj.ldap.controls.VirtualListViewRequestControl;

public final class Controls {
    private static final Map<String, String> CONTROL_ALIASES;

    public static String getControlOidForAlias(String controlAlias) {
        return Controls.isControlAlias(controlAlias) ? CONTROL_ALIASES.get(controlAlias) : controlAlias;
    }

    public static boolean isControlAlias(String controlAlias) {
        return CONTROL_ALIASES.containsKey(controlAlias);
    }

    private Controls() {
    }

    static {
        String[][] aliases;
        CONTROL_ALIASES = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String[] alias : aliases = new String[][]{{AssertionRequestControl.DECODER.getOid(), "Assertion", "LdapAssertion"}, {AccountUsabilityRequestControl.DECODER.getOid(), "AccountUsable", "AccountUsability"}, {AuthorizationIdentityRequestControl.DECODER.getOid(), "AuthorizationIdentity", "AuthzId"}, {"1.3.6.1.4.1.42.2.27.9.5.9", "Csn", "ChangeNumber", "ChangeSequenceNumber"}, {GetEffectiveRightsRequestControl.DECODER.getOid(), "EffectiveRights", "GetEffectiveRights"}, {ManageDsaItRequestControl.DECODER.getOid(), "ManageDsaIt"}, {MatchedValuesRequestControl.DECODER.getOid(), "MatchedValues"}, {"1.3.6.1.4.1.4203.1.10.2", "Noop", "No-Op"}, {PasswordPolicyRequestControl.DECODER.getOid(), "PasswordPolicy", "PwpPolicy"}, {PermissiveModifyRequestControl.DECODER.getOid(), "PermissiveModify"}, {PersistentSearchRequestControl.DECODER.getOid(), "PersistentSearch", "PSearch"}, {PostReadRequestControl.DECODER.getOid(), "PostRead"}, {PreReadRequestControl.DECODER.getOid(), "PreRead"}, {ProxiedAuthV1RequestControl.DECODER.getOid(), "ProxiedAuthV1"}, {ProxiedAuthV2RequestControl.DECODER.getOid(), "ProxiedAuthV2", "ProxiedAuth"}, {RealAttributesOnlyRequestControl.DECODER.getOid(), "RealAttrsOnly", "RealAttributesOnly"}, {SubtreeDeleteRequestControl.DECODER.getOid(), "SubtreeDelete", "TreeDelete"}, {ServerSideSortRequestControl.DECODER.getOid(), "ServerSideSort", "Sort"}, {SimplePagedResultsControl.DECODER.getOid(), "SimplePagedResults", "PagedResults"}, {SubentriesRequestControl.DECODER.getOid(), "SubEntries"}, {TransactionIdControl.DECODER.getOid(), "TransactionId", "TxnId"}, {VirtualAttributesOnlyRequestControl.DECODER.getOid(), "VirtualAttrsOnly", "VirtualAttributesOnly"}, {VirtualListViewRequestControl.DECODER.getOid(), "Vlv", "VirtualListView"}}) {
            for (int i = 1; i < alias.length; ++i) {
                CONTROL_ALIASES.put(alias[i], alias[0]);
            }
        }
    }
}

