/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;

public final class Modification {
    private final ModificationType modificationType;
    private final Attribute attribute;

    public Modification(ModificationType modificationType, Attribute attribute) {
        this.modificationType = Reject.checkNotNull(modificationType);
        this.attribute = Reject.checkNotNull(attribute);
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public ModificationType getModificationType() {
        return this.modificationType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Modification(modificationType=");
        builder.append(this.modificationType);
        builder.append(", attributeDescription=");
        builder.append(this.attribute.getAttributeDescriptionAsString());
        builder.append(", attributeValues={");
        Utils.joinAsString(builder, ", ", this.attribute);
        builder.append("})");
        return builder.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Modification)) {
            return false;
        }
        Modification other = (Modification)obj;
        return this.attribute.equals(other.attribute) && this.modificationType.equals(other.modificationType);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.attribute.hashCode();
        result = 31 * result + this.modificationType.hashCode();
        return result;
    }
}

