/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import io.reactivex.Flowable;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Function;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Set;
import org.forgerock.opendj.ldap.CommonLdapOptions;
import org.forgerock.opendj.ldap.LdapClientContext;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.Response;
import org.forgerock.opendj.ldap.spi.LdapListenerImpl;
import org.forgerock.opendj.ldap.spi.TransportProvider;
import org.forgerock.util.Option;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;

public final class LdapListener
extends CommonLdapOptions
implements Closeable {
    public static final Option<Integer> CONNECT_MAX_BACKLOG = Option.withDefault(50);
    public static final Option<Boolean> BLOCKING_WRITE = Option.withDefault(false);
    public static final Option<Integer> BUFFER_SIZE = Option.withDefault(4096);
    public static final Option<Long> WRITE_TIMEOUT_MS = Option.withDefault(30000L);
    public static final Option<Integer> SELECTOR_THREAD_COUNT = Option.withDefault(Math.max(2, Runtime.getRuntime().availableProcessors() / 2));
    public static final Option<String> SELECTOR_THREAD_NAME = Option.withDefault("OpenDJ LDAP SDK selector thread");
    public static final Option<Integer> REQUEST_MAX_SIZE_IN_BYTES = Option.withDefault(0x500000);
    public static final Option<Integer> MAX_CONCURRENT_REQUESTS = Option.withDefault(64);
    private final LdapListenerImpl impl;
    private TransportProvider provider;

    public LdapListener(int port, Function<LdapClientContext, BiFunction<Integer, Request, Flowable<Response>>> factory) throws IOException {
        this(port, factory, Options.defaultOptions());
    }

    public LdapListener(int port, Function<LdapClientContext, BiFunction<Integer, Request, Flowable<Response>>> factory, Options options) throws IOException {
        this(Collections.singleton(new InetSocketAddress(port)), factory, options);
    }

    public LdapListener(Set<InetSocketAddress> addresses, Function<LdapClientContext, BiFunction<Integer, Request, Flowable<Response>>> factory) throws IOException {
        this(addresses, factory, Options.defaultOptions());
    }

    public LdapListener(Set<InetSocketAddress> addresses, Function<LdapClientContext, BiFunction<Integer, Request, Flowable<Response>>> factory, Options options) throws IOException {
        Reject.ifNull(addresses, factory, options);
        this.provider = LdapListener.getTransportProvider(options);
        this.impl = this.provider.getLdapListener(addresses, factory, options);
    }

    public LdapListener(String host, int port, Function<LdapClientContext, BiFunction<Integer, Request, Flowable<Response>>> factory) throws IOException {
        this(host, port, factory, Options.defaultOptions());
    }

    public LdapListener(String host, int port, Function<LdapClientContext, BiFunction<Integer, Request, Flowable<Response>>> factory, Options options) throws IOException {
        this(Collections.singleton(new InetSocketAddress(host, port)), factory, options);
    }

    public boolean setOptions(Options options) {
        return this.impl.setOptions(options);
    }

    public Options getOptions() {
        return Options.copyOf(this.impl.getOptions());
    }

    @Override
    public void close() {
        this.impl.close();
    }

    public Set<InetSocketAddress> getSocketAddresses() {
        return this.impl.getSocketAddresses();
    }

    public InetSocketAddress firstSocketAddress() {
        return this.impl.getSocketAddresses().iterator().next();
    }

    public String getProviderName() {
        return this.provider.getName();
    }

    public String toString() {
        return this.impl.toString();
    }
}

