/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.io;

import com.forgerock.opendj.ldap.CoreMessages;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.io.Asn1Reader;
import org.forgerock.opendj.io.Ldap;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.DereferenceAliasesPolicy;
import org.forgerock.opendj.ldap.Dn;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.Rdn;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.GenericControl;
import org.forgerock.opendj.ldap.messages.AbandonRequest;
import org.forgerock.opendj.ldap.messages.AddRequest;
import org.forgerock.opendj.ldap.messages.BindRequest;
import org.forgerock.opendj.ldap.messages.BindResult;
import org.forgerock.opendj.ldap.messages.CompareRequest;
import org.forgerock.opendj.ldap.messages.CompareResult;
import org.forgerock.opendj.ldap.messages.DeleteRequest;
import org.forgerock.opendj.ldap.messages.GenericExtendedRequest;
import org.forgerock.opendj.ldap.messages.GenericExtendedResult;
import org.forgerock.opendj.ldap.messages.GenericIntermediateResponse;
import org.forgerock.opendj.ldap.messages.InvalidRequest;
import org.forgerock.opendj.ldap.messages.LdapMessage;
import org.forgerock.opendj.ldap.messages.ModifyDnRequest;
import org.forgerock.opendj.ldap.messages.ModifyRequest;
import org.forgerock.opendj.ldap.messages.ProtocolOp;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.Requests;
import org.forgerock.opendj.ldap.messages.Responses;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.SearchRequest;
import org.forgerock.opendj.ldap.messages.SearchResultEntry;
import org.forgerock.opendj.ldap.messages.SearchResultReference;
import org.forgerock.opendj.ldap.messages.UnbindRequest;
import org.forgerock.opendj.ldap.messages.UnknownRequest;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.util.annotations.VisibleForTesting;

public final class LdapReader<R extends Asn1Reader> {
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private final DecodeOptions options;
    private final R reader;

    LdapReader(R asn1Reader, DecodeOptions options) {
        this.reader = asn1Reader;
        this.options = options;
    }

    public R getAsn1Reader() {
        return this.reader;
    }

    public boolean hasMessageAvailable() throws IOException {
        return this.reader.elementAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    LdapMessage readLdapMessage() throws IOException {
        this.reader.readStartSequence();
        try {
            int messageId = (int)this.reader.readInteger();
            byte type = this.reader.peekType();
            LdapMessage ldapMessage = this.readProtocolOp(type, messageId);
            return ldapMessage;
        }
        finally {
            this.reader.readEndSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapMessage readLdapRequestMessage() throws IOException {
        this.reader.readStartSequence();
        try {
            int messageId = (int)this.reader.readInteger();
            byte type = this.reader.peekType();
            LdapMessage ldapMessage = this.readRequestProtocolOp(type, messageId);
            return ldapMessage;
        }
        finally {
            this.reader.readEndSequence();
        }
    }

    private LdapMessage readRequestProtocolOp(byte type, int messageID) throws IOException {
        switch (type) {
            case 66: {
                return this.readUnbindRequest(messageID);
            }
            case 74: {
                return this.readDeleteRequest(messageID);
            }
            case 80: {
                return this.readAbandonRequest(messageID);
            }
            case 96: {
                return this.readBindRequest(messageID);
            }
            case 99: {
                return this.readSearchRequest(messageID);
            }
            case 102: {
                return this.readModifyRequest(messageID);
            }
            case 104: {
                return this.readAddRequest(messageID);
            }
            case 108: {
                return this.readModifyDnRequest(messageID);
            }
            case 110: {
                return this.readCompareRequest(messageID);
            }
            case 119: {
                return this.readExtendedRequest(messageID);
            }
        }
        ByteString content = this.reader.readOctetString(type);
        UnknownRequest unknownRequest = Requests.newUnknownRequest(type, content);
        this.readControls(unknownRequest);
        return LdapMessage.newLdapMessage(messageID, type, unknownRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LdapMessage readLdapResponseMessage() throws IOException {
        this.reader.readStartSequence();
        try {
            int messageId = (int)this.reader.readInteger();
            byte type = this.reader.peekType();
            LdapMessage ldapMessage = this.readResponseProtocolOp(type, messageId);
            return ldapMessage;
        }
        finally {
            this.reader.readEndSequence();
        }
    }

    private LdapMessage readResponseProtocolOp(byte type, int messageID) throws IOException {
        switch (type) {
            case 97: {
                return this.readBindResult(messageID);
            }
            case 100: {
                return this.readSearchResultEntry(messageID);
            }
            case 101: {
                return this.readSearchResult(messageID);
            }
            case 103: {
                return this.readModifyResult(messageID);
            }
            case 105: {
                return this.readAddResult(messageID);
            }
            case 107: {
                return this.readDeleteResult(messageID);
            }
            case 109: {
                return this.readModifyDnResult(messageID);
            }
            case 111: {
                return this.readCompareResult(messageID);
            }
            case 115: {
                return this.readSearchResultReference(messageID);
            }
            case 120: {
                return this.readExtendedResult(messageID);
            }
            case 121: {
                return this.readIntermediateResponse(messageID);
            }
        }
        throw DecodeException.error(LocalizableMessage.raw("Unknown response-type %d", type));
    }

    private LdapMessage readAbandonRequest(int messageID) throws IOException {
        int msgToAbandon = (int)this.reader.readInteger((byte)80);
        AbandonRequest message = Requests.newAbandonRequest(msgToAbandon);
        this.readControls(message);
        logger.trace("DECODE LDAP ABANDON REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)message);
        return LdapMessage.newLdapMessage(messageID, (byte)80, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readAddRequest(int messageID) throws IOException {
        Entry entry;
        this.reader.readStartSequence((byte)104);
        String dnString = null;
        try {
            dnString = this.reader.readOctetStringAsString();
            entry = this.readEntry(dnString);
        }
        catch (LdapException e) {
            LdapMessage ldapMessage = this.readInvalidRequest(Request.RequestType.ADD, messageID, dnString, e);
            return ldapMessage;
        }
        finally {
            this.reader.readEndSequence();
        }
        AddRequest message = Requests.newAddRequest(entry);
        this.readControls(message);
        logger.trace("DECODE LDAP ADD REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)message);
        return LdapMessage.newLdapMessage(messageID, (byte)104, message);
    }

    private Entry readEntry(String dnString) throws IOException {
        Schema schema = this.options.getSchemaResolver().resolveSchema(dnString);
        Dn dn = Ldap.readDn(dnString, schema);
        Entry entry = this.options.getEntryFactory().newEntry(dn);
        Ldap.readEntryAttributes(this.reader, this.options, entry, schema);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readAddResult(int messageID) throws IOException {
        Result result;
        this.reader.readStartSequence((byte)105);
        try {
            ResultCode resultCode = ResultCode.valueOf(this.reader.readEnumerated());
            String matchedDN = this.reader.readOctetStringAsString();
            String diagnosticMessage = this.reader.readOctetStringAsString();
            result = Responses.newResult(resultCode).setMatchedDn(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.readResponseReferrals(result);
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(result);
        logger.trace("DECODE LDAP ADD RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        return LdapMessage.newLdapMessage(messageID, (byte)105, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readBindRequest(int messageID) throws IOException {
        BindRequest request;
        this.reader.readStartSequence((byte)96);
        try {
            int protocolVersion = (int)this.reader.readInteger();
            String authName = this.reader.readOctetStringAsString();
            byte authType = this.reader.peekType();
            byte[] authBytes = this.reader.readOctetString(authType).toByteArray();
            request = Requests.newBindRequest().setVersion(protocolVersion).setName(authName).setAuthenticationTypeAndValue(authType, authBytes);
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(request);
        logger.trace("DECODE LDAP BIND REQUEST(messageID=%d, auth=0x%x, request=%s)", (Object)messageID, (Object)request.getAuthenticationType(), (Object)request);
        return LdapMessage.newLdapMessage(messageID, (byte)96, request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readBindResult(int messageID) throws IOException {
        BindResult bindResult;
        this.reader.readStartSequence((byte)97);
        try {
            ResultCode resultCode = ResultCode.valueOf(this.reader.readEnumerated());
            String matchedDN = this.reader.readOctetStringAsString();
            String diagnosticMessage = this.reader.readOctetStringAsString();
            bindResult = Responses.newBindResult(resultCode).setMatchedDn(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.readResponseReferrals(bindResult);
            if (this.reader.hasNextElement() && this.reader.peekType() == -121) {
                bindResult.setServerSaslCredentials(this.reader.readOctetString((byte)-121));
            }
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(bindResult);
        logger.trace("DECODE LDAP BIND RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)bindResult);
        return LdapMessage.newLdapMessage(messageID, (byte)97, bindResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readCompareRequest(int messageID) throws IOException {
        CompareRequest compareRequest;
        this.reader.readStartSequence((byte)110);
        String dnString = null;
        try {
            dnString = this.reader.readOctetStringAsString();
            Schema schema = this.options.getSchemaResolver().resolveSchema(dnString);
            Dn dn = Ldap.readDn(dnString, schema);
            this.reader.readStartSequence();
            try {
                String ads = this.reader.readOctetStringAsString();
                AttributeDescription ad = Ldap.readAttributeDescription(ads, schema);
                ByteString assertionValue = this.reader.readOctetString();
                compareRequest = Requests.newCompareRequest(dn, ad, (Object)assertionValue);
            }
            finally {
                this.reader.readEndSequence();
            }
        }
        catch (LdapException e) {
            LdapMessage ldapMessage = this.readInvalidRequest(Request.RequestType.COMPARE, messageID, dnString, e);
            return ldapMessage;
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(compareRequest);
        logger.trace("DECODE LDAP COMPARE REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)compareRequest);
        return LdapMessage.newLdapMessage(messageID, (byte)110, compareRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readCompareResult(int messageID) throws IOException {
        CompareResult compareResult;
        this.reader.readStartSequence((byte)111);
        try {
            ResultCode resultCode = ResultCode.valueOf(this.reader.readEnumerated());
            String matchedDN = this.reader.readOctetStringAsString();
            String diagnosticMessage = this.reader.readOctetStringAsString();
            compareResult = Responses.newCompareResult(resultCode).setMatchedDn(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.readResponseReferrals(compareResult);
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(compareResult);
        logger.trace("DECODE LDAP COMPARE RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)compareResult);
        return LdapMessage.newLdapMessage(messageID, (byte)111, compareResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Control readControl() throws IOException {
        this.reader.readStartSequence();
        try {
            String oid = this.reader.readOctetStringAsString();
            boolean isCritical = this.reader.hasNextElement() && this.reader.peekType() == 1 ? this.reader.readBoolean() : false;
            ByteString value = this.reader.hasNextElement() && this.reader.peekType() == 4 ? this.reader.readOctetString() : null;
            GenericControl genericControl = GenericControl.newControl(oid, isCritical, value);
            return genericControl;
        }
        finally {
            this.reader.readEndSequence();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readControls(ProtocolOp protocolOp) throws IOException {
        if (this.reader.hasNextElement() && this.reader.peekType() == -96) {
            this.reader.readStartSequence((byte)-96);
            try {
                while (this.reader.hasNextElement()) {
                    protocolOp.addControl(this.readControl());
                }
            }
            finally {
                this.reader.readEndSequence();
            }
        }
    }

    private LdapMessage readDeleteRequest(int messageID) throws IOException {
        Dn dn;
        String dnString = this.reader.readOctetStringAsString((byte)74);
        Schema schema = this.options.getSchemaResolver().resolveSchema(dnString);
        try {
            dn = Ldap.readDn(dnString, schema);
        }
        catch (LdapException e) {
            return this.readInvalidRequest(Request.RequestType.DELETE, messageID, dnString, e);
        }
        DeleteRequest deleteRequest = Requests.newDeleteRequest(dn);
        this.readControls(deleteRequest);
        logger.trace("DECODE LDAP DELETE REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)deleteRequest);
        return LdapMessage.newLdapMessage(messageID, (byte)74, deleteRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readDeleteResult(int messageID) throws IOException {
        Result result;
        this.reader.readStartSequence((byte)107);
        try {
            ResultCode resultCode = ResultCode.valueOf(this.reader.readEnumerated());
            String matchedDN = this.reader.readOctetStringAsString();
            String diagnosticMessage = this.reader.readOctetStringAsString();
            result = Responses.newResult(resultCode).setMatchedDn(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.readResponseReferrals(result);
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(result);
        logger.trace("DECODE LDAP DELETE RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        return LdapMessage.newLdapMessage(messageID, (byte)107, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readExtendedRequest(int messageID) throws IOException {
        GenericExtendedRequest extendedRequest;
        this.reader.readStartSequence((byte)119);
        try {
            String oid = this.reader.readOctetStringAsString((byte)-128);
            if (this.reader.hasNextElement() && this.reader.peekType() == -127) {
                ByteString value = this.reader.readOctetString((byte)-127);
                extendedRequest = Requests.newGenericExtendedRequest(oid, value);
            } else {
                extendedRequest = Requests.newGenericExtendedRequest(oid, null);
            }
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(extendedRequest);
        logger.trace("DECODE LDAP EXTENDED REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)extendedRequest);
        return LdapMessage.newLdapMessage(messageID, (byte)119, extendedRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readExtendedResult(int messageID) throws IOException {
        GenericExtendedResult extendedResult;
        this.reader.readStartSequence((byte)120);
        try {
            ResultCode resultCode = ResultCode.valueOf(this.reader.readEnumerated());
            String matchedDN = this.reader.readOctetStringAsString();
            String diagnosticMessage = this.reader.readOctetStringAsString();
            extendedResult = Responses.newGenericExtendedResult(resultCode).setMatchedDn(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.readResponseReferrals(extendedResult);
            if (this.reader.hasNextElement() && this.reader.peekType() == -118) {
                extendedResult.setOid(this.reader.readOctetStringAsString((byte)-118));
            }
            if (this.reader.hasNextElement() && this.reader.peekType() == -117) {
                extendedResult.setValue(this.reader.readOctetString((byte)-117));
            }
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(extendedResult);
        logger.trace("DECODE LDAP EXTENDED RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)extendedResult);
        return LdapMessage.newLdapMessage(messageID, (byte)120, extendedResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readIntermediateResponse(int messageID) throws IOException {
        GenericIntermediateResponse intermediateResponse;
        this.reader.readStartSequence((byte)121);
        try {
            intermediateResponse = Responses.newGenericIntermediateResponse();
            if (this.reader.hasNextElement() && this.reader.peekType() == -128) {
                intermediateResponse.setOid(this.reader.readOctetStringAsString((byte)-128));
            }
            if (this.reader.hasNextElement() && this.reader.peekType() == -127) {
                intermediateResponse.setValue(this.reader.readOctetString((byte)-127));
            }
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(intermediateResponse);
        logger.trace("DECODE LDAP INTERMEDIATE RESPONSE(messageID=%d, response=%s)", (Object)messageID, (Object)intermediateResponse);
        return LdapMessage.newLdapMessage(messageID, (byte)121, intermediateResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readModifyDnRequest(int messageID) throws IOException {
        ModifyDnRequest modifyDnRequest;
        block12: {
            this.reader.readStartSequence((byte)108);
            try {
                Dn newSuperior;
                Rdn newRDN;
                Dn dn;
                String dnString = this.reader.readOctetStringAsString();
                Schema schema = this.options.getSchemaResolver().resolveSchema(dnString);
                try {
                    dn = Ldap.readDn(dnString, schema);
                }
                catch (LdapException e) {
                    LdapMessage ldapMessage = this.readInvalidRequest(Request.RequestType.MODIFYDN, messageID, dnString, e);
                    this.reader.readEndSequence();
                    return ldapMessage;
                }
                String newRDNString = this.reader.readOctetStringAsString();
                try {
                    newRDN = this.readRdn(newRDNString, schema);
                }
                catch (LdapException e) {
                    LdapMessage ldapMessage = this.readInvalidRequest(Request.RequestType.MODIFYDN, messageID, newRDNString, e);
                    this.reader.readEndSequence();
                    return ldapMessage;
                }
                modifyDnRequest = Requests.newModifyDnRequest(dn, newRDN);
                modifyDnRequest.setDeleteOldRdn(this.reader.readBoolean());
                if (!this.reader.hasNextElement() || this.reader.peekType() != -128) break block12;
                String newSuperiorString = this.reader.readOctetStringAsString((byte)-128);
                try {
                    newSuperior = Ldap.readDn(newSuperiorString, schema);
                }
                catch (LdapException e) {
                    LdapMessage ldapMessage = this.readInvalidRequest(Request.RequestType.MODIFYDN, messageID, newSuperiorString, e);
                    this.reader.readEndSequence();
                    return ldapMessage;
                }
                modifyDnRequest.setNewSuperior(newSuperior);
            }
            finally {
                this.reader.readEndSequence();
            }
        }
        this.readControls(modifyDnRequest);
        logger.trace("DECODE LDAP MODIFY DN REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)modifyDnRequest);
        return LdapMessage.newLdapMessage(messageID, (byte)108, modifyDnRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readModifyDnResult(int messageID) throws IOException {
        Result result;
        this.reader.readStartSequence((byte)109);
        try {
            ResultCode resultCode = ResultCode.valueOf(this.reader.readEnumerated());
            String matchedDN = this.reader.readOctetStringAsString();
            String diagnosticMessage = this.reader.readOctetStringAsString();
            result = Responses.newResult(resultCode).setMatchedDn(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.readResponseReferrals(result);
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(result);
        logger.trace("DECODE LDAP MODIFY DN RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        return LdapMessage.newLdapMessage(messageID, (byte)109, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readModifyRequest(int messageID) throws IOException {
        ModifyRequest modifyRequest;
        this.reader.readStartSequence((byte)102);
        String dnString = null;
        try {
            dnString = this.reader.readOctetStringAsString();
            Schema schema = this.options.getSchemaResolver().resolveSchema(dnString);
            Dn dn = Ldap.readDn(dnString, schema);
            modifyRequest = Requests.newModifyRequest(dn);
            this.reader.readStartSequence();
            try {
                while (this.reader.hasNextElement()) {
                    this.reader.readStartSequence();
                    try {
                        int typeIntValue = this.reader.readEnumerated();
                        ModificationType type = ModificationType.valueOf(typeIntValue);
                        if (type == null) {
                            throw LdapException.newLdapException(ResultCode.PROTOCOL_ERROR, CoreMessages.ERR_LDAP_MODIFICATION_DECODE_INVALID_MOD_TYPE.get(typeIntValue));
                        }
                        this.reader.readStartSequence();
                        try {
                            String ads = this.reader.readOctetStringAsString();
                            AttributeDescription ad = Ldap.readAttributeDescription(ads, schema);
                            Attribute attribute = this.options.getAttributeFactory().newAttribute(ad);
                            this.reader.readStartSet();
                            try {
                                while (this.reader.hasNextElement()) {
                                    attribute.add(this.reader.readOctetString());
                                }
                                modifyRequest.addModification(new Modification(type, attribute));
                            }
                            finally {
                                this.reader.readEndSet();
                            }
                        }
                        finally {
                            this.reader.readEndSequence();
                        }
                    }
                    finally {
                        this.reader.readEndSequence();
                    }
                }
            }
            finally {
                this.reader.readEndSequence();
            }
        }
        catch (LdapException e) {
            LdapMessage ldapMessage = this.readInvalidRequest(Request.RequestType.MODIFY, messageID, dnString, e);
            return ldapMessage;
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(modifyRequest);
        logger.trace("DECODE LDAP MODIFY REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)modifyRequest);
        return LdapMessage.newLdapMessage(messageID, (byte)102, modifyRequest);
    }

    private LdapMessage readInvalidRequest(Request.RequestType invalidRequestType, int messageID, String rawDnString, LdapException e) throws IOException {
        InvalidRequest invalidRequest = Requests.newInvalidRequest(invalidRequestType, rawDnString, e);
        return LdapMessage.newLdapMessage(messageID, invalidRequestType.getProtocolOperationType(), invalidRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readModifyResult(int messageID) throws IOException {
        Result result;
        this.reader.readStartSequence((byte)103);
        try {
            ResultCode resultCode = ResultCode.valueOf(this.reader.readEnumerated());
            String matchedDN = this.reader.readOctetStringAsString();
            String diagnosticMessage = this.reader.readOctetStringAsString();
            result = Responses.newResult(resultCode).setMatchedDn(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.readResponseReferrals(result);
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(result);
        logger.trace("DECODE LDAP MODIFY RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)result);
        return LdapMessage.newLdapMessage(messageID, (byte)103, result);
    }

    private LdapMessage readProtocolOp(byte type, int messageID) throws IOException {
        switch (type) {
            case 66: {
                return this.readUnbindRequest(messageID);
            }
            case 74: {
                return this.readDeleteRequest(messageID);
            }
            case 80: {
                return this.readAbandonRequest(messageID);
            }
            case 96: {
                return this.readBindRequest(messageID);
            }
            case 97: {
                return this.readBindResult(messageID);
            }
            case 99: {
                return this.readSearchRequest(messageID);
            }
            case 100: {
                return this.readSearchResultEntry(messageID);
            }
            case 101: {
                return this.readSearchResult(messageID);
            }
            case 102: {
                return this.readModifyRequest(messageID);
            }
            case 103: {
                return this.readModifyResult(messageID);
            }
            case 104: {
                return this.readAddRequest(messageID);
            }
            case 105: {
                return this.readAddResult(messageID);
            }
            case 107: {
                return this.readDeleteResult(messageID);
            }
            case 108: {
                return this.readModifyDnRequest(messageID);
            }
            case 109: {
                return this.readModifyDnResult(messageID);
            }
            case 110: {
                return this.readCompareRequest(messageID);
            }
            case 111: {
                return this.readCompareResult(messageID);
            }
            case 115: {
                return this.readSearchResultReference(messageID);
            }
            case 119: {
                return this.readExtendedRequest(messageID);
            }
            case 120: {
                return this.readExtendedResult(messageID);
            }
            case 121: {
                return this.readIntermediateResponse(messageID);
            }
        }
        ByteString content = this.reader.readOctetString(type);
        UnknownRequest unknownRequest = Requests.newUnknownRequest(type, content);
        this.readControls(unknownRequest);
        return LdapMessage.newLdapMessage(messageID, type, unknownRequest);
    }

    private Rdn readRdn(String rdn, Schema schema) throws LdapException {
        try {
            return Rdn.valueOf(rdn, schema);
        }
        catch (LocalizedIllegalArgumentException e) {
            throw LdapException.newLdapException(ResultCode.INVALID_DN_SYNTAX, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readResponseReferrals(Result message) throws IOException {
        if (this.reader.hasNextElement() && this.reader.peekType() == -93) {
            this.reader.readStartSequence((byte)-93);
            try {
                do {
                    message.addReferralUri(this.reader.readOctetStringAsString());
                } while (this.reader.hasNextElement());
            }
            finally {
                this.reader.readEndSequence();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readSearchRequest(int messageID) throws IOException {
        SearchRequest searchRequest;
        this.reader.readStartSequence((byte)99);
        String baseDNString = null;
        try {
            baseDNString = this.reader.readOctetStringAsString();
            Schema schema = this.options.getSchemaResolver().resolveSchema(baseDNString);
            Dn baseDN = Ldap.readDn(baseDNString, schema);
            int scopeIntValue = this.reader.readEnumerated();
            SearchScope scope = SearchScope.valueOf(scopeIntValue);
            if (scope == null) {
                throw LdapException.newLdapException(ResultCode.PROTOCOL_ERROR, CoreMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_INVALID_SCOPE.get(scopeIntValue));
            }
            int dereferencePolicyIntValue = this.reader.readEnumerated();
            DereferenceAliasesPolicy dereferencePolicy = DereferenceAliasesPolicy.valueOf(dereferencePolicyIntValue);
            if (dereferencePolicy == null) {
                throw LdapException.newLdapException(ResultCode.PROTOCOL_ERROR, CoreMessages.ERR_LDAP_SEARCH_REQUEST_DECODE_INVALID_DEREF.get(dereferencePolicyIntValue));
            }
            int sizeLimit = (int)this.reader.readInteger();
            int timeLimit = (int)this.reader.readInteger();
            boolean typesOnly = this.reader.readBoolean();
            Filter filter = Ldap.readFilter(this.reader);
            searchRequest = Requests.newSearchRequest(baseDN, scope, filter, new String[0]).setDereferenceAliasesPolicy(dereferencePolicy).setTimeLimit(timeLimit).setSizeLimit(sizeLimit).setTypesOnly(typesOnly);
            this.reader.readStartSequence();
            try {
                while (this.reader.hasNextElement()) {
                    searchRequest.addAttribute(this.reader.readOctetStringAsString());
                }
            }
            finally {
                this.reader.readEndSequence();
            }
        }
        catch (LocalizedIllegalArgumentException e) {
            LdapMessage ldapMessage = this.readInvalidRequest(Request.RequestType.SEARCH, messageID, baseDNString, LdapException.newLdapException(ResultCode.PROTOCOL_ERROR, e.getMessageObject(), e));
            return ldapMessage;
        }
        catch (LdapException e) {
            LdapMessage ldapMessage = this.readInvalidRequest(Request.RequestType.SEARCH, messageID, baseDNString, e);
            return ldapMessage;
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(searchRequest);
        logger.trace("DECODE LDAP SEARCH REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)searchRequest);
        return LdapMessage.newLdapMessage(messageID, (byte)99, searchRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readSearchResult(int messageID) throws IOException {
        Result searchResult;
        this.reader.readStartSequence((byte)101);
        try {
            ResultCode resultCode = ResultCode.valueOf(this.reader.readEnumerated());
            String matchedDN = this.reader.readOctetStringAsString();
            String diagnosticMessage = this.reader.readOctetStringAsString();
            searchResult = Responses.newResult(resultCode).setMatchedDn(matchedDN).setDiagnosticMessage(diagnosticMessage);
            this.readResponseReferrals(searchResult);
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(searchResult);
        logger.trace("DECODE LDAP SEARCH RESULT(messageID=%d, result=%s)", (Object)messageID, (Object)searchResult);
        return LdapMessage.newLdapMessage(messageID, (byte)101, searchResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readSearchResultEntry(int messageID) throws IOException {
        Entry entry;
        this.reader.readStartSequence();
        String dnString = null;
        try {
            dnString = this.reader.readOctetStringAsString();
            entry = this.readEntry(dnString);
        }
        finally {
            this.reader.readEndSequence();
        }
        SearchResultEntry searchResultEntry = Responses.newSearchResultEntry(entry);
        this.readControls(searchResultEntry);
        logger.trace("DECODE LDAP SEARCH RESULT ENTRY(messageID=%d, entry=%s)", (Object)messageID, (Object)searchResultEntry);
        return LdapMessage.newLdapMessage(messageID, (byte)100, searchResultEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LdapMessage readSearchResultReference(int messageID) throws IOException {
        SearchResultReference searchResultRef;
        this.reader.readStartSequence((byte)115);
        try {
            searchResultRef = Responses.newSearchResultReference(this.reader.readOctetStringAsString());
            while (this.reader.hasNextElement()) {
                searchResultRef.addUri(this.reader.readOctetStringAsString());
            }
        }
        finally {
            this.reader.readEndSequence();
        }
        this.readControls(searchResultRef);
        logger.trace("DECODE LDAP SEARCH RESULT REFERENCE(messageID=%d, reference=%s)", (Object)messageID, (Object)searchResultRef);
        return LdapMessage.newLdapMessage(messageID, (byte)115, searchResultRef);
    }

    private LdapMessage readUnbindRequest(int messageID) throws IOException {
        this.reader.readNull((byte)66);
        UnbindRequest unbindRequest = Requests.newUnbindRequest();
        this.readControls(unbindRequest);
        logger.trace("DECODE LDAP UNBIND REQUEST(messageID=%d, request=%s)", (Object)messageID, (Object)unbindRequest);
        return LdapMessage.newLdapMessage(messageID, (byte)66, unbindRequest);
    }
}

