/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.io;

import java.io.InputStream;
import java.io.OutputStream;
import org.forgerock.opendj.io.Asn1ByteSequenceReader;
import org.forgerock.opendj.io.Asn1InputStreamReader;
import org.forgerock.opendj.io.Asn1OutputStreamWriter;
import org.forgerock.opendj.io.Asn1Reader;
import org.forgerock.opendj.io.Asn1Writer;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteSequenceReader;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;

public final class Asn1 {
    private static final int DEFAULT_MAX_BUFFER_SIZE = 32768;
    public static final byte BOOLEAN_VALUE_FALSE = 0;
    public static final byte BOOLEAN_VALUE_TRUE = -1;
    public static final byte UNIVERSAL_BOOLEAN_TYPE = 1;
    public static final byte UNIVERSAL_INTEGER_TYPE = 2;
    public static final byte UNIVERSAL_BIT_STRING_TYPE = 3;
    public static final byte UNIVERSAL_OCTET_STRING_TYPE = 4;
    public static final byte UNIVERSAL_NULL_TYPE = 5;
    public static final byte UNIVERSAL_ENUMERATED_TYPE = 10;
    public static final byte UNIVERSAL_SEQUENCE_TYPE = 48;
    public static final byte UNIVERSAL_SET_TYPE = 49;
    public static final int ELEMENT_READ_STATE_NEED_ADDITIONAL_LENGTH_BYTES = 2;
    public static final int ELEMENT_READ_STATE_NEED_FIRST_LENGTH_BYTE = 1;
    public static final int ELEMENT_READ_STATE_NEED_TYPE = 0;
    public static final int ELEMENT_READ_STATE_NEED_VALUE_BYTES = 3;
    static final byte[] NO_VALUE = new byte[0];
    static final byte TYPE_MASK_ALL_BUT_CLASS = -64;
    static final byte TYPE_MASK_ALL_BUT_PC = 32;
    static final byte TYPE_MASK_APPLICATION = 64;
    public static final byte TYPE_MASK_CONSTRUCTED = 32;
    public static final byte TYPE_MASK_CONTEXT = -128;
    static final byte TYPE_MASK_PRIMITIVE = 0;
    static final byte TYPE_MASK_PRIVATE = -64;
    static final byte TYPE_MASK_UNIVERSAL = 0;

    public static Asn1Reader getReader(byte[] array) {
        return Asn1.getReader(array, 0);
    }

    public static Asn1Reader getReader(byte[] array, int maxElementSize) {
        return Asn1.getReader(ByteString.wrap(array), maxElementSize);
    }

    public static Asn1Reader getReader(ByteSequence sequence) {
        return Asn1.getReader(sequence, 0);
    }

    public static Asn1Reader getReader(ByteSequence sequence, int maxElementSize) {
        return new Asn1ByteSequenceReader(sequence.asReader(), maxElementSize);
    }

    public static Asn1Reader getReader(ByteSequenceReader reader) {
        return Asn1.getReader(reader, 0);
    }

    public static Asn1Reader getReader(ByteSequenceReader reader, int maxElementSize) {
        return new Asn1ByteSequenceReader(reader, maxElementSize);
    }

    public static Asn1Reader getReader(InputStream stream) {
        return Asn1.getReader(stream, 0);
    }

    public static Asn1Reader getReader(InputStream stream, int maxElementSize) {
        return new Asn1InputStreamReader(stream, maxElementSize);
    }

    public static Asn1Writer getWriter(ByteStringBuilder builder) {
        return Asn1.getWriter(builder.asOutputStream(), 32768);
    }

    public static Asn1Writer getWriter(ByteStringBuilder builder, int maxBufferSize) {
        return Asn1.getWriter(builder.asOutputStream(), maxBufferSize);
    }

    public static Asn1Writer getWriter(OutputStream stream) {
        return Asn1.getWriter(stream, 32768);
    }

    public static Asn1Writer getWriter(OutputStream stream, int maxBufferSize) {
        return new Asn1OutputStreamWriter(stream, maxBufferSize);
    }

    private Asn1() {
    }
}

