/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.grizzly;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.functions.Action;
import io.reactivex.functions.BiFunction;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Function;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.subjects.AsyncSubject;
import java.io.EOFException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import javax.security.sasl.SaslServer;
import org.forgerock.i18n.slf4j.LocalizedLogger;
import org.forgerock.opendj.grizzly.DisableOnUnbindFilter;
import org.forgerock.opendj.grizzly.GrizzlyUtils;
import org.forgerock.opendj.grizzly.LdapMessageCodec;
import org.forgerock.opendj.grizzly.SaslFilter;
import org.forgerock.opendj.grizzly.StartTlsFilter;
import org.forgerock.opendj.io.Ldap;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.LdapClientContext;
import org.forgerock.opendj.ldap.LdapClientContextEventListener;
import org.forgerock.opendj.ldap.LdapException;
import org.forgerock.opendj.ldap.LdapListener;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SslOptions;
import org.forgerock.opendj.ldap.messages.ExtendedResult;
import org.forgerock.opendj.ldap.messages.GenericExtendedResult;
import org.forgerock.opendj.ldap.messages.IntermediateResponse;
import org.forgerock.opendj.ldap.messages.LdapMessage;
import org.forgerock.opendj.ldap.messages.Request;
import org.forgerock.opendj.ldap.messages.Response;
import org.forgerock.opendj.ldap.messages.Responses;
import org.forgerock.opendj.ldap.messages.Result;
import org.forgerock.opendj.ldap.messages.SearchResultEntry;
import org.forgerock.opendj.ldap.messages.SearchResultReference;
import org.forgerock.util.Options;
import org.forgerock.util.Reject;
import org.glassfish.grizzly.CloseReason;
import org.glassfish.grizzly.CloseType;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.EmptyCompletionHandler;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.ssl.SSLUtils;
import org.glassfish.grizzly.utils.Exceptions;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class LdapServerFilter
extends BaseFilter {
    private final Function<LdapClientContext, BiFunction<Integer, Request, Flowable<Response>>> handlerFactory;
    private static final Object[][] CIPHER_KEY_SIZES = new Object[][]{{"_WITH_AES_256_CBC_", 256}, {"_WITH_CAMELLIA_256_CBC_", 256}, {"_WITH_AES_256_GCM_", 256}, {"_WITH_3DES_EDE_CBC_", 112}, {"_WITH_AES_128_GCM_", 128}, {"_WITH_SEED_CBC_", 128}, {"_WITH_CAMELLIA_128_CBC_", 128}, {"_WITH_AES_128_CBC_", 128}, {"_WITH_IDEA_CBC_", 128}, {"_WITH_RC4_128_", 128}, {"_WITH_FORTEZZA_CBC_", 96}, {"_WITH_DES_CBC_", 56}, {"_WITH_RC4_56_", 56}, {"_WITH_RC2_CBC_40_", 40}, {"_WITH_DES_CBC_40_", 40}, {"_WITH_RC4_40_", 40}, {"_WITH_DES40_CBC_", 40}, {"_WITH_NULL_", 0}};
    private static final LocalizedLogger logger = LocalizedLogger.getLoggerForThisClass();
    private volatile Options connectionOptions;

    LdapServerFilter(Function<LdapClientContext, BiFunction<Integer, Request, Flowable<Response>>> handlerFactory, Options connectionOptions) {
        this.handlerFactory = handlerFactory;
        this.connectionOptions = connectionOptions;
    }

    void setOptions(Options connectionOptions) {
        this.connectionOptions = connectionOptions;
    }

    Options getOptions() {
        return this.connectionOptions;
    }

    @Override
    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        BiFunction<Integer, Request, Flowable<Response>> handler;
        final Connection connection = ctx.getConnection();
        ClientConnectionImpl clientConnectionImpl = new ClientConnectionImpl(connection);
        SslOptions sslOptions = (SslOptions)this.connectionOptions.get(LdapListener.SSL_OPTIONS);
        FilterChainBuilder builder = FilterChainBuilder.stateless().addAll((FilterChain)connection.getProcessor()).add(sslOptions == null ? new StartTlsFilter() : new SSLFilter(GrizzlyUtils.newSslEngineConfiguration(sslOptions).setClientMode(false), null)).add(LdapMessageCodec.newServerMessageCodec(this.connectionOptions.get(LdapListener.REQUEST_MAX_SIZE_IN_BYTES), (DecodeOptions)this.connectionOptions.get(LdapListener.LDAP_DECODE_OPTIONS))).add(new DisableOnUnbindFilter()).add(clientConnectionImpl);
        connection.setProcessor(builder.build());
        try {
            handler = this.handlerFactory.apply(clientConnectionImpl);
        }
        catch (Exception e) {
            throw Exceptions.makeIOException(e);
        }
        NextAction suspendAction = ctx.getSuspendAction();
        ctx.suspend();
        clientConnectionImpl.read(ctx).flatMap(this.handleRequests(handler), this.toLdapResponseMessage(), false, this.connectionOptions.get(LdapListener.MAX_CONCURRENT_REQUESTS), 1).subscribe(new Subscriber<LdapMessage>(){
            private final EmptyCompletionHandler requestMoreOnCompletion = new EmptyCompletionHandler(){

                @Override
                public void completed(Object result) {
                    upstream.request(1L);
                }
            };
            private Subscription upstream;

            @Override
            public void onSubscribe(Subscription s) {
                this.upstream = s;
                this.upstream.request(2L);
                connection.closeFuture().addCompletionHandler((CompletionHandler<CloseReason>)new EmptyCompletionHandler<CloseReason>(){

                    @Override
                    public void completed(CloseReason unused) {
                        upstream.request(Long.MAX_VALUE);
                    }
                });
            }

            @Override
            public void onNext(LdapMessage response) {
                connection.write(response, this.requestMoreOnCompletion);
            }

            @Override
            public void onError(Throwable error) {
                connection.closeWithReason(Exceptions.makeIOException(error));
            }

            @Override
            public void onComplete() {
                connection.closeSilently();
            }
        });
        return suspendAction;
    }

    private Function<LdapMessage, Publisher<Response>> handleRequests(final BiFunction<Integer, Request, Flowable<Response>> handler) {
        return new Function<LdapMessage, Publisher<Response>>(){

            @Override
            public Publisher<Response> apply(LdapMessage requestMessage) throws Exception {
                try {
                    return ((Flowable)handler.apply(requestMessage.getMessageId(), (Request)requestMessage.getProtocolOp())).onErrorReturn(new Function<Throwable, Response>(){

                        @Override
                        public Response apply(Throwable error) throws Exception {
                            return LdapException.newLdapException(error).getResult();
                        }
                    });
                }
                catch (Throwable e) {
                    return Flowable.just(LdapException.newLdapException(e).getResult());
                }
            }
        };
    }

    private BiFunction<LdapMessage, Response, LdapMessage> toLdapResponseMessage() {
        return new BiFunction<LdapMessage, Response, LdapMessage>(){

            @Override
            public LdapMessage apply(LdapMessage requestMessage, Response response) {
                if (response instanceof Result) {
                    return LdapMessage.newLdapMessage(requestMessage.getMessageId(), Ldap.requestToResponseProtocolOpType(requestMessage.getProtocolOpType()), response);
                }
                if (response instanceof IntermediateResponse) {
                    return LdapMessage.newLdapMessage(requestMessage.getMessageId(), (byte)121, response);
                }
                if (response instanceof SearchResultEntry) {
                    return LdapMessage.newLdapMessage(requestMessage.getMessageId(), (byte)100, response);
                }
                if (response instanceof SearchResultReference) {
                    return LdapMessage.newLdapMessage(requestMessage.getMessageId(), (byte)115, response);
                }
                throw new IllegalArgumentException("Not implemented for a response of type " + (response != null ? response.getClass() : null));
            }
        };
    }

    final class ClientConnectionImpl
    extends BaseFilter
    implements LdapClientContext {
        private final Connection<?> connection;
        private volatile boolean isClosed;
        private final Collection<LdapClientContextEventListener> connectionEventListeners = new ConcurrentLinkedQueue<LdapClientContextEventListener>();
        private GrizzlyBackpressureSubscription downstream;

        private ClientConnectionImpl(Connection<?> connection) {
            this.connection = connection;
        }

        @Override
        public NextAction handleRead(FilterChainContext ctx) {
            return this.downstream.handleRead(ctx);
        }

        @Override
        public NextAction handleClose(FilterChainContext ctx) {
            this.isClosed = true;
            CloseReason closeReason = ctx.getConnection().getCloseReason();
            if (closeReason.getType().equals(CloseType.REMOTELY)) {
                this.notifyConnectionClosed();
            } else if (closeReason == CloseReason.LOCALLY_CLOSED_REASON) {
                this.notifyConnectionDisconnected(null, null);
            } else {
                IOException error = closeReason.getCause();
                ExtendedResult noticeOfDisconnection = this.extractNoticeOfDisconnection(error);
                if (noticeOfDisconnection != null) {
                    this.notifyConnectionDisconnected(noticeOfDisconnection.getResultCode(), noticeOfDisconnection.getDiagnosticMessage());
                } else {
                    this.notifyConnectionError(error);
                }
            }
            return ctx.getStopAction();
        }

        private ExtendedResult extractNoticeOfDisconnection(IOException exception) {
            ExtendedResult extendedResult;
            if (!(exception instanceof LdapException)) {
                return null;
            }
            LdapException ldapException = (LdapException)exception;
            if (ldapException.getResult() instanceof ExtendedResult && (extendedResult = (ExtendedResult)ldapException.getResult()).getOid().equals("1.3.6.1.4.1.1466.20036")) {
                return extendedResult;
            }
            return null;
        }

        Flowable<LdapMessage> read(final FilterChainContext suspendedContext) {
            return Flowable.fromPublisher(new Publisher<LdapMessage>(){

                @Override
                public void subscribe(Subscriber<? super LdapMessage> subscriber) {
                    if (ClientConnectionImpl.this.downstream != null) {
                        subscriber.onSubscribe(new Subscription(){

                            @Override
                            public void request(long n) {
                            }

                            @Override
                            public void cancel() {
                            }
                        });
                        subscriber.onError(new IllegalStateException("read() cannot be subscribed multiple times"));
                        return;
                    }
                    ClientConnectionImpl.this.downstream = new GrizzlyBackpressureSubscription(subscriber, suspendedContext);
                }
            });
        }

        @Override
        public SSLSession getSslSession() {
            SSLEngine sslEngine = SSLUtils.getSSLEngine(this.connection);
            return sslEngine != null ? sslEngine.getSession() : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean enableSasl(SaslServer saslServer) {
            Reject.ifNull(saslServer, "saslServer must not be null");
            ClientConnectionImpl clientConnectionImpl = this;
            synchronized (clientConnectionImpl) {
                if (this.filterExists(SaslFilter.class)) {
                    return false;
                }
                SaslFilter.setSaslServer(this.connection, saslServer);
                this.installFilter(new SaslFilter());
                return true;
            }
        }

        @Override
        public SaslServer getSaslServer() {
            return SaslFilter.getSaslServer(this.connection);
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            return (InetSocketAddress)this.connection.getLocalAddress();
        }

        @Override
        public InetSocketAddress getPeerAddress() {
            return (InetSocketAddress)this.connection.getPeerAddress();
        }

        @Override
        public int getSecurityStrengthFactor() {
            return Math.max(this.getSslSecurityStrengthFactor(), this.getSaslSecurityStrengthFactor());
        }

        private int getSslSecurityStrengthFactor() {
            SSLSession sslSession = this.getSslSession();
            if (sslSession != null) {
                String cipherString = sslSession.getCipherSuite();
                for (Object[] cipher : CIPHER_KEY_SIZES) {
                    if (!cipherString.contains((String)cipher[0])) continue;
                    return (Integer)cipher[1];
                }
            }
            return 0;
        }

        private int getSaslSecurityStrengthFactor() {
            SaslServer saslServer = this.getSaslServer();
            if (saslServer == null) {
                return 0;
            }
            int ssf = 0;
            String qop = (String)saslServer.getNegotiatedProperty("javax.security.sasl.qop");
            if ("auth-int".equalsIgnoreCase(qop)) {
                return 1;
            }
            if ("auth-conf".equalsIgnoreCase(qop)) {
                String negStrength = (String)saslServer.getNegotiatedProperty("javax.security.sasl.strength");
                if ("low".equalsIgnoreCase(negStrength)) {
                    return 40;
                }
                if ("medium".equalsIgnoreCase(negStrength)) {
                    return 56;
                }
                if ("high".equalsIgnoreCase(negStrength)) {
                    return 128;
                }
            }
            return ssf;
        }

        @Override
        public String toString() {
            return "LDAPClientContext(" + this.getLocalAddress() + ',' + this.getPeerAddress() + ')';
        }

        private void installFilter(Filter filter) {
            GrizzlyUtils.addFilterToConnection(filter, this.connection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean filterExists(Class<?> filterKlass) {
            ClientConnectionImpl clientConnectionImpl = this;
            synchronized (clientConnectionImpl) {
                FilterChain currentFilterChain = (FilterChain)this.connection.getProcessor();
                for (Filter filter : currentFilterChain) {
                    if (!filterKlass.isAssignableFrom(filter.getClass())) continue;
                    return true;
                }
                return false;
            }
        }

        @Override
        public void addListener(LdapClientContextEventListener listener) {
            Reject.ifNull(listener, "listener must not be null");
            this.connectionEventListeners.add(listener);
        }

        @Override
        public void disconnect() {
            this.connection.closeSilently();
        }

        @Override
        public void disconnect(ResultCode resultCode, String diagnosticMessage) {
            final GenericExtendedResult result = Responses.newGenericExtendedResult(resultCode).setOid("1.3.6.1.4.1.1466.20036").setDiagnosticMessage(diagnosticMessage);
            this.sendUnsolicitedNotification(result).subscribe(new Action(){

                @Override
                public void run() {
                    ClientConnectionImpl.this.connection.closeWithReason(LdapException.newLdapException(result));
                }
            }, (Consumer<? super Throwable>)new Consumer<Throwable>(){

                @Override
                public void accept(Throwable error) throws Exception {
                    ClientConnectionImpl.this.connection.closeWithReason(Exceptions.makeIOException(error));
                }
            });
        }

        private void notifyConnectionDisconnected(ResultCode resultCode, CharSequence diagnosticMessage) {
            for (LdapClientContextEventListener listener : this.connectionEventListeners) {
                try {
                    listener.handleConnectionDisconnected(this, resultCode, diagnosticMessage.toString());
                }
                catch (Exception e) {
                    logger.traceException(e);
                }
            }
        }

        private void notifyConnectionClosed() {
            for (LdapClientContextEventListener listener : this.connectionEventListeners) {
                try {
                    listener.handleConnectionClosed(this);
                }
                catch (Exception e) {
                    logger.traceException(e);
                }
            }
        }

        private void notifyConnectionError(Throwable error) {
            for (LdapClientContextEventListener listener : this.connectionEventListeners) {
                try {
                    listener.handleConnectionError(this, error);
                }
                catch (Exception e) {
                    logger.traceException(e);
                }
            }
        }

        @Override
        public boolean isClosed() {
            return this.isClosed;
        }

        @Override
        public Completable sendUnsolicitedNotification(ExtendedResult notification) {
            final AsyncSubject asyncSubject = AsyncSubject.create();
            this.connection.write(LdapMessage.newLdapMessage(0, (byte)120, notification), new EmptyCompletionHandler(){

                @Override
                public void cancelled() {
                    this.failed(new CancellationException());
                }

                @Override
                public void failed(Throwable throwable) {
                    asyncSubject.onError(throwable);
                }

                @Override
                public void completed(Object result) {
                    asyncSubject.onNext(Boolean.TRUE);
                    asyncSubject.onComplete();
                }
            });
            return Completable.fromObservable(asyncSubject);
        }

        private final class GrizzlyBackpressureSubscription
        extends EmptyCompletionHandler<CloseReason>
        implements Subscription {
            private static final long CANCEL = Long.MIN_VALUE;
            private final Subscriber<? super LdapMessage> subscriber;
            private final AtomicLong pendingRequests = new AtomicLong();
            private FilterChainContext suspendedCtx;

            GrizzlyBackpressureSubscription(Subscriber<? super LdapMessage> subscriber, FilterChainContext suspendedFilterChainContext) {
                this.subscriber = subscriber;
                this.suspendedCtx = suspendedFilterChainContext;
                subscriber.onSubscribe(this);
                ClientConnectionImpl.this.connection.closeFuture().addCompletionHandler(this);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            NextAction handleRead(FilterChainContext ctx) {
                if (this.pendingRequests.get() == 1L) {
                    this.subscriber.onNext((LdapMessage)ctx.getMessage());
                    GrizzlyBackpressureSubscription grizzlyBackpressureSubscription = this;
                    synchronized (grizzlyBackpressureSubscription) {
                        if (BackpressureHelper.producedCancel(this.pendingRequests, 1L) == 0L) {
                            ctx.suspend();
                            this.suspendedCtx = ctx;
                            return ctx.getSuspendAction();
                        }
                    }
                } else if (BackpressureHelper.producedCancel(this.pendingRequests, 1L) != Long.MIN_VALUE) {
                    this.subscriber.onNext((LdapMessage)ctx.getMessage());
                }
                return ctx.getStopAction();
            }

            @Override
            public void completed(CloseReason closeReason) {
                if (this.pendingRequests.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                    return;
                }
                IOException reason = closeReason.getCause();
                if (closeReason.equals(CloseReason.LOCALLY_CLOSED_REASON) || closeReason.getType().equals(CloseType.REMOTELY) || ClientConnectionImpl.this.extractNoticeOfDisconnection(reason) != null) {
                    this.subscriber.onComplete();
                } else {
                    this.subscriber.onError(reason);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void request(long n) {
                long previousPendingRequests = BackpressureHelper.addCancel(this.pendingRequests, n);
                if (previousPendingRequests == 0L) {
                    FilterChainContext toResume;
                    GrizzlyBackpressureSubscription grizzlyBackpressureSubscription = this;
                    synchronized (grizzlyBackpressureSubscription) {
                        toResume = this.suspendedCtx;
                        this.suspendedCtx = null;
                    }
                    if (toResume != null) {
                        toResume.resume(toResume.getStopAction());
                    }
                }
            }

            @Override
            public void cancel() {
                if (this.pendingRequests.getAndSet(Long.MIN_VALUE) != Long.MIN_VALUE) {
                    ClientConnectionImpl.this.connection.closeWithReason(new EOFException("read() has been cancelled"));
                }
            }
        }
    }
}

