/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.schema.validator.validators;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.schema.validator.ErrorHandler;
import org.forgerock.json.schema.validator.exceptions.SchemaException;
import org.forgerock.json.schema.validator.exceptions.ValidationException;
import org.forgerock.json.schema.validator.helpers.EnumHelper;
import org.forgerock.json.schema.validator.helpers.FormatHelper;
import org.forgerock.json.schema.validator.validators.Validator;

public class StringTypeValidator
extends Validator {
    private Pattern p = null;
    private int minLength = -1;
    private int maxLength = -1;
    private EnumHelper enumHelper = null;
    private FormatHelper formatHelper = null;

    public StringTypeValidator(Map<String, Object> schema, List<String> jsonPointer) {
        super(schema, jsonPointer);
        for (Map.Entry<String, Object> e : schema.entrySet()) {
            if ("pattern".equals(e.getKey())) {
                if (!(e.getValue() instanceof String)) continue;
                String pattern = (String)e.getValue();
                try {
                    this.p = Pattern.compile(pattern, 64);
                }
                catch (PatternSyntaxException patternSyntaxException) {}
                continue;
            }
            if ("required".equals(e.getKey())) {
                if (e.getValue() instanceof Boolean) {
                    this.required = (Boolean)e.getValue();
                    continue;
                }
                if (!(e.getValue() instanceof String)) continue;
                this.required = Boolean.parseBoolean((String)e.getValue());
                continue;
            }
            if ("minLength".equals(e.getKey())) {
                if (!(e.getValue() instanceof Number)) continue;
                this.minLength = ((Number)e.getValue()).intValue();
                continue;
            }
            if ("maxLength".equals(e.getKey())) {
                if (!(e.getValue() instanceof Number)) continue;
                this.maxLength = ((Number)e.getValue()).intValue();
                continue;
            }
            if ("enum".equals(e.getKey())) {
                if (!(e.getValue() instanceof List)) continue;
                this.enumHelper = new EnumHelper((List)e.getValue());
                continue;
            }
            if (!"format".equals(e.getKey()) || !(e.getValue() instanceof String)) continue;
            this.formatHelper = new FormatHelper((String)e.getValue());
        }
    }

    @Override
    public void validate(Object node, JsonPointer at, ErrorHandler handler) throws SchemaException {
        if (node instanceof String) {
            Matcher m;
            String nodeValue = (String)node;
            if (this.minLength > -1 && nodeValue.length() < this.minLength) {
                handler.error(new ValidationException("minLength error", this.getPath(at, null)));
            }
            if (this.maxLength > -1 && nodeValue.length() > this.maxLength) {
                handler.error(new ValidationException("maxLength error", this.getPath(at, null)));
            }
            if (null != this.p && !(m = this.p.matcher(nodeValue)).matches()) {
                handler.error(new ValidationException(this.getPath(at, null) + ": does not match the regex pattern " + this.p.pattern(), this.getPath(at, null)));
            }
            if (null != this.enumHelper) {
                this.enumHelper.validate(node, at, handler);
            }
            if (null != this.formatHelper) {
                this.formatHelper.validate(node, at, handler);
            }
        } else if (null != node) {
            handler.error(new ValidationException("Type mismatch at {}. Expected type {} found {}", this.getPath(at, null)));
        } else if (this.required) {
            handler.error(new ValidationException("Required property violation at {}", this.getPath(at, null)));
        }
    }
}

