/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.schema.validator.validators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.schema.validator.CollectErrorsHandler;
import org.forgerock.json.schema.validator.ErrorHandler;
import org.forgerock.json.schema.validator.ObjectValidatorFactory;
import org.forgerock.json.schema.validator.exceptions.ValidationException;
import org.forgerock.json.schema.validator.validators.SimpleValidator;
import org.forgerock.json.schema.validator.validators.Validator;

public class ObjectTypeValidator
extends Validator {
    private final Map<String, PropertyValidatorBag> propertyValidators;
    private final Set<String> requiredPropertyNames = new HashSet<String>();
    private Map<String, Validator> dependenciesValidators;
    private Map<String, Set<String>> dependencyValues;
    private Map<Pattern, Validator> patternPropertyValidators;
    private boolean allowAdditionalProperties = true;
    private Validator additionalPropertyValidator = null;
    private List<Validator> oneOfValidators;
    private Map<String, Validator> definitionValidators;

    /*
     * WARNING - void declaration
     */
    public ObjectTypeValidator(Map<String, Object> schema, List<String> jsonPointer) {
        super(schema, jsonPointer);
        List<String> newPointer;
        Map objectProperties = (Map)schema.get("properties");
        if (null != objectProperties) {
            this.propertyValidators = new HashMap<String, PropertyValidatorBag>(objectProperties.size());
            for (Map.Entry<String, Object> entry : objectProperties.entrySet()) {
                newPointer = this.newList(jsonPointer, "properties", entry.getKey());
                Validator validator = ObjectValidatorFactory.getTypeValidator((Map)entry.getValue(), newPointer);
                this.propertyValidators.put(entry.getKey(), new PropertyValidatorBag(validator));
            }
        } else {
            this.propertyValidators = Collections.emptyMap();
        }
        for (Map.Entry<String, Object> entry : schema.entrySet()) {
            List<String> newPointer2;
            if ("additionalProperties".equals(entry.getKey())) {
                if (entry.getValue() instanceof Boolean && !((Boolean)entry.getValue()).booleanValue() || entry.getValue() instanceof String && entry.getValue().equals("false")) {
                    this.allowAdditionalProperties = false;
                    continue;
                }
                if (entry.getValue() == null || !(entry.getValue() instanceof Map)) continue;
                newPointer = this.newList(jsonPointer, "additionalProperties", entry.getKey());
                this.additionalPropertyValidator = ObjectValidatorFactory.getTypeValidator((Map)entry.getValue(), newPointer);
                continue;
            }
            if ("patternProperties".equals(entry.getKey())) {
                if (!(entry.getValue() instanceof Map)) continue;
                Iterator properties = (Map)entry.getValue();
                this.patternPropertyValidators = new HashMap<Pattern, Validator>(properties.size());
                for (Map.Entry entry2 : properties.entrySet()) {
                    try {
                        Pattern p = Pattern.compile((String)entry2.getKey());
                        List<String> newPointer3 = this.newList(jsonPointer, "patternProperties", (String)entry2.getKey());
                        Validator validator = ObjectValidatorFactory.getTypeValidator((Map)entry2.getValue(), newPointer3);
                        this.patternPropertyValidators.put(p, validator);
                    }
                    catch (PatternSyntaxException p) {}
                }
                continue;
            }
            if ("dependencies".equals(entry.getKey())) {
                if (!(entry.getValue() instanceof Map)) continue;
                for (Map.Entry entry3 : ((Map)entry.getValue()).entrySet()) {
                    PropertyValidatorBag validator = this.propertyValidators.get(entry3.getKey());
                    if (null != validator) {
                        if (entry3.getValue() instanceof Map) {
                            List<String> newPointer22 = this.newList(jsonPointer, "dependencies", (String)entry3.getKey());
                            validator.setDependencyValidator(ObjectValidatorFactory.getTypeValidator((Map)entry3.getValue(), newPointer22));
                            continue;
                        }
                        validator.setDependencyValue(entry3.getValue());
                        continue;
                    }
                    if (null == this.dependencyValues) {
                        this.dependencyValues = new HashMap<String, Set<String>>(1);
                    }
                    if (entry3.getValue() instanceof Map) continue;
                    if (entry3.getValue() instanceof String) {
                        this.dependencyValues.put((String)entry3.getKey(), Collections.singleton((String)entry3.getValue()));
                        continue;
                    }
                    if (!(entry3.getValue() instanceof Collection)) continue;
                    this.dependencyValues.put((String)entry3.getKey(), new HashSet((Collection)entry3.getValue()));
                }
                continue;
            }
            if ("required".equals(entry.getKey())) {
                if (!(entry.getValue() instanceof List)) continue;
                for (Object e : (List)entry.getValue()) {
                    if (!(e instanceof String)) continue;
                    this.requiredPropertyNames.add((String)e);
                }
                continue;
            }
            if ("oneOf".equals(entry.getKey())) {
                void var7_14;
                if (!(entry.getValue() instanceof List)) continue;
                List l = (List)entry.getValue();
                this.oneOfValidators = new ArrayList<Validator>(l.size());
                boolean bl = false;
                while (var7_14 < l.size()) {
                    Object obj = l.get((int)var7_14);
                    if (obj instanceof Map) {
                        newPointer2 = this.newList(jsonPointer, "oneOf", Integer.toString((int)var7_14));
                        this.oneOfValidators.add(ObjectValidatorFactory.getTypeValidator((Map)obj, newPointer2));
                    }
                    ++var7_14;
                }
                continue;
            }
            if (!"definitions".equals(entry.getKey()) || !(entry.getValue() instanceof Map)) continue;
            Map definitions = (Map)entry.getValue();
            this.definitionValidators = new HashMap<String, Validator>(definitions.size());
            for (Map.Entry entry2 : definitions.entrySet()) {
                if (!(entry2.getValue() instanceof Map)) continue;
                newPointer2 = this.newList(jsonPointer, "definitions", (String)entry2.getKey());
                Validator validator = ObjectValidatorFactory.getTypeValidator((Map)entry2.getValue(), newPointer2);
                this.definitionValidators.put((String)entry2.getKey(), validator);
            }
        }
    }

    @Override
    public void validate(Object value, JsonPointer at, ErrorHandler handler) {
        if (value instanceof Map) {
            Map mapValue = (Map)value;
            if (!mapValue.keySet().containsAll(this.requiredPropertyNames)) {
                HashSet<String> missingRequiredProperties = new HashSet<String>(this.requiredPropertyNames);
                missingRequiredProperties.removeAll(mapValue.keySet());
                handler.error(new ValidationException("Missing required property names: " + missingRequiredProperties, this.getPath(at, null)));
            }
            HashSet additionalPropertyNames = new HashSet(mapValue.keySet());
            Set<String> instancePropertyKeySet = Collections.unmodifiableSet(mapValue.keySet());
            for (Map.Entry<String, PropertyValidatorBag> schemaProperty : this.propertyValidators.entrySet()) {
                String propertyName = schemaProperty.getKey();
                PropertyValidatorBag propertyValue = schemaProperty.getValue();
                if (mapValue.containsKey(propertyName)) {
                    Object entryValue = mapValue.get(propertyName);
                    propertyValue.validate(entryValue, instancePropertyKeySet, this.getPath(at, propertyName), handler);
                    additionalPropertyNames.remove(propertyName);
                    continue;
                }
                if (!propertyValue.isRequired()) continue;
                handler.error(new ValidationException("Required property value is null", this.getPath(at, propertyName)));
            }
            Iterator iter = additionalPropertyNames.iterator();
            block1: while (iter.hasNext()) {
                Validator dependencyPropertyValidator;
                String additionalPropertyName = (String)iter.next();
                Object propertyValue = mapValue.get(additionalPropertyName);
                if (null != this.additionalPropertyValidator) {
                    this.additionalPropertyValidator.validate(propertyValue, this.getPath(at, additionalPropertyName), handler);
                }
                Validator validator = dependencyPropertyValidator = null != this.dependenciesValidators ? this.dependenciesValidators.get(additionalPropertyName) : null;
                if (null != dependencyPropertyValidator) {
                    dependencyPropertyValidator.validate(propertyValue, this.getPath(at, additionalPropertyName), handler);
                }
                if (null == this.patternPropertyValidators) continue;
                for (Map.Entry<Pattern, Validator> v : this.patternPropertyValidators.entrySet()) {
                    Matcher matcher = v.getKey().matcher(additionalPropertyName);
                    if (!matcher.find()) continue;
                    iter.remove();
                    v.getValue().validate(propertyValue, this.getPath(at, additionalPropertyName), handler);
                    continue block1;
                }
            }
            if (null != this.oneOfValidators) {
                boolean oneIsvalid = false;
                for (Validator validator : this.oneOfValidators) {
                    CollectErrorsHandler collectErrorsHandler = new CollectErrorsHandler();
                    validator.validate(mapValue, this.getPath(at, null), collectErrorsHandler);
                    if (collectErrorsHandler.hasError()) continue;
                    oneIsvalid = true;
                    break;
                }
                if (oneIsvalid) {
                    additionalPropertyNames.remove(mapValue.keySet().iterator().next());
                } else {
                    handler.error(new ValidationException("Error: Expected one of the validators to validate value", this.getPath(at, null)));
                }
            }
            if (!this.allowAdditionalProperties && !additionalPropertyNames.isEmpty()) {
                handler.error(new ValidationException("Error: Additional Properties not allowed: " + additionalPropertyNames, this.getPath(at, null)));
            }
        } else if (null != value) {
            handler.error(new ValidationException("Type mismatch at {}. Expected type {} found {}", this.getPath(at, null)));
        } else if (this.required) {
            handler.error(new ValidationException("Required property violation at {}", this.getPath(at, null)));
        }
    }

    @Override
    protected void collectAllValidators(Collection<Validator> results) {
        results.add(this);
        ObjectTypeValidator val = this;
        for (PropertyValidatorBag v : val.propertyValidators.values()) {
            v.collectAllValidators(results);
        }
        ObjectTypeValidator.collectAllValidators(results, val.patternPropertyValidators);
        if (val.additionalPropertyValidator != null) {
            val.additionalPropertyValidator.collectAllValidators(results);
        }
        ObjectTypeValidator.collectAllValidators(results, val.oneOfValidators);
        ObjectTypeValidator.collectAllValidators(results, val.definitionValidators);
    }

    private static final class PropertyValidatorBag
    implements SimpleValidator<Object> {
        private final Validator propertyValidator;
        private Validator dependencyValidator = null;
        private Set<String> requiredProperties = null;

        private PropertyValidatorBag(Validator propertyValidator) {
            this.propertyValidator = propertyValidator;
        }

        private void setDependencyValidator(Validator dependencyValidator) {
            this.dependencyValidator = dependencyValidator;
        }

        private void setDependencyValue(Object dependencyValue) {
            if (dependencyValue instanceof String) {
                this.requiredProperties = Collections.singleton((String)dependencyValue);
            } else if (dependencyValue instanceof Collection) {
                this.requiredProperties = new HashSet<String>((Collection)dependencyValue);
            }
        }

        private boolean isRequired() {
            return this.propertyValidator.isRequired();
        }

        private void collectAllValidators(Collection<Validator> results) {
            if (this.propertyValidator != null) {
                this.propertyValidator.collectAllValidators(results);
            }
            if (this.dependencyValidator != null) {
                this.dependencyValidator.collectAllValidators(results);
            }
        }

        @Override
        public void validate(Object value, JsonPointer at, ErrorHandler handler) {
            this.propertyValidator.validate(value, at, handler);
            if (null != this.dependencyValidator) {
                this.dependencyValidator.validate(value, at, handler);
            }
        }

        public void validate(Object value, Set<String> propertyKeySet, JsonPointer at, ErrorHandler handler) {
            if (null != this.requiredProperties && !propertyKeySet.containsAll(this.requiredProperties)) {
                handler.error(new ValidationException("Dependency ERROR: Missing properties", at));
            }
            this.validate(value, at, handler);
        }
    }
}

