/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.schema.validator.helpers;

import java.lang.reflect.Method;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.schema.validator.ErrorHandler;
import org.forgerock.json.schema.validator.exceptions.SchemaException;
import org.forgerock.json.schema.validator.exceptions.ValidationException;
import org.forgerock.json.schema.validator.validators.SimpleValidator;

public class MaximumHelper
implements SimpleValidator<Number> {
    private final Number maximum;
    private int exclusiveMaximum = 0;

    public MaximumHelper(Number maximum, boolean exclusiveMaximum) {
        this.maximum = maximum;
        this.exclusiveMaximum = exclusiveMaximum ? 1 : 0;
    }

    @Override
    public void validate(Number node, JsonPointer at, ErrorHandler handler) throws SchemaException {
        if (this.maximum.getClass().isAssignableFrom(node.getClass())) {
            try {
                Method method = this.maximum.getClass().getMethod("compareTo", this.maximum.getClass());
                method.invoke((Object)this.maximum, node);
                if ((Integer)method.invoke((Object)this.maximum, node) < this.exclusiveMaximum) {
                    handler.error(new ValidationException("minimum violation", at));
                }
            }
            catch (Exception e) {
                handler.error(new ValidationException("Reflection exception at \"compareTo\" method invocation.", e, at));
            }
        } else if (this.maximum instanceof Float) {
            if (((Float)this.maximum).compareTo(Float.valueOf(node.floatValue())) < this.exclusiveMaximum) {
                handler.error(new ValidationException("maximum violation", at));
            }
        } else if (this.maximum instanceof Double) {
            if (((Double)this.maximum).compareTo(node.doubleValue()) < this.exclusiveMaximum) {
                handler.error(new ValidationException("maximum violation", at));
            }
        } else if (this.maximum instanceof Integer) {
            if (((Integer)this.maximum).compareTo(node.intValue()) < this.exclusiveMaximum) {
                handler.error(new ValidationException("maximum violation", at));
            }
        } else if (this.maximum instanceof Long && ((Long)this.maximum).compareTo(node.longValue()) < this.exclusiveMaximum) {
            handler.error(new ValidationException("maximum violation", at));
        }
    }
}

