/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource;

import org.forgerock.http.routing.UriRouterContext;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CollectionResourceProvider;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.RequestHandler;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Resources;
import org.forgerock.json.resource.Response;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;

class InterfaceCollectionHandler
implements RequestHandler {
    private final CollectionResourceProvider provider;

    InterfaceCollectionHandler(CollectionResourceProvider provider) {
        this.provider = provider;
    }

    @Override
    public Promise<ActionResponse, ResourceException> handleAction(Context context, ActionRequest request) {
        return this.provider.actionCollection(Resources.parentOf(context), request);
    }

    @Override
    public Promise<ResourceResponse, ResourceException> handleCreate(Context context, CreateRequest request) {
        return this.provider.createInstance(Resources.parentOf(context), request);
    }

    @Override
    public final Promise<ResourceResponse, ResourceException> handleDelete(Context context, DeleteRequest request) {
        return InterfaceCollectionHandler.cannotHandleRequest("The resource collection %s cannot be deleted", context);
    }

    @Override
    public final Promise<ResourceResponse, ResourceException> handlePatch(Context context, PatchRequest request) {
        return InterfaceCollectionHandler.cannotHandleRequest("The resource collection %s cannot be patched", context);
    }

    @Override
    public Promise<QueryResponse, ResourceException> handleQuery(Context context, QueryRequest request, QueryResourceHandler handler) {
        return this.provider.queryCollection(Resources.parentOf(context), request, handler);
    }

    @Override
    public final Promise<ResourceResponse, ResourceException> handleRead(Context context, ReadRequest request) {
        return InterfaceCollectionHandler.cannotHandleRequest("The resource collection %s cannot be read", context);
    }

    @Override
    public final Promise<ResourceResponse, ResourceException> handleUpdate(Context context, UpdateRequest request) {
        return InterfaceCollectionHandler.cannotHandleRequest("The resource collection %s cannot be updated", context);
    }

    static <R extends Response> Promise<R, ResourceException> cannotHandleRequest(String errorMsg, Context context) {
        while (context.getParent().containsContext(UriRouterContext.class)) {
            context = context.getParent().asContext(UriRouterContext.class);
        }
        return Resources.newBadRequestException(errorMsg, context.asContext(UriRouterContext.class).getRemainingUri()).asPromise();
    }
}

