/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.utils;

import java.math.BigInteger;
import org.forgerock.util.encode.Base64url;

public final class BigIntegerUtils {
    private BigIntegerUtils() {
    }

    public static byte[] toBytesUnsigned(BigInteger x) {
        byte[] xBytes = x.abs().toByteArray();
        if (xBytes.length == 0 || xBytes[0] != 0) {
            return xBytes;
        }
        byte[] unsignedBigEndian = new byte[xBytes.length - 1];
        System.arraycopy(xBytes, 1, unsignedBigEndian, 0, xBytes.length - 1);
        return unsignedBigEndian;
    }

    public static BigInteger base64UrlDecode(String magnitudeBase64UrlEncoded) {
        boolean positive = true;
        return new BigInteger(1, Base64url.decode(magnitudeBase64UrlEncoded));
    }

    public static String base64UrlEncodeUnsignedBigIndian(BigInteger number) {
        return Base64url.encode(BigIntegerUtils.toBytesUnsigned(number));
    }
}

