/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.tokenhandler;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.security.KeyPair;
import java.util.Date;
import java.util.Map;
import org.forgerock.guava.common.base.Optional;
import org.forgerock.json.JsonValue;
import org.forgerock.json.jose.builders.EncryptedJwtBuilder;
import org.forgerock.json.jose.builders.JweHeaderBuilder;
import org.forgerock.json.jose.builders.JwtBuilderFactory;
import org.forgerock.json.jose.builders.JwtClaimsSetBuilder;
import org.forgerock.json.jose.jwe.EncryptionMethod;
import org.forgerock.json.jose.jwe.JweAlgorithm;
import org.forgerock.json.jose.jws.JwsAlgorithm;
import org.forgerock.json.jose.jws.SignedEncryptedJwt;
import org.forgerock.json.jose.jws.handlers.SigningHandler;
import org.forgerock.json.jose.jwt.JwtClaimsSet;
import org.forgerock.tokenhandler.ExpiredTokenException;
import org.forgerock.tokenhandler.InvalidTokenException;
import org.forgerock.tokenhandler.TokenHandler;
import org.forgerock.tokenhandler.TokenHandlerException;
import org.forgerock.util.Reject;

public final class JwtTokenHandler
implements TokenHandler {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private final JwtBuilderFactory jwtBuilderFactory;
    private final JweAlgorithm jweAlgorithm;
    private final EncryptionMethod jweMethod;
    private final KeyPair jweKeyPair;
    private final JwsAlgorithm jwsAlgorithm;
    private final SigningHandler jwsHandler;
    private final Optional<Long> tokenLifeTimeInSeconds;

    public JwtTokenHandler(JweAlgorithm jweAlgorithm, EncryptionMethod jweMethod, KeyPair jweKeyPair, JwsAlgorithm jwsAlgorithm, SigningHandler jwsHandler) {
        this(jweAlgorithm, jweMethod, jweKeyPair, jwsAlgorithm, jwsHandler, Optional.absent());
    }

    public JwtTokenHandler(JweAlgorithm jweAlgorithm, EncryptionMethod jweMethod, KeyPair jweKeyPair, JwsAlgorithm jwsAlgorithm, SigningHandler jwsHandler, Optional<Long> tokenLifeTimeInSeconds) {
        Reject.ifNull(new Object[]{jweAlgorithm, jweMethod, jweKeyPair, jwsAlgorithm, jwsHandler});
        Reject.ifTrue(tokenLifeTimeInSeconds.isPresent() && tokenLifeTimeInSeconds.get() <= 0L);
        this.jwtBuilderFactory = new JwtBuilderFactory();
        this.jweAlgorithm = jweAlgorithm;
        this.jweMethod = jweMethod;
        this.jweKeyPair = jweKeyPair;
        this.jwsAlgorithm = jwsAlgorithm;
        this.jwsHandler = jwsHandler;
        this.tokenLifeTimeInSeconds = tokenLifeTimeInSeconds;
    }

    @Override
    public String generate(JsonValue state) throws TokenHandlerException {
        Reject.ifNull(state);
        try {
            JwtClaimsSetBuilder claimsSetBuilder = this.jwtBuilderFactory.claims().claim("state", MAPPER.writeValueAsString(state.getObject()));
            JwtClaimsSet claimsSet = this.tokenLifeTimeInSeconds.isPresent() ? claimsSetBuilder.exp(new Date(System.currentTimeMillis() + this.tokenLifeTimeInSeconds.get() * 1000L)).build() : claimsSetBuilder.build();
            return ((EncryptedJwtBuilder)((JweHeaderBuilder)this.jwtBuilderFactory.jwe(this.jweKeyPair.getPublic()).headers().alg(this.jweAlgorithm)).enc(this.jweMethod).done()).claims(claimsSet).sign(this.jwsHandler, this.jwsAlgorithm).build();
        }
        catch (IOException e) {
            throw new TokenHandlerException("Error serializing token state", e);
        }
        catch (RuntimeException e) {
            throw new TokenHandlerException("Error constructing token", e);
        }
    }

    @Override
    public void validate(String snapshotToken) throws TokenHandlerException {
        this.validateAndExtractClaims(snapshotToken);
    }

    @Override
    public JsonValue validateAndExtractState(String snapshotToken) throws TokenHandlerException {
        Reject.ifNull(snapshotToken);
        try {
            JwtClaimsSet claimsSet = this.validateAndExtractClaims(snapshotToken);
            return JsonValue.json(MAPPER.readValue(claimsSet.getClaim("state").toString(), Map.class));
        }
        catch (IOException e) {
            throw new InvalidTokenException("Failed to parse token state as JSON", e);
        }
    }

    private JwtClaimsSet validateAndExtractClaims(String snapshotToken) throws TokenHandlerException {
        try {
            SignedEncryptedJwt signedEncryptedJwt = this.jwtBuilderFactory.reconstruct(snapshotToken, SignedEncryptedJwt.class);
            if (!signedEncryptedJwt.verify(this.jwsHandler)) {
                throw new InvalidTokenException("Invalid token");
            }
            signedEncryptedJwt.decrypt(this.jweKeyPair.getPrivate());
            JwtClaimsSet claimsSet = signedEncryptedJwt.getClaimsSet();
            Date expirationTime = claimsSet.getExpirationTime();
            if (expirationTime != null && expirationTime.before(new Date())) {
                throw new ExpiredTokenException("Token has expired");
            }
            return claimsSet;
        }
        catch (RuntimeException e) {
            throw new InvalidTokenException("Invalid token", e);
        }
    }
}

