/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwe.handlers.encryption;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.forgerock.json.jose.exceptions.JweDecryptionException;
import org.forgerock.json.jose.exceptions.JweEncryptionException;
import org.forgerock.json.jose.jwe.EncryptionMethod;
import org.forgerock.json.jose.jwe.JweEncryption;
import org.forgerock.json.jose.jwe.handlers.encryption.ContentEncryptionHandler;
import org.forgerock.json.jose.utils.Utils;

final class AESCBCHMACSHA2ContentEncryptionHandler
extends ContentEncryptionHandler {
    private static final Logger LOGGER = Logger.getLogger(AESCBCHMACSHA2ContentEncryptionHandler.class.getName());
    private static final String RAW_KEY_FORMAT = "RAW";
    private final EncryptionMethod method;

    AESCBCHMACSHA2ContentEncryptionHandler(EncryptionMethod method) {
        this.method = method;
    }

    @Override
    public JweEncryption encrypt(Key key, byte[] iv, byte[] plainText, byte[] additionalData) {
        SecretKey macKey = AESCBCHMACSHA2ContentEncryptionHandler.macKey(key, this.method);
        SecretKey encryptionKey = AESCBCHMACSHA2ContentEncryptionHandler.encKey(key, this.method);
        try {
            Cipher cipher = Cipher.getInstance(this.method.getTransformation());
            cipher.init(1, (Key)encryptionKey, new IvParameterSpec(iv));
            byte[] cipherText = cipher.doFinal(plainText);
            long alLength = (long)additionalData.length * 8L;
            byte[] al = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(alLength).array();
            Mac mac = Mac.getInstance(this.method.getMacAlgorithm());
            mac.init(macKey);
            mac.update(additionalData);
            mac.update(iv);
            mac.update(cipherText);
            mac.update(al);
            byte[] authenticationTag = Arrays.copyOf(mac.doFinal(), this.method.getKeyOffset());
            return new JweEncryption(cipherText, authenticationTag);
        }
        catch (GeneralSecurityException e) {
            throw new JweEncryptionException(e);
        }
    }

    @Override
    public byte[] decrypt(Key key, byte[] iv, JweEncryption cipherText, byte[] additionalData) {
        SecretKey macKey = AESCBCHMACSHA2ContentEncryptionHandler.macKey(key, this.method);
        SecretKey encKey = AESCBCHMACSHA2ContentEncryptionHandler.encKey(key, this.method);
        long alLength = (long)additionalData.length * 8L;
        byte[] al = ByteBuffer.allocate(8).order(ByteOrder.BIG_ENDIAN).putLong(alLength).array();
        try {
            Mac mac = Mac.getInstance(this.method.getMacAlgorithm());
            mac.init(macKey);
            mac.update(additionalData);
            mac.update(iv);
            mac.update(cipherText.getCiphertext());
            mac.update(al);
            byte[] tag = Arrays.copyOf(mac.doFinal(), this.method.getKeyOffset());
            boolean macValid = Utils.constantEquals(tag, cipherText.getAuthenticationTag());
            Cipher cipher = Cipher.getInstance(this.method.getTransformation());
            cipher.init(2, (Key)encKey, new IvParameterSpec(iv));
            byte[] plainText = cipher.doFinal(cipherText.getCiphertext());
            if (!macValid) {
                throw new GeneralSecurityException("MAC verification failed");
            }
            return plainText;
        }
        catch (GeneralSecurityException ex) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Decryption failed: " + ex, ex);
            }
            throw new JweDecryptionException();
        }
    }

    @Override
    Key generateEncryptionKey() {
        try {
            int macKeySize = this.method.getKeyOffset() * 8;
            KeyGenerator macKeyGenerator = KeyGenerator.getInstance(this.method.getMacAlgorithm());
            macKeyGenerator.init(macKeySize);
            SecretKey macKey = macKeyGenerator.generateKey();
            if (!RAW_KEY_FORMAT.equals(macKey.getFormat())) {
                throw new IllegalStateException("HMAC KeyGenerator returned non-RAW key material!");
            }
            int encKeySize = this.method.getKeySize() - macKeySize;
            KeyGenerator encKeyGenerator = KeyGenerator.getInstance(this.method.getEncryptionAlgorithm());
            encKeyGenerator.init(encKeySize);
            SecretKey encKey = encKeyGenerator.generateKey();
            if (!RAW_KEY_FORMAT.equals(macKey.getFormat())) {
                throw new IllegalStateException("AES KeyGenerator returned non-RAW key material!");
            }
            byte[] combinedKey = ByteBuffer.allocate(this.method.getKeySize() / 8).put(macKey.getEncoded()).put(encKey.getEncoded()).array();
            return new SecretKeySpec(combinedKey, this.method.getEncryptionAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new JweEncryptionException("Unsupported Encryption Algorithm, " + this.method.getEncryptionAlgorithm(), e);
        }
    }

    private static SecretKey macKey(Key combinedKey, EncryptionMethod method) {
        return new SecretKeySpec(combinedKey.getEncoded(), 0, method.getKeyOffset(), method.getMacAlgorithm());
    }

    private static SecretKey encKey(Key combinedKey, EncryptionMethod method) {
        return new SecretKeySpec(combinedKey.getEncoded(), method.getKeyOffset(), method.getKeyOffset(), method.getEncryptionAlgorithm());
    }
}

