/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwe;

import org.forgerock.json.jose.exceptions.JweException;
import org.forgerock.json.jose.jwe.JweAlgorithmType;
import org.forgerock.json.jose.jwt.Algorithm;

public enum JweAlgorithm implements Algorithm
{
    RSAES_PKCS1_V1_5("RSA1_5", "RSA/ECB/PKCS1Padding", JweAlgorithmType.RSA),
    RSA_OAEP("RSA-OAEP", "RSA/ECB/OAEPWithSHA-1AndMGF1Padding", JweAlgorithmType.RSA),
    RSA_OAEP_256("RSA-OAEP-256", "RSA/ECB/OAEPWithSHA-256AndMGF1Padding", JweAlgorithmType.RSA),
    DIRECT("dir", (String)null, JweAlgorithmType.DIRECT),
    A128KW("A128KW", "AESWrap", JweAlgorithmType.AES_KEYWRAP),
    A192KW("A192KW", "AESWrap", JweAlgorithmType.AES_KEYWRAP),
    A256KW("A256KW", "AESWrap", JweAlgorithmType.AES_KEYWRAP),
    ECDH_ES("ECDH-ES", DIRECT, JweAlgorithmType.ECDH_ES),
    ECDH_ES_A128KW("ECDH-ES+A128KW", A128KW, JweAlgorithmType.ECDH_ES),
    ECDH_ES_A192KW("ECDH-ES+A192KW", A192KW, JweAlgorithmType.ECDH_ES),
    ECDH_ES_A256KW("ECDH-ES+A256KW", A256KW, JweAlgorithmType.ECDH_ES);

    private final String jwaAlgorithmName;
    private final String transformation;
    private final JweAlgorithmType algorithmType;
    private final JweAlgorithm keyWrappingAlgorithm;

    private JweAlgorithm(String jwaAlgorithmName, String transformation, JweAlgorithmType algorithmType) {
        this.jwaAlgorithmName = jwaAlgorithmName;
        this.transformation = transformation;
        this.algorithmType = algorithmType;
        this.keyWrappingAlgorithm = null;
    }

    private JweAlgorithm(String jwaAlgorithmName, JweAlgorithm keyWrappingAlgorithm, JweAlgorithmType algorithmType) {
        this.jwaAlgorithmName = jwaAlgorithmName;
        this.transformation = null;
        this.algorithmType = algorithmType;
        this.keyWrappingAlgorithm = keyWrappingAlgorithm;
    }

    @Override
    public String getAlgorithm() {
        return this.transformation;
    }

    @Override
    public String getJwaAlgorithmName() {
        return this.jwaAlgorithmName;
    }

    public JweAlgorithm getKeyWrappingAlgorithm() {
        return this.keyWrappingAlgorithm;
    }

    public JweAlgorithmType getAlgorithmType() {
        return this.algorithmType;
    }

    public static JweAlgorithm parseAlgorithm(String jwaAlgorithmName) {
        for (JweAlgorithm alg : JweAlgorithm.values()) {
            if (!alg.jwaAlgorithmName.equals(jwaAlgorithmName)) continue;
            return alg;
        }
        if (RSAES_PKCS1_V1_5.name().equals(jwaAlgorithmName)) {
            return RSAES_PKCS1_V1_5;
        }
        throw new JweException("Unknown Encryption Algorithm, " + jwaAlgorithmName);
    }

    public String toString() {
        return this.jwaAlgorithmName;
    }
}

