/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.jwe;

import java.util.Locale;
import org.forgerock.json.jose.exceptions.JweException;

public enum EncryptionMethod {
    A128CBC_HS256("AES_128_CBC_HMAC_SHA_256", "AES/CBC/PKCS5Padding", "HMACSHA256", "AES", 16, 256),
    A192CBC_HS384("AES_192_CBC_HMAC_SHA_384", "AES/CBC/PKCS5Padding", "HMACSHA384", "AES", 24, 384),
    A256CBC_HS512("AES_256_CBC_HMAC_SHA_512", "AES/CBC/PKCS5Padding", "HMACSHA512", "AES", 32, 512),
    A128GCM("AES_128_GCM", "AES/GCM/NoPadding", null, "AES", 16, 128),
    A192GCM("AES_192_GCM", "AES/GCM/NoPadding", null, "AES", 24, 192),
    A256GCM("AES_256_GCM", "AES/GCM/NoPadding", null, "AES", 32, 256),
    CC20_P1305("AEAD_CHACHA20_POLY1305", "ChaCha7539", "Poly1305", "ChaCha7539", 32, 256),
    XC20_P1305("AEAD_XCHACHA20_POLY1305", "ChaCha7539", "Poly1305", "ChaCha7539", 32, 256);

    private final String name;
    private final String transformation;
    private final String macAlgorithm;
    private final String encryptionAlgorithm;
    private final int keyOffset;
    private final int keySize;

    private EncryptionMethod(String name, String transformation, String macAlgorithm, String encryptionAlgorithm, int keyOffset, int keySize) {
        this.name = name;
        this.transformation = transformation;
        this.macAlgorithm = macAlgorithm;
        this.encryptionAlgorithm = encryptionAlgorithm;
        this.keyOffset = keyOffset;
        this.keySize = keySize;
    }

    public String getName() {
        return this.name;
    }

    public String getTransformation() {
        return this.transformation;
    }

    public String getMacAlgorithm() {
        return this.macAlgorithm;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public int getKeyOffset() {
        return this.keyOffset;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public static EncryptionMethod parseMethod(String method) {
        try {
            return EncryptionMethod.valueOf(method.toUpperCase(Locale.ROOT).replaceAll("-", "_"));
        }
        catch (IllegalArgumentException e) {
            for (EncryptionMethod encryptionMethod : EncryptionMethod.values()) {
                if (!encryptionMethod.getName().equalsIgnoreCase(method)) continue;
                return encryptionMethod;
            }
            throw new JweException("Unknown Encryption Method, " + method);
        }
    }

    public String getJweStandardName() {
        return this.name().replace('_', '-');
    }

    public String toString() {
        return this.getJweStandardName();
    }
}

