/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.builders;

import org.forgerock.json.jose.builders.AbstractJwtBuilder;
import org.forgerock.json.jose.builders.EncryptedJwtBuilder;
import org.forgerock.json.jose.builders.EncryptedThenSignedJwtHeaderBuilder;
import org.forgerock.json.jose.builders.SignedJwtBuilder;
import org.forgerock.json.jose.jwe.EncryptedJwt;
import org.forgerock.json.jose.jws.EncryptedThenSignedJwt;
import org.forgerock.json.jose.jws.JwsAlgorithm;
import org.forgerock.json.jose.jws.JwsHeader;
import org.forgerock.json.jose.jws.SignedJwt;
import org.forgerock.json.jose.jws.handlers.SigningHandler;
import org.forgerock.json.jose.jwt.JwtType;

public class EncryptedThenSignedJwtBuilder
extends AbstractJwtBuilder
implements SignedJwtBuilder {
    private final EncryptedJwtBuilder encryptedJwtBuilder;
    private final SigningHandler signingHandler;
    private final JwsAlgorithm jwsAlgorithm;
    private final EncryptedThenSignedJwtHeaderBuilder headerBuilder;

    public EncryptedThenSignedJwtBuilder(EncryptedJwtBuilder encryptedJwtBuilder, SigningHandler signingHandler, JwsAlgorithm jwsAlgorithm) {
        this.encryptedJwtBuilder = encryptedJwtBuilder;
        this.signingHandler = signingHandler;
        this.jwsAlgorithm = jwsAlgorithm;
        this.headerBuilder = new EncryptedThenSignedJwtHeaderBuilder(this);
    }

    @Override
    public SignedJwt asJwt() {
        JwsHeader header = ((EncryptedThenSignedJwtHeaderBuilder)((EncryptedThenSignedJwtHeaderBuilder)this.headerBuilder.alg(this.jwsAlgorithm)).cty(JwtType.JWT.toString())).build();
        EncryptedJwt encryptedJwt = this.encryptedJwtBuilder.asJwt();
        return new EncryptedThenSignedJwt(header, encryptedJwt, this.signingHandler);
    }

    @Override
    public String build() {
        return this.asJwt().build();
    }

    public EncryptedThenSignedJwtHeaderBuilder headers() {
        return this.headerBuilder;
    }
}

