/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.jose.builders;

import java.security.Key;
import org.forgerock.json.jose.builders.AbstractJwtBuilder;
import org.forgerock.json.jose.builders.EncryptedThenSignedJwtBuilder;
import org.forgerock.json.jose.builders.JweHeaderBuilder;
import org.forgerock.json.jose.builders.JwtHeaderBuilder;
import org.forgerock.json.jose.builders.SignedEncryptedJwtBuilder;
import org.forgerock.json.jose.jwe.EncryptedJwt;
import org.forgerock.json.jose.jwe.JweHeader;
import org.forgerock.json.jose.jws.JwsAlgorithm;
import org.forgerock.json.jose.jws.handlers.SigningHandler;
import org.forgerock.json.jose.jwt.JwtClaimsSet;

public class EncryptedJwtBuilder
extends AbstractJwtBuilder {
    final Key publicKey;

    public EncryptedJwtBuilder(Key publicKey) {
        this.publicKey = publicKey;
    }

    public JweHeaderBuilder<? extends EncryptedJwtBuilder> headers() {
        this.setJwtHeaderBuilder(new JweHeaderBuilder<EncryptedJwtBuilder>(this));
        return (JweHeaderBuilder)this.getHeaderBuilder();
    }

    @Override
    public EncryptedJwtBuilder claims(JwtClaimsSet claimsSet) {
        return (EncryptedJwtBuilder)super.claims(claimsSet);
    }

    @Deprecated
    public SignedEncryptedJwtBuilder sign(SigningHandler signingHandler, JwsAlgorithm jwsAlgorithm) {
        return new SignedEncryptedJwtBuilder(this, signingHandler, jwsAlgorithm);
    }

    public EncryptedThenSignedJwtBuilder signedWith(SigningHandler signingHandler, JwsAlgorithm jwsAlgorithm) {
        return new EncryptedThenSignedJwtBuilder(this, signingHandler, jwsAlgorithm);
    }

    @Override
    public EncryptedJwt asJwt() {
        JwtHeaderBuilder<?, ?> headerBuilder = this.getHeaderBuilder();
        JweHeader header = headerBuilder == null ? new JweHeader() : (JweHeader)this.getHeaderBuilder().build();
        JwtClaimsSet claimsSet = this.getClaimsSet();
        if (claimsSet == null) {
            claimsSet = new JwtClaimsSet();
        }
        return new EncryptedJwt(header, claimsSet, this.publicKey);
    }

    @Override
    public String build() {
        return this.asJwt().build();
    }
}

