/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.forgerock.json.JsonPatch;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValueException;
import org.forgerock.util.Function;
import org.forgerock.util.RangeSet;

public class JsonValue
implements Cloneable,
Iterable<JsonValue> {
    private Object object;
    private JsonPointer pointer;

    public static List<Object> array(Object ... objects) {
        ArrayList<Object> array = new ArrayList<Object>(objects.length);
        for (Object o : objects) {
            array.add(JsonValue.unwrap(o));
        }
        return array;
    }

    public static Map.Entry<String, Object> fieldIfNotNull(String key, Object value) {
        return value != null ? JsonValue.field(key, value) : null;
    }

    public static Map.Entry<String, Object> field(String key, Object value) {
        return new AbstractMap.SimpleImmutableEntry<String, Object>(key, JsonValue.unwrap(value));
    }

    public static JsonValue json(Object object) {
        return new JsonValue(JsonValue.unwrap(object));
    }

    @SafeVarargs
    public static Map<String, Object> object(Map.Entry<String, Object> ... fields) {
        Map<String, Object> object = JsonValue.object(fields.length);
        for (Map.Entry<String, Object> field : fields) {
            if (field == null) continue;
            object.put(field.getKey(), JsonValue.unwrap(field.getValue()));
        }
        return object;
    }

    public static Map<String, Object> object(int size) {
        return new LinkedHashMap<String, Object>(size);
    }

    public static int toIndex(String key) {
        if (key == null || key.isEmpty()) {
            return -1;
        }
        int result = 0;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c < '0' || c > '9') {
                return -1;
            }
            result = result * 10 + (c - 48);
        }
        return result;
    }

    private static Object unwrap(Object object) {
        return object instanceof JsonValue ? ((JsonValue)object).getObject() : object;
    }

    public JsonValue(Object object) {
        this(object, null);
    }

    public JsonValue(Object object, JsonPointer pointer) {
        this.object = object;
        this.pointer = pointer;
        if (object instanceof JsonValue) {
            JsonValue jv = (JsonValue)object;
            this.object = jv.object;
            if (pointer == null) {
                this.pointer = jv.pointer;
            }
        }
        if (this.pointer == null) {
            this.pointer = new JsonPointer();
        }
    }

    public JsonValue add(int index, Object object) {
        List<Object> list = this.required().asList();
        if (index < 0 || index > list.size()) {
            throw new JsonValueException(this, "List index out of range: " + index);
        }
        list.add(index, JsonValue.unwrap(object));
        return this;
    }

    public JsonValue add(JsonPointer pointer, Object object) {
        this.navigateToParentOf(pointer).required().addToken(pointer.leaf(), object);
        return this;
    }

    public JsonValue add(Object object) {
        if (this.isList()) {
            return this.add(this.size(), object);
        }
        throw new JsonValueException(this, "Expecting a List");
    }

    public JsonValue add(String key, Object object) {
        if (this.isMap()) {
            Map<String, Object> map = this.asMap();
            if (map.containsKey(key)) {
                throw new JsonValueException(this, "Map key " + key + " already exists");
            }
            map.put(key, JsonValue.unwrap(object));
        } else if (this.isList()) {
            this.add(JsonValue.toIndex(key), object);
        } else {
            throw new JsonValueException(this, "Expecting a Map or List");
        }
        return this;
    }

    public JsonValue addPermissive(JsonPointer pointer, Object object) {
        this.navigateToParentOfPermissive(pointer).addToken(pointer.leaf(), object);
        return this;
    }

    public Boolean asBoolean() {
        return this.object == null ? null : (Boolean)this.expect(Boolean.class).object;
    }

    public Double asDouble() {
        return this.object == null ? null : Double.valueOf(this.asNumber().doubleValue());
    }

    public Integer asInteger() {
        return this.object == null ? null : Integer.valueOf(this.asNumber().intValue());
    }

    public Collection<Object> asCollection() {
        return this.asCollection(Object.class);
    }

    public List<Object> asList() {
        return this.asList(Object.class);
    }

    public <E> Collection<E> asCollection(Class<E> type) {
        if (this.object != null) {
            this.expect(Collection.class);
            if (type != Object.class) {
                Collection coll = (Collection)this.object;
                for (Object element : coll) {
                    if (element == null || type.isInstance(element)) continue;
                    throw new JsonValueException(this, "Expecting a Collection of " + type.getName() + " elements");
                }
            }
        }
        return (Collection)this.object;
    }

    public <E> List<E> asList(Class<E> type) {
        if (this.object != null) {
            this.expect(List.class);
            if (type != Object.class) {
                List list = (List)this.object;
                for (Object element : list) {
                    if (element == null || type.isInstance(element)) continue;
                    throw new JsonValueException(this, "Expecting a List of " + type.getName() + " elements");
                }
            }
        }
        return (List)this.object;
    }

    public <V, E extends Exception> V as(Function<JsonValue, V, E> transformFunction) throws E {
        return transformFunction.apply(this);
    }

    public Long asLong() {
        return this.object == null ? null : Long.valueOf(this.asNumber().longValue());
    }

    public Map<String, Object> asMap() {
        return this.object == null ? null : (Map)this.expect(Map.class).object;
    }

    public <V> Map<String, V> asMap(Class<V> type) {
        if (this.object != null) {
            this.expect(Map.class);
            if (type != Object.class) {
                Map map = (Map)this.object;
                for (Object element : map.values()) {
                    if (element == null || type.isInstance(element)) continue;
                    throw new JsonValueException(this, "Expecting a Map of " + type.getName() + " elements");
                }
            }
        }
        return (Map)this.object;
    }

    public <E> Map<String, List<E>> asMapOfList(Class<E> elementType) {
        if (this.object != null) {
            this.expect(Map.class);
            if (elementType != Object.class) {
                Map map = (Map)this.object;
                for (Object value : map.values()) {
                    if (value != null && !(value instanceof List)) {
                        throw new JsonValueException(this, "Expecting a Map of List values");
                    }
                    List list = (List)value;
                    for (Object element : list) {
                        if (element == null || elementType.isInstance(element)) continue;
                        throw new JsonValueException(this, "Expecting a Map of Lists with " + elementType.getName() + " elements");
                    }
                }
            }
        }
        return (Map)this.object;
    }

    public Number asNumber() {
        return this.object == null ? (Number)null : (Number)((Number)this.expect(Number.class).object);
    }

    public String asString() {
        return this.object == null ? null : (String)this.expect(String.class).object;
    }

    public void clear() {
        if (this.isMap()) {
            this.asMap().clear();
        } else if (this.isCollection()) {
            this.asCollection().clear();
        }
    }

    public JsonValue clone() {
        JsonValue result = new JsonValue(this.object, this.pointer);
        if (this.isMap()) {
            result.object = new LinkedHashMap<String, Object>(this.asMap());
        } else if (this.isList()) {
            result.object = new ArrayList<Object>(this.asList());
        }
        return result;
    }

    public boolean contains(Object object) {
        boolean result = false;
        if (this.isMap()) {
            result = this.asMap().containsValue(object);
        } else if (this.isCollection()) {
            result = this.asCollection().contains(object);
        }
        return result;
    }

    public JsonValue copy() {
        JsonValue result = new JsonValue(this.object, this.pointer);
        if (this.isMap()) {
            Map<String, Object> map = JsonValue.object(this.size());
            for (String key : this.keys()) {
                map.put(key, this.get(key).copy().getObject());
            }
            result.object = map;
        } else if (this.isList()) {
            ArrayList<Object> list = new ArrayList<Object>(this.size());
            for (JsonValue element : this) {
                list.add(element.copy().getObject());
            }
            result.object = list;
        }
        return result;
    }

    public JsonValue defaultTo(Object object) {
        return this.object != null ? this : new JsonValue(object, this.pointer);
    }

    public JsonValue expect(Class<?> type) {
        if (this.object != null && !type.isInstance(this.object)) {
            throw new JsonValueException(this, "Expecting a " + type.getName());
        }
        return this;
    }

    public JsonValue get(int index) {
        List<Object> list;
        Object result = null;
        if (index < 0) {
            throw new JsonValueException(this, "List index out of range: " + index);
        }
        if (this.isList() && index >= 0 && index < (list = this.asList()).size()) {
            result = list.get(index);
        }
        return new JsonValue(result, this.pointer.child(index));
    }

    public JsonValue get(JsonPointer pointer) {
        JsonValue result = this;
        for (String token : pointer) {
            JsonValue member = result.get(token);
            if (member.isNull() && !result.isDefined(token)) {
                return null;
            }
            result = member;
        }
        return result;
    }

    public JsonValue get(String key) {
        Object result = null;
        if (this.isMap()) {
            result = this.asMap().get(key);
        } else if (this.isList()) {
            List<Object> list = this.asList();
            int index = JsonValue.toIndex(key);
            if (index >= 0 && index < list.size()) {
                result = list.get(index);
            }
        }
        return new JsonValue(result, this.pointer.child(key));
    }

    public Object getObject() {
        return this.object;
    }

    public JsonPointer getPointer() {
        return this.pointer;
    }

    public boolean isBoolean() {
        return this.object != null && this.object instanceof Boolean;
    }

    public boolean isDefined(String key) {
        boolean result = false;
        if (this.isMap()) {
            result = this.asMap().containsKey(key);
        } else if (this.isList()) {
            int index = JsonValue.toIndex(key);
            result = index >= 0 && index < this.asList().size();
        }
        return result;
    }

    public boolean isCollection() {
        return this.object instanceof Collection;
    }

    public boolean isList() {
        return this.object instanceof List;
    }

    public boolean isMap() {
        return this.object instanceof Map;
    }

    public boolean isNull() {
        return this.object == null;
    }

    public boolean isNotNull() {
        return !this.isNull();
    }

    public boolean isNumber() {
        return this.object != null && this.object instanceof Number;
    }

    public boolean isString() {
        return this.object != null && this.object instanceof String;
    }

    @Override
    public Iterator<JsonValue> iterator() {
        if (this.isList()) {
            return new Iterator<JsonValue>(){
                int cursor = 0;
                Iterator<Object> i = JsonValue.this.asList().iterator();

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public JsonValue next() {
                    Object element = this.i.next();
                    return new JsonValue(element, JsonValue.this.pointer.child(this.cursor++));
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return new Iterator<JsonValue>(){
            Iterator<String> i;
            {
                this.i = JsonValue.this.keys().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public JsonValue next() {
                return JsonValue.this.get(this.i.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Set<String> keys() {
        if (this.isMap()) {
            return this.asMap().keySet();
        }
        if (this.isList()) {
            return new AbstractSet<String>(){
                final RangeSet range;
                {
                    this.range = new RangeSet(JsonValue.this.size());
                }

                @Override
                public boolean contains(Object o) {
                    boolean result = false;
                    if (o instanceof String) {
                        try {
                            result = this.range.contains(Integer.valueOf((String)o));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    return result;
                }

                @Override
                public Iterator<String> iterator() {
                    return new Iterator<String>(){
                        Iterator<Integer> i;
                        {
                            this.i = range.iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public String next() {
                            return this.i.next().toString();
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return this.range.size();
                }
            };
        }
        return Collections.emptySet();
    }

    public JsonValue put(int index, Object object) {
        List<Object> list = this.required().asList();
        if (index < 0 || index > list.size()) {
            throw new JsonValueException(this, "List index out of range: " + index);
        }
        if (index == list.size()) {
            list.add(JsonValue.unwrap(object));
        } else {
            list.set(index, JsonValue.unwrap(object));
        }
        return this;
    }

    public JsonValue put(JsonPointer pointer, Object object) {
        this.navigateToParentOf(pointer).required().putToken(pointer.leaf(), object);
        return this;
    }

    public JsonValue put(String key, Object object) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.isMap()) {
            this.asMap().put(key, JsonValue.unwrap(object));
        } else if (this.isList()) {
            this.put(JsonValue.toIndex(key), object);
        } else {
            throw new JsonValueException(this, "Expecting a Map or List");
        }
        return this;
    }

    public JsonValue putPermissive(JsonPointer pointer, Object object) {
        this.navigateToParentOfPermissive(pointer).putToken(pointer.leaf(), object);
        return this;
    }

    public void remove(int index) {
        List<Object> list;
        if (index >= 0 && this.isList() && index < (list = this.asList()).size()) {
            list.remove(index);
        }
    }

    public void remove(JsonPointer pointer) {
        this.navigateToParentOf(pointer).remove(pointer.leaf());
    }

    public void remove(String key) {
        if (this.isMap()) {
            this.asMap().remove(key);
        } else if (this.isList()) {
            this.remove(JsonValue.toIndex(key));
        }
    }

    public JsonValue required() {
        if (this.object == null) {
            throw new JsonValueException(this, "Expecting a value");
        }
        return this;
    }

    public void setObject(Object object) {
        this.object = object;
        if (object instanceof JsonValue) {
            JsonValue jv = (JsonValue)object;
            this.object = jv.object;
        }
    }

    public int size() {
        if (this.isMap()) {
            return this.asMap().size();
        }
        if (this.isCollection()) {
            return this.asCollection().size();
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isNull()) {
            sb.append("null");
        } else if (this.isMap()) {
            sb.append("{ ");
            Map map = (Map)this.object;
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                Object key = i.next();
                sb.append('\"');
                JsonValue.appendEscapedString(sb, key.toString());
                sb.append("\": ");
                sb.append(new JsonValue(map.get(key)).toString());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(" }");
        } else if (this.isCollection()) {
            sb.append("[ ");
            Iterator i = ((Collection)this.object).iterator();
            while (i.hasNext()) {
                sb.append(new JsonValue(i.next()).toString());
                if (!i.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(" ]");
        } else if (this.isString()) {
            sb.append('\"');
            JsonValue.appendEscapedString(sb, this.object.toString());
            sb.append('\"');
        } else {
            sb.append(this.object.toString());
        }
        return sb.toString();
    }

    private static void appendEscapedString(StringBuilder sb, String s) {
        int size = s.length();
        block9: for (int i = 0; i < size; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                default: {
                    if (Character.isISOControl(c)) {
                        String hex = Integer.toHexString(c).toUpperCase(Locale.ENGLISH);
                        int hexPadding = 4 - hex.length();
                        sb.append("\\u");
                        for (int j = 0; j < hexPadding; ++j) {
                            sb.append('0');
                        }
                        sb.append(hex);
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
    }

    private void addToken(String token, Object object) {
        if (this.isEndOfListToken(token) && this.isList()) {
            this.add(object);
        } else {
            this.add(token, object);
        }
    }

    private boolean isEndOfListToken(String token) {
        return token.equals("-");
    }

    private boolean isIndexToken(String token) {
        if (token.isEmpty()) {
            return false;
        }
        for (int i = 0; i < token.length(); ++i) {
            char c = token.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private JsonValue navigateToParentOf(JsonPointer pointer) {
        JsonValue jv = this;
        int size = pointer.size();
        for (int n = 0; n < size - 1 && !(jv = jv.get(pointer.get(n))).isNull(); ++n) {
        }
        return jv;
    }

    private JsonValue navigateToParentOfPermissive(JsonPointer pointer) {
        JsonValue jv = this;
        int size = pointer.size();
        for (int n = 0; n < size - 1; ++n) {
            String token = pointer.get(n);
            JsonValue next = jv.get(token);
            if (next.isNotNull()) {
                jv = next;
                continue;
            }
            if (this.isIndexToken(token)) {
                throw new JsonValueException(this, "Expecting a value");
            }
            String nextToken = pointer.get(n + 1);
            if (this.isEndOfListToken(nextToken)) {
                jv.add(token, new ArrayList());
                jv = jv.get(token);
                continue;
            }
            if (this.isIndexToken(nextToken)) {
                throw new JsonValueException(this, "Expecting a value");
            }
            jv.putPermissive(new JsonPointer(token), new LinkedHashMap());
            jv = jv.get(token);
        }
        return jv;
    }

    private void putToken(String token, Object object) {
        if (this.isEndOfListToken(token) && this.isList()) {
            this.add(object);
        } else {
            this.put(token, object);
        }
    }

    public boolean isEqualTo(JsonValue other) {
        return JsonPatch.isEqual(this, other);
    }

    public JsonValue diff(JsonValue target) {
        return JsonPatch.diff(this, target);
    }

    public void patch(JsonValue patch) {
        JsonPatch.patch(this, patch);
    }

    public Stream<JsonValue> stream() {
        if (this.isList()) {
            List<Object> list = this.asList();
            return IntStream.range(0, list.size()).mapToObj(i -> new JsonValue(list.get(i), this.pointer.child(i)));
        }
        if (this.isCollection()) {
            throw new UnsupportedOperationException("Non-List Collections cannot be streamed");
        }
        if (this.isMap()) {
            return this.asMap().entrySet().stream().map(e -> new JsonValue(e.getValue(), this.pointer.child((String)e.getKey())));
        }
        return Stream.of(this);
    }
}

