/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.i18n;

import java.io.Serializable;
import java.util.Formattable;
import java.util.Formatter;
import java.util.IllegalFormatException;
import java.util.Locale;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.i18n.LocalizableMessageDescriptor;

public final class LocalizableMessage
implements CharSequence,
Formattable,
Comparable<LocalizableMessage>,
Serializable {
    private static final long serialVersionUID = 8011606572832995899L;
    public static final LocalizableMessage EMPTY = LocalizableMessage.raw("", new Object[0]);
    private static final boolean IS_AIX_POST5 = LocalizableMessage.isAIXPost5();
    private final LocalizableMessageDescriptor.AbstractLocalizableMessageDescriptor descriptor;
    private final Object[] args;

    public static LocalizableMessage raw(CharSequence formatString, Object ... args) {
        if (formatString == null) {
            throw new NullPointerException("formatString was null");
        }
        if (args == null || args.length == 0) {
            return LocalizableMessageDescriptor.RAW0.get(formatString);
        }
        return new LocalizableMessageDescriptor.Raw(formatString).get(args);
    }

    public static LocalizableMessage valueOf(Object object) {
        if (object instanceof LocalizableMessage) {
            return (LocalizableMessage)object;
        }
        if (object instanceof LocalizableMessageBuilder) {
            return ((LocalizableMessageBuilder)object).toMessage();
        }
        return LocalizableMessage.raw(String.valueOf(object), new Object[0]);
    }

    private static boolean isAIXPost5() {
        boolean isJDK15 = false;
        try {
            String javaRelease = System.getProperty("java.version");
            isJDK15 = javaRelease.startsWith("1.5");
        }
        catch (Throwable t) {
            System.err.println("Cannot get the java version: " + t);
        }
        boolean isAIX = "aix".equalsIgnoreCase(System.getProperty("os.name"));
        return !isJDK15 && isAIX;
    }

    LocalizableMessage(LocalizableMessageDescriptor.AbstractLocalizableMessageDescriptor descriptor, Object ... args) {
        this.descriptor = descriptor;
        this.args = args;
    }

    @Override
    public char charAt(int index) {
        return this.charAt(Locale.getDefault(), index);
    }

    public char charAt(Locale locale, int index) {
        return this.toString(locale).charAt(index);
    }

    @Override
    public int compareTo(LocalizableMessage message) {
        return this.toString().compareTo(message.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LocalizableMessage) {
            LocalizableMessage message = (LocalizableMessage)o;
            return this.toString().equals(message.toString());
        }
        return false;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        Locale l = formatter.locale();
        formatter.format(l, this.descriptor.getFormatString(l), this.args);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public int length() {
        return this.length(Locale.getDefault());
    }

    public int length(Locale locale) {
        return this.toString(locale).length();
    }

    public int ordinal() {
        return this.descriptor.ordinal();
    }

    public String resourceName() {
        return this.descriptor.resourceName();
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.subSequence(Locale.getDefault(), start, end);
    }

    public CharSequence subSequence(Locale locale, int start, int end) {
        return this.toString(locale).subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.toString(Locale.getDefault());
    }

    public String toString(Locale locale) {
        String s;
        block10: {
            String fmt = this.descriptor.getFormatString(locale);
            if (this.descriptor.requiresFormatter()) {
                try {
                    if (IS_AIX_POST5) {
                        boolean changeType = false;
                        for (Object o : this.args) {
                            if (!(o instanceof Formattable)) continue;
                            changeType = true;
                            break;
                        }
                        if (changeType) {
                            Object[] newArgs = new Object[this.args.length];
                            for (int i = 0; i < this.args.length; ++i) {
                                newArgs[i] = this.args[i] instanceof Formattable ? this.args[i].toString() : this.args[i];
                            }
                            s = new Formatter(locale).format(locale, fmt, newArgs).toString();
                        } else {
                            s = new Formatter(locale).format(locale, fmt, this.args).toString();
                        }
                        break block10;
                    }
                    s = new Formatter(locale).format(locale, fmt, this.args).toString();
                }
                catch (IllegalFormatException e) {
                    s = fmt;
                }
            } else {
                s = fmt;
            }
        }
        if (s == null) {
            s = "";
        }
        return s;
    }
}

